;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/R5rs/prefs5.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  William Clinger                                   */
;*    Creation    :  Sat Mar 21 17:21:26 1998                          */
;*    Last change :  Sat Mar 21 18:19:46 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*  Copyright 1992 William Clinger                                     */
;*                                                                     */
;*  Permission to copy this software, in whole or in part, to use this */
;*  software for any lawful purpose, and to redistribute this software */
;*  is granted subject to the restriction that all copies made of this */
;*  software must include this copyright notice in full.               */
;*                                                                     */
;*  I also request that you send me a copy of any improvements that you*/
;*  make to this software so that they may be incorporated within it to*/
;*  the benefit of the Scheme community.                               */
;*                                                                     */
;*  Implementation-dependent parameters and preferences that determine */
;*  how identifiers are represented in the output of the macro         */
;*  expander.                                                          */
;*                                                                     */
;*  The basic problem is that there are no reserved words, so the      */
;*  syntactic keywords of core Scheme that are used to express the     */
;*  output need to be represented by data that cannot appear in the    */
;*  input.  This file defines those data.                              */
;*  The following definitions assume that identifiers of mixed case    */
;*  cannot appear in the input.                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __r5_syntax_prefs
   
   (use    (__type                       "Llib/type.scm")
           (__error                      "Llib/error.scm")
           (__bigloo                     "Llib/bigloo.scm")
           (__tvector                    "Llib/tvector.scm")
           (__structure                  "Llib/struct.scm")
           (__tvector                    "Llib/tvector.scm")
           (__bexit                      "Llib/bexit.scm")
            
           (__reader                     "Read/reader.scm")

           (__rgc                        "Rgc/runtime.scm")
            
           (__r4_numbers_6_5             "Ieee/number.scm")
           (__r4_numbers_6_5_fixnum      "Ieee/fixnum.scm")
           (__r4_numbers_6_5_flonum      "Ieee/flonum.scm")
           (__r4_characters_6_6          "Ieee/char.scm")
           (__r4_equivalence_6_2         "Ieee/equiv.scm")
           (__r4_booleans_6_1            "Ieee/boolean.scm")
           (__r4_symbols_6_4             "Ieee/symbol.scm")
           (__r4_strings_6_7             "Ieee/string.scm")
           (__r4_pairs_and_lists_6_3     "Ieee/pair-list.scm")
           (__r4_input_6_10_2            "Ieee/input.scm")
           (__r4_control_features_6_9    "Ieee/control.scm")
           (__r4_vectors_6_8             "Ieee/vector.scm")
           (__r4_ports_6_10_1            "Ieee/port.scm")
           (__r4_output_6_10_3           "Ieee/output.scm"))
   
   (export begin1
	   define1
	   quote1
	   lambda1
	   if1
	   set!1
	   undefined1
	   suffix-character))

(define begin1  (string->symbol "BEGIN"))
(define define1 (string->symbol "DEFINE"))
(define quote1  (string->symbol "QUOTE"))
(define lambda1 (string->symbol "LAMBDA"))
(define if1     (string->symbol "IF"))
(define set!1   (string->symbol "SET!"))

; The following defines an implementation-dependent expression
; that evaluates to an undefined (not unspecified!) value, for
; use in expanding the (define x) syntax.

(define undefined1 (list #unspecified))

; A variable is renamed by suffixing a vertical bar followed by a unique
; integer.  In IEEE and R4RS Scheme, a vertical bar cannot appear as part
; of an identifier, but presumably this is enforced by the reader and not
; by the compiler.  Any other character that cannot appear as part of an
; identifier may be used instead of the vertical bar.

(define suffix-character #\|)
