;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/recette/rgc.scm                      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Sep  8 11:03:03 1994                          */
;*    Last change :  Tue Jul 11 16:13:48 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Quelques tests d'rgc                                             */
;*=====================================================================*/


;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module rgc)

;; cette grammaire plante tous les bigloo (a la compilation)
;; jusqu'a la version 1.6c
(regular-grammar 
      ((sign (in #\+ #\-))
       (optsign (* 1 sign))
       (octdigit (>-< #\0 #\7)))
   ((#\0 optsign octdigit)
    0))

(regular-grammar ()
   ((#\a (? #\b) #\c)
    0))

(regular-grammar ()
   (((? #\a) #\b #\c)
    0))

(regular-grammar ()
   ((#\a #\b (? #\c))
    0))

;; une grammaire qui ne se compilait pas lors du permier boot de bigloo1.8
(define *std-grammar*
   (regular-grammar ((chiffre (>-< #\0 #\9))
		     (lettre  (>-< #\a #\z #\A #\Z #a128 #a255))
		     (special (in #\! #\@ #\~ #\$ #\%
				  #\^ #\& #\* #\> #\<
				  #\/ #\. #\- #\_ #\+   
				  #\\ #\| #\= #\? #\:))
		     (id      ((! lettre chiffre special)
			       (* (! lettre chiffre special #\, #\' #\`)))))
      ((#\# #\a chiffre chiffre chiffre)
       ;; character ascii forms
       0)
      ((";" (* (all)))
       ;; commets
       (ignore))
      ((#\# (! id (#\. (+ #\.))) #\()
       ;; typed vectors beginning
       1)
      (else
       2)))

