;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Module/pragma.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jun  7 08:44:07 1996                          */
;*    Last change :  Thu Aug  8 16:49:11 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The pragma clause compilation                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_pragma
   (import module_module
	   tools_error
	   type_type
	   engine_param
	   ast_var
	   ast_env
	   ast_remove
	   type_env)
   (export (make-pragma-compiler)
	   (pragma-finalizer)))

;*---------------------------------------------------------------------*/
;*    make-pragma-compiler ...                                         */
;*---------------------------------------------------------------------*/
(define (make-pragma-compiler)
   (instantiate::ccomp (id 'pragma)
		       (producer  (pragma-producer *module*))
		       (consumer  (lambda (m c)
				     ((pragma-producer m) c)))
		       (finalizer pragma-finalizer)))

;*---------------------------------------------------------------------*/
;*    pragma-producer ...                                              */
;*---------------------------------------------------------------------*/
(define (pragma-producer module)
   (lambda (clause)
      (match-case clause
	 ((?- . ?protos)
	  (for-each (lambda (proto) (pragma-parser proto module clause))
		    protos)
	  '())
	 (else
	  (user-error "Parse error"
		      (string-append "Illegal `pragma' clause")
		      clause
		      '())))))
   
;*---------------------------------------------------------------------*/
;*    pragma-parser ...                                                */
;*---------------------------------------------------------------------*/
(define (pragma-parser proto module clause)
   (match-case proto
      (((and ?id (? symbol?)) . ?prop)
       (set! *pragma-list* (cons (list id module prop clause) *pragma-list*)))
      (else
       (user-error "Parse error" "Illegal `pragma' clause" clause '()))))

;*---------------------------------------------------------------------*/
;*    *pragma-list* ...                                                */
;*---------------------------------------------------------------------*/
(define *pragma-list* '())

;*---------------------------------------------------------------------*/
;*    pragma-finalizer ...                                             */
;*---------------------------------------------------------------------*/
(define (pragma-finalizer)
   (for-each (lambda (pragma)
		(match-case pragma
		   ((?id ?module ?prop* ?clause)
		    (let ((global (let ((global (find-global id module)))
				     (if (global? global)
					 global
					 (find-global id 'foreign)))))
		       (if (not (global? global))
			   (warning "pragma-finalizer"
				    "Can't find global variable -- "
				    `(@ ,id ,module))
			   (set-pragma-properties! global prop* clause))))
		   (else
		    (internal-error "pragma-finalizer"
				    "Illegal `pragma' finalizer form"
				    pragma))))
	     *pragma-list*)
   (set! *pragma-list* '())
   'void)

;*---------------------------------------------------------------------*/
;*    set-pragma-properties! ...                                       */
;*---------------------------------------------------------------------*/
(define (set-pragma-properties! global prop* clause)
   (for-each (lambda (prop) (set-pragma-property! global prop clause))
	     prop*))
 
;*---------------------------------------------------------------------*/
;*    set-pragma-property! ...                                         */
;*---------------------------------------------------------------------*/
(define (set-pragma-property! global prop clause)
   (match-case prop
      ((? symbol?)
       (case prop
	  ;; the side-effect-free pragma
	  ((side-effect-free)
	   (let ((value (global-value global)))
	      (if (not (fun? value))
		  (user-error "pragma"
			      "property is not concerning a function"
			      prop
			      '())
		  (fun-side-effect?-set! value #f))))
	  ;; the no-cfa-top pragma
	  ((no-cfa-top)
	   (let ((value (global-value global)))
	      (if (not (fun? value))
		  (user-error "pragma"
			      "property is not concerning a function"
			      prop
			      '())
		  (fun-top?-set! value #f))))
	  ((no-trace)
	   (let ((value (global-value global)))
	      (if (not (sfun? value))
		  (user-error "pragma"
			      "property is not concerning a sfunction"
			      prop
			      '())
		  (sfun-property-set! value (cons prop
						  (sfun-property value))))))
	  (else
	   (user-error "Parse error" "Illegal `pragma' form" clause '()))))
      (((and (? symbol?) ?key) (and (? symbol?) ?value))
       (case key
	  ;; the predicate-of pragma
	  ((predicate-of)
	   (let ((type  (use-type! value))
		 (value (global-value global)))
	      (if (not (fun? value))
		  (user-error "pragma"
			      "predicate is not associated to a function"
			      prop
			      '())
		  (begin
		     (fun-predicate-of-set! value type)
		     ;; predicate cannot be remove until
		     ;; coercers introduction pass
		     (remove-var-from! 'coerce global)
		     ;; furthermore a predicate is _always_
		     ;; free of side effects
		     (fun-side-effect?-set! value #f)))))
	  ;; the stack-alloc pragma
	  ((stack-alloc)
	   (let ((stack-alloc (find-global value (global-module global))))
	      (cond
		 ((not (global? stack-alloc))
		  (user-error "pragma"
			      "Can't find stack allocator"
			      prop
			      '()))
		 ((not (fun? (global-value global)))
		  (user-error "pragma"
			      "alloctor is not a function"
			      prop
			      '()))
		 (else
		  ;; stack allocators cannot be remove before
		  ;; the stack alloction pass.
		  (if *optim-stack?* (remove-var-from! 'cfa stack-alloc))
		  ;; we set the pragma property
		  (fun-stack-allocator-set! (global-value global)
					    stack-alloc)))))
	  (else
	   (user-error "Parse error" "Illegal `pragma' form" prop '()))))
      (else
       (user-error "Parse error"
		   "Illegal `pragma' form"
		   (if (pair? prop) prop clause)
		   '()))))
	 
