;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Ast/venv.scm                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Dec 25 11:32:49 1994                          */
;*    Last change :  Thu Feb 19 18:33:55 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The global environment manipulation                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_env
   (import  tools_shape
	    engine_param
	    tools_error
	    type_type
	    type_cache
	    ast_var
	    (*module* module_module))
   (export  (initialize-Genv!)
	    (set-Genv!              <Genv>)
	    (get-Genv) 
	    (find-global            ::symbol . <symbol>)
	    (bind-global!::global   ::symbol ::symbol ::value ::symbol ::obj)
	    (unbind-global!         ::symbol ::symbol)
	    (for-each-global!       ::procedure)
	    (global-bucket-position ::symbol ::symbol)))

;*---------------------------------------------------------------------*/
;*    *Genv* ...                                                       */
;*    -------------------------------------------------------------    */
;*    The Global environment (for global variable definitions).        */
;*---------------------------------------------------------------------*/
(define *Genv* 'the-global-environment)

;*---------------------------------------------------------------------*/
;*    get-hash-number ...                                              */
;*---------------------------------------------------------------------*/
(define (get-hash-number o)
   (string->0..2^x-1 (symbol->string o) 12))

;*---------------------------------------------------------------------*/
;*    set-Genv! ...                                                    */
;*---------------------------------------------------------------------*/
(define (set-Genv! Genv)
   (set! *Genv* Genv)
   (struct-set! *Genv* 2 get-hash-number)
   (struct-set! *Genv* 3 car)
   (struct-set! *Genv* 5 eq?))
		 
;*---------------------------------------------------------------------*/
;*    get-Genv ...                                                     */
;*---------------------------------------------------------------------*/
(define (get-Genv)
   (struct-set! *Genv* 2 'get-hash-number)
   (struct-set! *Genv* 3 'car)
   (struct-set! *Genv* 5 'eq?)
   *Genv*)

;*---------------------------------------------------------------------*/
;*    initialize-Genv! ...                                             */
;*---------------------------------------------------------------------*/
(define (initialize-Genv!)
   (set! *Genv* (make-hash-table 4096 get-hash-number car eq? 1024)))

;*---------------------------------------------------------------------*/
;*    find-global ...                                                  */
;*---------------------------------------------------------------------*/
(define (find-global id::symbol . module)
   [assert (module) (or (null? module) (symbol? (car module)))]
   (let ((bucket (get-hash id *Genv*))
	 (module (if (null? module) '() (car module))))
      (cond
	 ((not (pair? bucket))
	  #f)
	 ((null? (cdr bucket))
	  #f)
	 ((null? module)
	  (cadr bucket))
	 (else
	  (let loop ((globals (cdr bucket)))
	     (cond
		((null? globals)
		 #f)
		((eq? (global-module (car globals)) module)
		 (car globals))
		(else
		 (loop (cdr globals)))))))))

;*---------------------------------------------------------------------*/
;*    bind-global! ...                                                 */
;*    -------------------------------------------------------------    */
;*    When binding a global, if a previous global with the same id     */
;*    has already been bound, we follow the two rules:                 */
;*       1- if module is the name of the current module, the global    */
;*          is added at the head of the list.                          */
;*       2- if module is not the name of the current module, the       */
;*          global is not added at the head of the list (practically,  */
;*          it is added in second position).                           */
;*    Moreover, because we have add a lot of confusion because of this */
;*    we always check if we are redefining a foreign function with a   */
;*    Scheme function. In such a situation, we raise a warning.        */
;*---------------------------------------------------------------------*/
(define (bind-global!::global id::symbol
			      module::symbol
			      value::value
			      import::symbol
			      src::obj)
   (let ((global (find-global id module)))
      ;; If the current module if not foreign we make the foreign check
      ;; descibed above
      (if (not (eq? module 'foreign))
	  (let ((old-foreign (find-global id 'foreign)))
	     (if (global? old-foreign)
		 (user-warning id
			       "Scheme declaration overrides foreign declaration"
			       src))))
      ;; Now we keep going we the other check.
      (if (global? global)
	  (if (not *lib-mode*)
	      (user-error id "Illegal global redefinition" src)
	      global)
	  (let ((new    (instantiate::global (module module)
					     (id id)
					     (value value)
					     (src src)
					     (import import)))
		(bucket (get-hash id *Genv*)))
	     (cond
		((not (pair? bucket))
		 (put-hash! (list id new) *Genv*))
		((eq? module *module*)
		 (let ((new-bucket (cons new (cdr bucket))))
		    (set-cdr! bucket new-bucket)))
		(else
		 (set-cdr! (cdr bucket) (cons new (cddr bucket)))))
	     new))))
 
;*---------------------------------------------------------------------*/
;*    unbind-global! ...                                               */
;*---------------------------------------------------------------------*/
(define (unbind-global! id::symbol module::symbol)
   (let ((global (find-global id module)))
      (if (not (global? global))
	  (user-error "unbind-global!" "Can't find global" `(@ ,id ,module))
	  (let ((bucket (get-hash id *Genv*)))
	     (let loop ((cur  (cdr bucket))
			(prev bucket))
		(if (eq? (car cur) global)
		    (set-cdr! prev (cdr cur))
		    (loop (cdr cur) (cdr prev))))))))
   
;*---------------------------------------------------------------------*/
;*    for-each-global! ...                                             */
;*---------------------------------------------------------------------*/
(define (for-each-global! proc::procedure)
   (for-each-hash (lambda (bucket) (for-each proc (cdr bucket)))
		  *Genv*))
   
;*---------------------------------------------------------------------*/
;*    global-bucket-position                                           */
;*---------------------------------------------------------------------*/
(define (global-bucket-position id module)
   (let ((bucket (get-hash id *Genv*)))
      (if (not (pair? bucket))
	  -1
	  (let loop ((globals (cdr bucket))
		     (pos     0))
	     (cond
		((null? globals)
		 -1)
		((eq? (global-module (car globals)) module)
		 pos)
		(else
		 (loop (cdr globals)
		       (+fx pos 1))))))))
   
