/* DO_NOT_STRIP_HEADER */

static char dqs_wildmat_rcsid[]="$Id: dqs_wildmat.c,v 1.1.1.1 1997/04/10 15:10:35 green Exp $";

#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

/*
**  Do shell-style pattern matching for ?, \, [], and * characters.
**  Might not be robust in face of malformed patterns; e.g., "foo[a-"
**  could cause a segmentation violation.  It is 8bit clean.
**
**  Written by Rich $alz, mirror!rs, Wed Nov 26 19:03:17 EST 1986.
**  Rich $alz is now <rsalz@bbn.com>.
**  Special thanks to Lars Mathiesen <thorinn@diku.dk> for the ABORT code.
**  This can greatly speed up failing wildcard patterns.  For example:
**	pattern: -*-*-*-*-*-*-12-*-*-*-m-*-*-*
**	text 1:	 -adobe-courier-bold-o-normal--12-120-75-75-m-70-iso8859-1
**	text 2:	 -adobe-courier-bold-o-normal--12-120-75-75-X-70-iso8859-1
**  Text 1 matches with 51 calls, while text 2 fails with 54 calls.  Without
**  the ABORT, then it takes 22310 calls to fail.  Ugh.
**
**  $Log: dqs_wildmat.c,v $
**  Revision 1.1.1.1  1997/04/10 15:10:35  green
**  DQS 3.1.3.4.1 Distribution
**
**  Revision 3.1  1996/11/20 23:04:50  nrl
**  Several fixes submitted by or as a result of investigations by
**  Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
**
 * Revision 3.0  1994/03/07  04:14:52  green
 * 3.0 freeze
 *
 * Revision 1.1.1.1  1994/02/01  17:57:48  green
 * DQS 3.0 ALPHA
 *
 * Revision 1.1.1.1  1993/12/15  20:46:38  green
 * DQS 3.0 Alpha Distribution
 *
 * Revision 1.1  1993/12/05  18:59:37  green
 * Initial revision
 *
*/

/************************************************************************/
static int dqs_Star(text, p)
    register char       *text;
    register char       *p;
/*
  See if the text matches the p, which has an implied leading asterisk.
*/

{
    register int	ret;

    do
	ret = dqs_DoMatch(text++, p);
    while (ret == FALSE);
    return ret;
}


/************************************************************************/
static int dqs_DoMatch(text, p)
    register char       *text;
    register char       *p;
/*
  Match text and p, return TRUE, FALSE, or ABORT.
*/

{
    register int 	 last;
    register int 	 matched;
    register int 	 reverse;

    for ( ; *p; text++, p++) {
	if (*text == '\0' && *p != '*')
	    return ABORT;
	switch (*p) {
	case '\\':
	    /* Literal match with following character. */
	    p++;
	    /* FALLTHROUGH */
	default:
	    if (*text != *p)
		return FALSE;
	    continue;
	case '?':
	    /* Match anything. */
	    continue;
	case '*':
	    /* Trailing star matches everything. */
	    return *++p ? dqs_Star(text, p) : TRUE;
	case '[':
	    if (reverse = p[1] == NEGATE_CLASS)
		/* Inverted character class. */
		p++;
	    for (last = 0400, matched = FALSE; *++p && *p != ']'; last = *p)
		/* This next line requires a good C compiler. */
		if (*p == '-' ? *text <= *++p && *text >= last : *text == *p)
		    matched = TRUE;
	    if (matched == reverse)
		return FALSE;
	    continue;
	}
    }

    return *text == '\0';
}

/************************************************************************/
int dqs_wildmat(p,text)
    char        *p;
    char        *text;
/*
  User-level routine.  Returns TRUE or FALSE.
*/

{
    return dqs_DoMatch(text, p) == TRUE;
}


