static char dqs_execd_rebuild_host_hash_rcsid[]="$Id: dqs_execd_rebuild_host_hash.c,v 1.1.1.1 1997/04/10 15:10:32 green Exp $";

/*----------------------------------------------------
 * dqs_execd_rebuild_host_hash.c Tom Green Tue Jun 14 09:14:24 1994
 *
 * Copyright 1994
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_execd_rebuild_host_hash.c,v $
 * Revision 1.1.1.1  1997/04/10 15:10:32  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.7  1996/11/20 23:03:44  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.6  1996/03/22  04:20:27  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.5  1996/01/19  20:58:44  nrl
 * merged SCRI code and new job and queue structure changes
 *
 * Revision 3.4  1994/06/16  20:22:55  green
 * got a bug in my dqs_free_hash() - commenting it out fo now
 * (leaving a HUGE memory leak...)
 *
 * Revision 3.3  1994/06/15  19:20:55  green
 * ignore - just cleaned up the code...
 *
 * Revision 3.2  1994/06/15  15:29:17  green
 * support for using DQS trusted host list for dshd
 *
 * 	passing of Host_head -n dqs_c_dqs_execd.c
 * 	time stamp Host_head on deletion in dqs_c_qconf.c
 * 	ck trusted host list in dqs_dshd.c
 * 	grab Host_head at startup in dqs_execd.c
 * 	rebuild Host_head/Host_hash in dqs_execd_rebuild_host_hash.c
 * 	dqs_free_hash in dqs_hash.c
 * 	grab new Host_head in dqs_load_avg.c
 * 	error log/printing in dsh.c
 *
 * Bug in my syslog code(or certain vendors required nullifying use
 * of syslogd until I can track it down...
 *
 * Revision 3.1  1994/06/15  11:36:44  green
 * dsh now utilizes the same authentication routines as the qmaster.
 *
 *
 *--------------------------------------------------*/

 
#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

/*******************************************************************************/
dqs_list_type *dqs_execd_rebuild_host_hash(new_head)
dqs_list_type *new_head;

{
     
     u_long32    host_gmt;
     
     DENTER((DQS_EVENT,"dqs_execd_rebuild_host_hash"));

     host_gmt=new_head->int0;            /* qmaster's time stamp */

     Host_head=dqs_free_list(Host_head);
     Host_hash=dqs_free_hash(Host_hash);
     
     while (new_head)
     {
          dqs_add_host(new_head->str0);
          new_head=dqs_delete_head(new_head);
     }
     
     if (Host_head)
     {
	  Host_head->int0=host_gmt;      /* qmaster's time stamp */
	  Host_head->int1=dqs_get_gmt();  /* our time stamp */
	  dqs_show_execd_host_list();
     }
     
     DEXIT;
     return(NULL);
     
}

/*******************************************************************************/
void dqs_show_execd_host_list()

{
     
     dqs_list_type *lp;
     
     DENTER((DQS_EVENT,"dqs_show_execd_hostlist"));
     
     INFO((DQS_EVENT,"DQS_ERROR_0231 *********************************************"));

     if (Host_head)
     {
	  INFO((DQS_EVENT,"DQS_ERROR_0232 dqs_execd on %s building Host_list GMT %d",
		 me.qualified_hostname,Host_head->int0));
	  
	  lp=Host_head;
	  while (lp)
	  {
	       DPRINTF((DQS_EVENT,"\t%s",lp->str0));
	       lp=lp->next;
	  }
     }
     else
     {
      ERROR((DQS_EVENT,"DQS_ERROR_0233 *********************************************"));     	
	  ERROR((DQS_EVENT,"DQS_ERROR_0234 ERROR: NULL Host_head"));
     }

     
     DEXIT;
     return;
     
}
