// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: tabdialog.h,v 1.6 1998/01/24 03:00:46 jgg Exp $
/* ######################################################################

   Tabbed Dialog - A dialog that has a number of tabs on one side to 
                   represent pages.
   
   The dialog is built with a primary base widget that contains a number
   of TabDialog::Page widgets organized to form the tabs. Occupying most
   of the space is a PageBase widget from the active tab.

   Each Page has it's own tab widget and pane widget. The tab widget can
   be derived and customized as much as you like but the pane widget 
   cannot.
   
   After constructing the main widget you should construct page widgets
   to add new pages. The page widget sets the LastWidget variable so 
   any widgets you construct after will automatically go into the page
   container.
   
   ##################################################################### */
									/*}}}*/
// Header section: deity
#ifndef DEITY_TABDIALOG_H
#define DEITY_TABDIALOG_H

#include <string>
#include <deity/basic.h>

// Tab dialog
class TabDialog : public BasicWidget
{
   public:
   enum TabLocation {Top,Left,Right,Bottom};
   enum Flags {FullWidth = (1 << 0), SameSize = (1 << 1)};

   // Individual page
   class Page : public BasicWidget
   {
      friend TabDialog;

      // Internal things needed by TabDialog to keep track
      BasicWidget *PageBase;
      Page *NextPage;
      
      public:
            
      inline Widget *Base() const {return PageBase;};
      inline void Select() {((TabDialog *)Parent)->GotoPage(this);};

      Page(TabDialog *Owner);
      virtual ~Page();
   };
   friend Page;
   
   protected:

   Page *CurPage;
   Page *PageList;
   Rect PageLoc;
   TabLocation iLocation;
   unsigned long iEFlags;
   
   void LayoutTabs();
   
   public:
   
   virtual void Resize(Rect NewSize);
   virtual void Realize();
   void GotoPage(Page *Target);
   
   // Accessors
   inline TabLocation Location() const {return iLocation;};
   inline void Location(TabLocation Loc) {iLocation = Loc; LayoutTabs(); Damage();};
   
   TabDialog(Widget *Parent = 0);
   virtual ~TabDialog();
};

// Basic text tag
class TabPage : public TabDialog::Page
{
   protected:

   string iString;
   
   virtual void Render(CombinedGC &GC);
   virtual void Mouse(const MouseEvent &Event);
      
   public:
   
   virtual Point IdealSize();
      
   TabPage(string Text,TabDialog *Owner);
};

#endif
