// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: pkgctrlinfo.cc,v 1.5 1997/06/01 04:30:19 jgg Exp $
/* ######################################################################

   Package Control Info - Information from the packages control block

   The element information is stored in a linked list (STL list template)
   and these functions are simple cover functions for the corrisponding
   list operations.
   
   ##################################################################### */
									/*}}}*/
#include <pkglib/pkgctrlinfo.h>

// PkgCtrlInfo::~pkgPkgCtrlInfo - Destructor				/*{{{*/
// ---------------------------------------------------------------------
/* Deletes the contents of the list */
pkgPkgCtrlInfo::~pkgPkgCtrlInfo()
{
   ElmList::iterator I = Elements.begin();
   for (; I != Elements.end(); I++)
   {
      delete *I;
      *I = 0;
   }      
}
									/*}}}*/
// PkgCtrlInfo::Add - Adds a new element into the list			/*{{{*/
// ---------------------------------------------------------------------
/* Returns false if the element already exists and does nothing, otherwise
   the element is inserted into the list. Ownership of the element is 
   transfered into the list, the caller loses all responsibility. */
bool pkgPkgCtrlInfo::Add(pkgElement *Element)
{
   // Check to see if the element exists
   ElmList::iterator I = FindI(*Element);
   if (I != Elements.end())
      return false;

   Elements.push_back(Element);
   return true;
}
									/*}}}*/
// PkgCtrlInfo::Set - Modifies a possibly existing list item		/*{{{*/
// ---------------------------------------------------------------------
/* Changes an existing element into a new element. This is similar to add
   but without the existance check. Ownership of the element is transfered
   to the list, the caller loses all responsibility for the pointer. */
void pkgPkgCtrlInfo::Set(pkgElement *Element)
{   
   // Check to see if the element exists
   ElmList::iterator I = FindI(*Element);
   if (I != Elements.end())
   {
      // Check if the element is allowed to change.
      if ((*I)->Mutable() == false)
	 return;
      
      delete *I;
      Elements.erase(I);
   }
   
   Elements.push_back(Element);
}
									/*}}}*/
// PkgCtrlInfo::Remove - Removes a list item				/*{{{*/
// ---------------------------------------------------------------------
/* Removes an element from the list. This also deletes the element. True is
   returned if the element was found erased. */
bool pkgPkgCtrlInfo::Remove(pkgElementId Id)
{
   // Check to see if the element exists
   ElmList::iterator I = FindI(Id);
   if (I != Elements.end())
   {
      delete *I;
      Elements.erase(I);
      return true;
   }

   return false;
}
									/*}}}*/
// PkgCtrlInfo::Find - Locates an element in the list			/*{{{*/
// ---------------------------------------------------------------------
/* Simply linearly searches through the element list. Returns 0 if the 
   element could not be found. */
const pkgElement *pkgPkgCtrlInfo::Find(pkgElementId Id) const
{
   ElmList::const_iterator I;
   for (I = Elements.begin(); I != Elements.end() && **I != Id; I++);
   if (I == Elements.end())
      return 0;
   return *I;  
}
									/*}}}*/
// PkgCtrlInfo::Find - Locate an element/value in the list		/*{{{*/
// ---------------------------------------------------------------------
/* */
const pkgElement *pkgPkgCtrlInfo::Find(const pkgElement &Element) const
{
   ElmList::const_iterator I;
   for (I = Elements.begin(); I != Elements.end() && **I != Element; I++);
   if (I == Elements.end())
      return 0;
   return *I;
}
									/*}}}*/
// PkgCtrlInfo::FindI - Locates an element in the list			/*{{{*/
// ---------------------------------------------------------------------
/* Simply linearly searches through the element list. Returns an iterator 
   for the element or List.end() if the element was not found. */
pkgPkgCtrlInfo::ElmList::iterator pkgPkgCtrlInfo::FindI(pkgElementId Id)
{
   ElmList::iterator I;
   for (I = Elements.begin(); I != Elements.end() && **I != Id; I++);
   return I;
}
									/*}}}*/
// PkgCtrlInfo::operator [] - Locate a tag				/*{{{*/
// ---------------------------------------------------------------------
/* This can never fail. If the requested tag is not found an internal 
   dummy element is returned. */
const pkgElement &pkgPkgCtrlInfo::operator [](pkgElementId Tag) const
{
   static pkgElmStringVal Dummy(pkgElementId(0));

   const pkgElement *Item = Find(Tag);
   if (Item == 0)
   {
      cout << "Dummy " << Tag.Tag() << endl;
      return Dummy;
   }
   
   return *Item;
}
									/*}}}*/

