// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: textwidg.h,v 1.12 1998/06/21 03:25:09 jgg Exp $
/* ######################################################################

   TextWidget - Text String Widget
   MenuItem - Menu Item
   Separator - Horizontal line
   Check Menu Item - Menu item with a check mark
   Help Menu Item - Right aligned menu item
   
   The Text Widget displays a string.

   A Menu Item provides different highlighting and some keyboard
   control for the string. A Check Menu Item provides a toggle 
   type button for the menu. Help Menu Item provides the usual right
   alighted help menu.

   The Separator is a non focusable widget designed to be placed in menus.

   MenuItem will trigger Nt_Action when clicked.
   
   ##################################################################### */
									/*}}}*/
// Header section: deity
#ifndef DEITY_TEXTWIDG_H
#define DEITY_TEXTWIDG_H

#include <deity/basic.h>

class TextWidget : public BasicWidget
{
   protected:
   
   // Internal state
   string iString;
   
   // Draws the text
   virtual void Render(CombinedGC &GC);
   unsigned long iDrawFlags;
   
   public:

   void Text(string String);
   inline string Text() {return iString;};
	       
   virtual Point IdealSize();
   inline void DrawFlags(unsigned long Flags) {iDrawFlags = Flags;};
   
   TextWidget(string iString = string(),Widget *Parent = 0);
   TextWidget(Widget *Parent = 0);
};

class MenuItem : public TextWidget
{
   protected:

   // Internal state
   Color iActiveColor;
   Color iBoldColor;
   Color iActiveTextColor;
   unsigned int HotKey;
   unsigned int Accel;
   bool HasChild;
   
   virtual void Render(CombinedGC &GC);
   virtual bool Key(const KeyEvent &Key,Widget *Source);
   virtual void Mouse(const MouseEvent &Event);
   virtual void FocusLost(Widget *Last);
   virtual void FocusGained(Widget *Last);
   virtual Point IdealSize();
   
   // Show the child menu (dropdown) if it exists
   void Drop();
   
   public:

   MenuItem(string iString,Widget *Parent = 0);
};

class HelpMenuItem : public MenuItem
{
   protected:

   // Force the position to be on right justified on the parent
   virtual void Resize(Rect Pos);
   
   public:

   HelpMenuItem(string iString,Widget *Parent = 0);
};

class Separator : public BasicWidget
{
   protected:

   // Draw a line the width of the widget
   virtual void Render(CombinedGC &GC);
   
   public:
   
   Separator(Widget *Parent = 0);
};

class CheckMenuItem : public MenuItem
{
   protected:

   bool Check;
   virtual Point IdealSize();
   virtual void Render(CombinedGC &GC);

   public:
   
   CheckMenuItem(string iString,Widget *Parent = 0);
};

#endif
