// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: mmap.h,v 1.4 1997/10/10 15:39:03 jgg Exp $
/* ######################################################################
   
   MMap Class - Provides 'real' mmap or a faked mmap using read().

   The purpose of this code is to provide a generic way for clients to
   access the mmap function. In enviroments that do not support mmap
   from file fd's this function will use read and normal allocated 
   memory.
   
   Writing to a public mmap will always fully comit all changes when the 
   class is deleted. Ie it will rewrite the file, unless it is readonly

   This source is placed in the Public Domain, do with it what you will
   It was originally written by Jason Gunthorpe.
   
   ##################################################################### */
									/*}}}*/
// Header section: pkglib
#ifndef PKGLIB_MMAP_H
#define PKGLIB_MMAP_H

#include <string>

class MMap
{
   int Fd;
   bool Public;
   bool ReadOnly;
   unsigned long iSize;
   bool CloseFd;
   void *Base;

   bool Map();
   
   public:

   inline operator void *() {return Base;};
   inline void *Data() {return Base;}; 
   inline unsigned long Size() {return iSize;};
   
   bool Open(int Fd, bool Public, bool ReadOnly);
   bool Open(string File,bool Public, bool ReadOnly);
   bool Close();
   bool Sync();
   
   MMap(int Fd, bool Public, bool ReadOnly);
   MMap(string File,bool Public, bool ReadOnly);
   MMap();
   ~MMap();
};

#endif
