#include <config.h>
#include "nls-boilerplate.h"
#include <iostream.h>
#include <deity/slangdev.h>
#include <deity/basic.h>
#include <deity/menubar.h>
#include <deity/textwidg.h>
#include <deity/utils.h>
#include "aptwidgets.h"

// XLib #defines a bunch of junk, so this must go at the end
#ifndef X_DISPLAY_MISSING
#include <deity/x11dev.h>
#endif

int main(int,char **)
{
   SelectLoop Loop;
   Widget *Root = 0;
   
   setlocale (LC_ALL, "");
   bindtextdomain (PACKAGE, LOCALEDIR);
   textdomain (PACKAGE);
   
   while (1)
   {
#ifndef X_DISPLAY_MISSING
      if ((Root = XAttachDisplay(Loop)) != 0)
	 break;
#endif
      
      if ((Root = SLangAttachDisplay(Loop)) != 0)
	 break;
      
      cerr << _("Unable to find suitable display! Tried ")
#ifndef X_DISPLAY_MISSING
	   << "X11 and"
#endif
	   << "SLang." << endl;
      
      return 0;
   }

   // Use 'apt 3> file' to see the debug information from clog.
   ReAttachStreams();
   Base = new MainWindow(Root);

   Loop.Loop();
}
