/* xkeycaps, Copyright (c) 1998 Jamie Zawinski <jwz@jwz.org>
 *
 * Keymap file of the 105 keys PC-style keyboard, Slovene layout,
 * By Andrej Presern <andrejp@luz.fe.uni-lj.si>
 */

#ifndef XK_Sys_Req
# define XK_Sys_Req		0xFF15
#endif

static const struct default_keycode_map ms105si_linux_map [] = {
  {   9, 0,		{ XK_Escape }},
  {  10, 0,		{ XK_1,	XK_exclam,
			  XK_asciitilde }},
  {  11, 0,		{ XK_2,	XK_quotedbl,
			  XK_caron }},
  {  12, 0,		{ XK_3,	XK_numbersign,
			  XK_asciicircum }},
  {  13, 0,		{ XK_4,	XK_dollar,
			  XK_breve }},
  {  14, 0,		{ XK_5,	XK_percent,
			  XK_degree }},
  {  15, 0,		{ XK_6,	XK_ampersand,
			  XK_ogonek }},
  {  16, 0,		{ XK_7,	XK_slash,
			  XK_grave }},
  {  17, 0,		{ XK_8,	XK_parenleft,
			  XK_abovedot }},
  {  18, 0,		{ XK_9,	XK_parenright,
			  XK_acute }},
  {  19, 0,		{ XK_0,	XK_equal,
			  XK_doubleacute }},
  {  20, 0,		{ XK_apostrophe,	XK_question,
			  XK_diaeresis }},
  {  21, 0,		{ XK_plus,	XK_asterisk,
			  XK_cedilla }},
  {  22, 0,		{ XK_BackSpace,	XK_BackSpace }},
  {  23, 0,		{ XK_Tab,	XK_Tab }},
  {  24, 0,		{ XK_q,	XK_Q,
			  XK_backslash }},
  {  25, 0,		{ XK_w,	XK_W,
			  XK_bar }},
  {  26, 0,		{ XK_e }},
  {  27, 0,		{ XK_r }},
  {  28, 0,		{ XK_t }},
  {  29, 0,		{ XK_z }},
  {  30, 0,		{ XK_u }},
  {  31, 0,		{ XK_i }},
  {  32, 0,		{ XK_o }},
  {  33, 0,		{ XK_p }},
  {  34, 0,		{ XK_onesuperior,	XK_copyright,
			  XK_division }},
  {  35, 0,		{ XK_eth,	XK_ETH,
			  XK_multiply }},
  {  36, 0,		{ XK_Return }},
  {  37, ControlMask,	{ XK_Control_L }},
  {  38, 0,		{ XK_a }},
  {  39, 0,		{ XK_s }},
  {  40, 0,		{ XK_d }},
  {  41, 0,		{ XK_f,	XK_F,
			  XK_bracketleft }},
  {  42, 0,		{ XK_g,	XK_G,
			  XK_bracketright }},
  {  43, 0,		{ XK_h }},
  {  44, 0,		{ XK_j }},
  {  45, 0,		{ XK_k,	XK_K,
			  XK_threesuperior }},
  {  46, 0,		{ XK_l,	XK_L,
			  XK_sterling }},
  {  47, 0,		{ XK_egrave,	XK_Egrave }},
  {  48, 0,		{ XK_ae,	XK_AE,
			  XK_ssharp }},
  {  49, 0,		{ XK_cedilla,	XK_diaeresis }},
  {  50, ShiftMask,	{ XK_Shift_L }},
  {  51, 0,		{ XK_threequarters,	XK_registered,
			  XK_currency }},
  {  52, 0,		{ XK_y }},
  {  53, 0,		{ XK_x }},
  {  54, 0,		{ XK_c }},
  {  55, 0,		{ XK_v,	XK_V,
			  XK_at }},
  {  56, 0,		{ XK_b,	XK_B,
			  XK_braceleft }},
  {  57, 0,		{ XK_n,	XK_N,
			  XK_braceright }},
  {  58, 0,		{ XK_m,	XK_M,
			  XK_section }},
  {  59, 0,		{ XK_comma,	XK_semicolon }},
  {  60, 0,		{ XK_period,	XK_colon }},
  {  61, 0,		{ XK_minus,	XK_underscore }},
  {  62, ShiftMask,	{ XK_Shift_R }},
  {  63, 0,		{ XK_KP_Multiply }},
  {  64, Mod1Mask,	{ XK_Alt_L,	XK_Meta_L }},
  {  65, 0,		{ XK_space,	XK_space }},
  {  66, LockMask,	{ XK_Caps_Lock }},
  {  67, 0,		{ XK_F1,	XK_F11 }},
  {  68, 0,		{ XK_F2,	XK_F12 }},
  {  69, 0,		{ XK_F3,	XK_F13 }},
  {  70, 0,		{ XK_F4,	XK_F14 }},
  {  71, 0,		{ XK_F5,	XK_F15 }},
  {  72, 0,		{ XK_F6,	XK_F16 }},
  {  73, 0,		{ XK_F7,	XK_F17 }},
  {  74, 0,		{ XK_F8,	XK_F18 }},
  {  75, 0,		{ XK_F9,	XK_F19 }},
  {  76, 0,		{ XK_F10,	XK_F20 }},
  {  77, 0,		{ XK_Num_Lock }},
  {  78, Mod4Mask,	{ XK_Scroll_Lock }},
  {  79, 0,		{ XK_KP_7 }},
  {  80, 0,		{ XK_KP_8 }},
  {  81, 0,		{ XK_KP_9 }},
  {  82, 0,		{ XK_KP_Subtract }},
  {  83, 0,		{ XK_KP_4 }},
  {  84, 0,		{ XK_KP_5 }},
  {  85, 0,		{ XK_KP_6 }},
  {  86, 0,		{ XK_KP_Add }},
  {  87, 0,		{ XK_KP_1 }},
  {  88, 0,		{ XK_KP_2 }},
  {  89, 0,		{ XK_KP_3 }},
  {  90, 0,		{ XK_KP_0 }},
  {  91, 0,		{ XK_KP_Decimal }},
  {  92, 0,		{ XK_Sys_Req }},
  {  93, 0,		{ XK_Down }},
  {  94, 0,		{ XK_less,	XK_greater }},
  {  95, 0,		{ XK_F11,	XK_F11 }},
  {  96, 0,		{ XK_F12,	XK_F12 }},
  { 118, 0,		{ XK_Left }},
  { 119, 0,		{ XK_Prior }},
  { 120, Mod2Mask,      { XK_Meta_L }},
  { 121, Mod2Mask,      { XK_Meta_R }},
  { 122, Mod2Mask,	{ XK_Mode_switch }},
  { 123, ControlMask,	{ XK_Control_R }},
  { 124, 0,		{ XK_KP_Enter }},
  { 125, 0,		{ XK_KP_Divide }},
  { 126, 0,		{ XK_Menu }},
  { 127, 0,		{ XK_Pause }},
  { 128, 0,		{ XK_Up }},
  { 129, 0,		{ XK_Delete }},
  { 130, 0,		{ XK_End }},
  { 131, 0,		{ XK_Insert }},
  { 133, 0,		{ XK_Right }},
  { 134, 0,		{ XK_Next }},
  { 135, 0,		{ XK_Home }},
  { 136, 0,		{ XK_Break }},
  { 137, 0,		{ XK_Sys_Req }}
  };
