/*
 *  misc.h
 *
 *  Copyright (C) 1998 Ullrich Hafner <hafner@informatik.uni-wuerzburg.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

/*
 *  $Date: 1998/07/21 08:52:47 $
 *  $Author: hafner $
 *  $Revision: 1.8 $
 *  $State: Exp $
 */

#ifndef _MISC_H
#define _MISC_H

#if HAVE_STDLIB_H
#	include <stdlib.h>
#endif /* not HAVE_STDLIB_H */
#if HAVE_STRING_H
#	include <string.h>
#else /* not HAVE_STRING_H */
#	include <strings.h>
#endif /* not HAVE_STRING_H */

typedef unsigned bool_t;

void *
Calloc (size_t n, size_t size);
void
Free (void *memory);
char *
strdup (const char *s);
char *
get_gnustep_path (const char *domain);
char *
expand_tilde (const char *name);
#ifndef HAVE_STRCASECMP
bool_t
strcaseeq (const char *s1, const char *s2);
#else  /* HAVE_STRCASECMP */
int
strcasecmp (const char *s1, const char *s2);
#define strcaseeq(s1, s2) (strcasecmp ((s1), (s2)) == 0)
#endif /* HAVE_STRCASECMP */

#define streq(str1, str2)	(strcmp ((str1), (str2)) == 0)
#define max(a, b)		((a) > (b) ? (a) : (b))
#define min(a, b)		((a) < (b) ? (a) : (b))

#endif /* not _MISC_H */

