/* $Id: scwm-screen-ci.hpp,v 1.3 1998/08/02 23:43:22 gjb Exp $
 * scwm-screen-ci.hpp
 * (C) 1998 Greg J. Badros
 *
 * This header file contains the definition of the ScwmScreenConstraintInfo class
 * A SSCI is stored with each screen to hold the ClVariables associated with it.
 *
 */

#ifndef SCWM_SCREEN_CI_HPP__
#define SCWM_SCREEN_CI_HPP__


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <assert.h>
#include "scwm-constraints.h"
#include "screen.h"
#include "window.h"
#include "xmisc.h"
#include <strstream>
#include <string>
#include "ClVariable.h"
#include "ClSimplexSolver.h"
#include "../guile/cassowary_scm.hpp"

class ScwmScreenConstraintInfo {
public:
  ScwmScreenConstraintInfo(ScreenInfo *pscreen)
    {
      _vx.setName("vx");
      _vy.setName("vy");
      _pointerx.setName("px");
      _pointery.setName("py");
#if 0 /* FIXGJB: just leave the Pv()s at NULL for now */
      /* will need to do something with this when supporting multiple
         screens better */
      _vx.setPv(pscreen);
      _vy.setPv(pscreen);
      _pointerx.setPv(pscreen);
      _pointery.setPv(pscreen);
#endif 
      SCM_DEFER_INTS;
      scm_protect_object(_scmVx = ScmMakeClVariable(&_vx));
      scm_protect_object(_scmVy = ScmMakeClVariable(&_vy));
      scm_protect_object(_scmPointerX = ScmMakeClVariable(&_pointerx));
      scm_protect_object(_scmPointerY = ScmMakeClVariable(&_pointery));
      SCM_ALLOW_INTS;
    }

#if 0
  /* FIXGJB: will need to do something with this when supporting
     multiple screens better */
  ScreenInfo *Pscreen() const
    {
      return static_cast<ScreenInfo *>(_vx.Pv());
    }
#endif

  void
  AddStays(ClSimplexSolver *psolver)
    {
      psolver->addStay(_vx,clsMedium(),1.0);
      psolver->addStay(_vy,clsMedium(),1.0);
      ClLinearInequality *pminX = new ClLinearInequality(_vx,cnGEQ,0);
      ClLinearInequality *pminY = new ClLinearInequality(_vy,cnGEQ,0);
      ClLinearInequality *pmaxX = new ClLinearInequality(_vx,cnLEQ,Scr.VxMax);
      ClLinearInequality *pmaxY = new ClLinearInequality(_vy,cnLEQ,Scr.VyMax);
      (*psolver)
        .addConstraint(*pminX)
        .addConstraint(*pminY)
        .addConstraint(*pmaxX)
        .addConstraint(*pmaxY);
      /*     psolver->addPointStay(_pointerx,_pointery); */
    }

  ClVariable _vx;
  ClVariable _vy;
  ClVariable _pointerx;
  ClVariable _pointery;
  SCM _scmVx;
  SCM _scmVy;
  SCM _scmPointerX;
  SCM _scmPointerY;
};


#endif
