/*
 * IceWM
 *
 * Copyright (C) 1997,98 Marko Macek
 *
 * TaskBar
 */

#include "icewm.h"

#ifdef CONFIG_TASKBAR

YFont *normalTaskBarFont = 0;
YFont *activeTaskBarFont = 0;

YColor *normalTaskBarAppFg = 0;
YColor *normalTaskBarAppBg = 0;

YColor *activeTaskBarAppFg = 0;
YColor *activeTaskBarAppBg = 0;

YColor *minimizedTaskBarAppFg = 0;
YColor *minimizedTaskBarAppBg = 0;

YTimer *TaskBarApp::fRaiseTimer = 0;;
YTimer *WorkspaceButton::fRaiseTimer = 0;

WorkspaceButton::WorkspaceButton(CARD32 workspace, YWindow *parent, WMCommand command, void *context):
    YButton(parent, command, context)
{
    fWorkspace = workspace;
    //setDND(true);
}

void WorkspaceButton::handleClick(const XButtonEvent &down, const XButtonEvent &up, int count) {
}

void WorkspaceButton::handleDNDEnter() {
    if (fRaiseTimer == 0)
        fRaiseTimer = new YTimer();
    if (fRaiseTimer) {
        fRaiseTimer->setInterval(autoRaiseDelay);
        fRaiseTimer->setListener(this);
        fRaiseTimer->startTimer();
    }
    repaint();
}

void WorkspaceButton::handleDNDLeave() {
    if (fRaiseTimer && fRaiseTimer->getListener() == this) {
        fRaiseTimer->stopTimer();
        fRaiseTimer->setListener(0);
    }
    repaint();
}

bool WorkspaceButton::handleTimer(YTimer *t) {
    if (t == fRaiseTimer) {
        manager->activateWorkspace(fWorkspace);
    }
    return false;
}

void WorkspaceButton::ButtonClick(YButton */*button*/, unsigned int modifiers) {
    if (modifiers & ShiftMask) {
        if (manager->focus())
            manager->focus()->wmOccupyOnlyWorkspace(fWorkspace);
        manager->activateWorkspace(fWorkspace);
    } else if (modifiers & app->AltMask) {
        if (manager->focus())
            manager->focus()->wmOccupyOnlyWorkspace(fWorkspace);
        if (clickFocus)
            manager->focusTopWindow();
    } else
        manager->activateWorkspace(fWorkspace);
}

TaskBarApp::TaskBarApp(YFrameWindow *frame, YWindow *aParent, Window win): YWindow(aParent, win) {
    fFrame = frame;
    fPrev = fNext = 0;
    selected = 0;
    fShown = true;
    setToolTip((char *)frame->client()->windowTitle());
    //setDND(true);
}

TaskBarApp::~TaskBarApp() {
    if (fRaiseTimer && fRaiseTimer->getListener() == this) {
        fRaiseTimer->stopTimer();
        fRaiseTimer->setListener(0);
    }
}

bool TaskBarApp::isFocusTraversable() {
    return true;
}

void TaskBarApp::setShown(bool ashow) {
    if (ashow != fShown) {
        fShown = ashow;
    }
}

void TaskBarApp::paint(Graphics &g, int /*x*/, int /*y*/, unsigned int /*width*/, unsigned int /*height*/) {
    YColor *bg;
    YColor *fg;
    int p;

    if (frame()->isMinimized()) {
        bg = minimizedTaskBarAppBg;
        fg = minimizedTaskBarAppFg;
    } else {
        bg = normalTaskBarAppBg;
        fg = normalTaskBarAppFg;
    }

    if (selected == 3) {
        p = 2;
        if (frame()->focused()) {
            bg = activeTaskBarAppBg;
            fg = activeTaskBarAppFg;
        }
        g.setColor(black);
        g.drawRect(0, 0, width() - 1, height() - 1);
        g.setColor(bg);
        g.fillRect(1, 1, width() - 2, height() - 2);
    } else {
        if (frame()->focused() || selected == 2) {
            p = 2;
            if (frame()->focused()) {
                bg = activeTaskBarAppBg;
                fg = activeTaskBarAppFg;
            }
            g.setColor(bg);
            if (wmLook == lookMetal) {
                g.drawBorderM(0, 0, width() - 1, height() - 1, false);
            } else if (wmLook == lookGtk)
                g.drawBorderG(0, 0, width() - 1, height() - 1, false);
            else
                g.drawBorderW(0, 0, width() - 1, height() - 1, false);
        } else {
            p = 1;
            g.setColor(bg);
            if (wmLook == lookMetal) {
                p = 2;
                g.drawBorderM(0, 0, width() - 1, height() - 1, true);
            } else if (wmLook == lookGtk)
                g.drawBorderG(0, 0, width() - 1, height() - 1, true);
            else
                g.drawBorderW(0, 0, width() - 1, height() - 1, true);
        }
        if (wmLook == lookMetal)
            g.fillRect(2, 2, width() - 4, height() - 4);
        else
            g.fillRect(p, p, width() - 3, height() - 3);
    }

    if (frame()->clientIcon() && frame()->clientIcon()->small()) {
        int y = (height() - 3 - frame()->clientIcon()->small()->height() - ((wmLook == lookMetal) ? 1 : 0)) / 2;
        g.drawPixmap(frame()->clientIcon()->small(), p + 1, p + 1 + y);
    }

    char *str = (char *)frame()->client()->iconTitle();
    if (!str)
        str = (char *)frame()->client()->windowTitle();
    if (str) {
        g.setColor(fg);
        if (frame()->focused())
            g.setFont(activeTaskBarFont);
        else
            g.setFont(normalTaskBarFont);
        int ty = (height() - 1 + titleFont->height() - ((wmLook == lookMetal) ? 1 : 0)) / 2 - titleFont->descent();
        if (ty < 2)
            ty = 2;
        g.drawChars((char *)str, 0, strlen(str),
                    p + 3 + 16,
                    p + ty);
        //(yheight() - font->height()) / 2 - titleFont->descent() - 4);
    }
}

void TaskBarApp::handleButton(const XButtonEvent &button) {
    YWindow::handleButton(button);
    if (button.button == 1 || button.button == 2) {
        if (button.type == ButtonPress) {
            selected = 2;
            repaint();
        } else if (button.type == ButtonRelease) {
            if (selected == 2) {
                if (button.button == 1) {
                    if (frame()->visibleNow() &&
                        (!frame()->canRaise() || (button.state & ControlMask)))
                        frame()->wmMinimize();
                    else {
                        if (button.state & ShiftMask)
                            frame()->wmOccupyOnlyWorkspace(manager->activeWorkspace());
                        frame()->activate();
                        frame()->wmRaise();
                    }
                } else if (button.button == 2) {
                    if (frame()->visibleNow() &&
                        (!frame()->canRaise() || (button.state & ControlMask)))
                        frame()->wmLower();
                    else {
                        if (button.state & ShiftMask)
                        if (button.state & ShiftMask)
                            frame()->wmOccupyWorkspace(manager->activeWorkspace());
                        frame()->activate();
                        frame()->activate();
                        frame()->wmRaise();
                    }
                }
            }
            selected = 0;
            repaint();
        }
    }
}

void TaskBarApp::handleCrossing(const XCrossingEvent &crossing) {
    if (selected > 0) {
        if (crossing.type == EnterNotify) {
            selected = 2;
            repaint();
        } else if (crossing.type == LeaveNotify) {
            selected = 1;
            repaint();
        }
    }
    YWindow::handleCrossing(crossing);
}

void TaskBarApp::handleClick(const XButtonEvent &/*down*/, const XButtonEvent &up, int /*count*/) {
    //if (up.button == 2)
    //    frame()->wmMinimize();
    //else
    if (up.button == 3) {
        frame()->popupSystemMenu(up.x_root, up.y_root, -1, -1,
                                 YPopupWindow::pfCanFlipVertical |
                                 YPopupWindow::pfCanFlipHorizontal |
                                 YPopupWindow::pfPopupMenu);
    }
}

void TaskBarApp::handleDNDEnter() {
    if (fRaiseTimer == 0)
        fRaiseTimer = new YTimer();
    if (fRaiseTimer) {
        fRaiseTimer->setInterval(autoRaiseDelay);
        fRaiseTimer->setListener(this);
        fRaiseTimer->startTimer();
    }
    selected = 3;
    repaint();
}

void TaskBarApp::handleDNDLeave() {
    if (fRaiseTimer && fRaiseTimer->getListener() == this) {
        fRaiseTimer->stopTimer();
        fRaiseTimer->setListener(0);
    }
    selected = 0;
    repaint();
}
                    
bool TaskBarApp::handleTimer(YTimer *t) {
    if (t == fRaiseTimer) {
        frame()->wmRaise();
    }
    return false;
}

TaskBar::TaskBar(YWindow *aParent, Window win): YWindow(aParent, win) {
    unsigned int ht = 26;

    setStyle(wsOverrideRedirect);
    {
        CARD32 arg[2];
        arg[0] = NormalState;
        arg[1] = 0;
        XChangeProperty(app->display(), handle(),
                        _XA_WM_STATE, _XA_WM_STATE,
                        32, PropModeReplace,
                        (unsigned char *)arg, 2);
    }
    setDND(true);

    fAutoHideTimer = new YTimer();
    fAutoHideTimer->setListener(this);
    fAutoHideTimer->setInterval(autoHideDelay);
    fIsHidden = taskBarAutoHide;

#define BASE1 2
#define ADD1 3
#define BASE2 3
#define ADD2 5

    fWorkspaceButton = 0;
    if (taskBarShowWorkspaces) {
        fWorkspaceButton = (WorkspaceButton **)MALLOC(sizeof(WorkspaceButton *) * workspaceCount);
        assert(fWorkspaceButton != 0);
    }
    
    fFirst = fLast = 0;
    fCount = 0;
    fNeedRelayout = true;

    if (taskBarShowCPUStatus)
        fCPUStatus = new CPUStatus(this);
    else
        fCPUStatus = 0;
    if (taskBarShowClock) {
        fClock = new YClock(this);
        if (fClock->height() + ADD1 > ht) ht = fClock->height() + ADD1;
    } else 
        fClock = 0;
    if (taskBarShowMailboxStatus)
        fMailBoxStatus = new MailBoxStatus(mailBoxPath, mailCommand, this);
    else
        fMailBoxStatus = 0;
    if (taskBarShowStartMenu) {
        fApplications = new YButton(this, rootMenu, wmapp);
        fApplications->setPixmap(startPixmap);
        if (fApplications->height() + ADD1 > ht) ht = fApplications->height() + ADD1;
    } else 
        fApplications = 0;

    fObjectBar = new ObjectBar(this);
    if (toolbarFile)
        loadMenus(toolbarFile, fObjectBar);
    
    if (taskBarShowWindowListMenu) {
        fWinList = new YButton(this, windowListMenu, wmapp);
        fWinList->setPixmap(windowsPixmap);
        if (fWinList->height() + ADD1 > ht) ht = fWinList->height() + ADD1;
    } else
        fWinList = 0;

    if (taskBarShowWorkspaces) {
        for (CARD32 w = 0; w < workspaceCount; w++) {
            WorkspaceButton *wk = new WorkspaceButton(w, this, cmdActivateWorkspace, (void *)w);
            wk->setText(workspaceNames[w]);
            wk->setListener(wk);
            if (wk->height() + ADD2 > ht) ht = wk->height() + ADD2;
            fWorkspaceButton[w] = wk;
        }
    }

    if (taskBarDoubleHeight) {
        setSize(manager->width() + 2, 2 * ht + 1);
        
        updateLocation();
        
        leftX = 2;
        rightX = width() - 4;
        if (taskBarShowClock) {
            fClock->setPosition(rightX - fClock->width(),
                                BASE1 + (ht - ADD1 - fClock->height()) / 2);
            fClock->show();
            rightX -= fClock->width() + 2;
        }
        if (fMailBoxStatus) {
            fMailBoxStatus->setPosition(rightX - fMailBoxStatus->width() - 1,
                                        BASE2 + (ht - ADD2 - fMailBoxStatus->height()) / 2);
            fMailBoxStatus->show();
            rightX -= fMailBoxStatus->width() + 2;
        }
        if (fCPUStatus) {
            fCPUStatus->setPosition(rightX - fCPUStatus->width() - 1,
                                    BASE1 + (ht - ADD1 - fCPUStatus->height()) / 2);
            fCPUStatus->show();
            rightX -= fCPUStatus->width() + 2;
        }
        if (fApplications) {
            leftX += 2;
            fApplications->setPosition(leftX,
                                       BASE1 + (ht - ADD1 - fApplications->height()) / 2);
            fApplications->show();
            leftX += fApplications->width();
        }
        if (fWinList) {
            fWinList->setPosition(leftX,
                                  BASE1 + (ht - ADD1 - fWinList->height()) / 2);
            fWinList->show();
            leftX += fWinList->width() + 2;
        }
        if (fObjectBar) {
            leftX += 2;
            fObjectBar->setPosition(leftX,
                                    BASE1 + (ht - ADD1 - fObjectBar->height()) / 2);
            fObjectBar->show();
            leftX += fObjectBar->width() + 2;
        }
        
        leftX = 2;
        rightX = width() - 4;
        
        if (taskBarShowWorkspaces) {
            leftX += 2;
            for (CARD32 w = 0; w < workspaceCount; w++) {
                YButton *wk = fWorkspaceButton[w];
                //leftX += 2;
                wk->setSize(wk->width(), ht - ADD2);
                wk->setPosition(leftX, BASE2 + ht); // + (ht - ADD - wk->height()) / 2);
                wk->show();
                leftX += wk->width();
            }
            leftX += 4;
        }
    } else {
        setSize(manager->width() + 2, ht + 1);
        
        updateLocation();
        
        leftX = 2;
        rightX = width() - 4;
        if (taskBarShowClock) {
            fClock->setPosition(rightX - fClock->width(),
                                BASE1 + (ht - ADD1 - fClock->height()) / 2);
            fClock->show();
            rightX -= fClock->width() + 2;
        }
        if (fMailBoxStatus) {
            fMailBoxStatus->setPosition(rightX - fMailBoxStatus->width() - 1,
                                        BASE2 + (ht - ADD2 - fMailBoxStatus->height()) / 2);
            fMailBoxStatus->show();
            rightX -= fMailBoxStatus->width() + 2;
        }
        if (fCPUStatus) {
            fCPUStatus->setPosition(rightX - fCPUStatus->width() - 1,
                                    BASE1 + (ht - ADD1 - fCPUStatus->height()) / 2);
            fCPUStatus->show();
            rightX -= fCPUStatus->width() + 2;
        }
        if (fApplications) {
            leftX += 2;
            fApplications->setPosition(leftX,
                                       BASE1 + (ht - ADD1 - fApplications->height()) / 2);
            fApplications->show();
            leftX += fApplications->width();
        }
        if (fWinList) {
            fWinList->setPosition(leftX,
                                  BASE1 + (ht - ADD1 - fWinList->height()) / 2);
            fWinList->show();
            leftX += fWinList->width() + 2;
        }
        if (fObjectBar) {
            leftX += 2;
            fObjectBar->setPosition(leftX,
                                    BASE1 + (ht - ADD1 - fObjectBar->height()) / 2);
            fObjectBar->show();
            leftX += fObjectBar->width() + 2;
        }
        
        if (taskBarShowWorkspaces) {
            leftX += 2;
            for (CARD32 w = 0; w < workspaceCount; w++) {
                YButton *wk = fWorkspaceButton[w];
                //leftX += 2;
                wk->setSize(wk->width(), ht - ADD2);
                wk->setPosition(leftX, BASE2); // + (ht - ADD - wk->height()) / 2);
                wk->show();
                leftX += wk->width();
            }
            leftX += 4;
        }
    }
}

TaskBar::~TaskBar() {
    if (fAutoHideTimer) {
        fAutoHideTimer->stopTimer();
        fAutoHideTimer->setListener(0);
        delete fAutoHideTimer;
        fAutoHideTimer = 0;
    }
    delete fClock; fClock = 0;
    delete fMailBoxStatus; fMailBoxStatus = 0;
    delete fApplications; fApplications = 0;
    delete fWinList; fWinList = 0;
    if (fWorkspaceButton) {
        for (CARD32 w = 0; w < workspaceCount; w++)
            delete fWorkspaceButton[w];
        delete fWorkspaceButton;
    }
}

void TaskBar::updateLocation() {
    int x = -1;
    int y = 0;
    int h = height() - 1;

    if (fIsHidden)
        y = taskBarAtTop ? -h : int(manager->height() - 1);
    else
        y = taskBarAtTop ? -1 : int(manager->height() - h);

    setPosition(x, y);
}

void TaskBar::handleCrossing(const XCrossingEvent &crossing) {
    if (crossing.type == EnterNotify && crossing.mode == NotifyNormal) {
        fIsHidden = false;
        if (taskBarAutoHide && fAutoHideTimer)
            fAutoHideTimer->startTimer();
    } else if (crossing.type == LeaveNotify) {
        if (crossing.detail != NotifyInferior) {
            fIsHidden = true;
            if (taskBarAutoHide && fAutoHideTimer)
                fAutoHideTimer->startTimer();
        }
    }
}

bool TaskBar::handleTimer(YTimer *t) {
    if (t == fAutoHideTimer) {
        updateLocation();
    }
    return false;
}

void TaskBar::paint(Graphics &g, int /*x*/, int /*y*/, unsigned int /*width*/, unsigned int /*height*/) {
    g.setColor(taskBarBg);
    g.draw3DRect(0, 0, width() - 1, height() - 1, true);
    g.fillRect(1, 1, width() - 2, height() - 2);
}

bool TaskBar::handleKey(const XKeyEvent &key) {
    return YWindow::handleKey(key);
}

void TaskBar::handleButton(const XButtonEvent &button) {
    if ((button.type == ButtonRelease) &&
        (button.button == 1 || button.button == 3) &&
        (BUTTON_MODMASK(button.state) == Button1Mask + Button3Mask))
    {
        if (windowList)
            windowList->showFocused();
    } else if (button.type == ButtonPress) {
        manager->updateWorkArea();
        if (button.button == 1) {
            if (button.state & app->AltMask)
                lower();
            else if (!(button.state & ControlMask))
                raise();
        }
    }
    YWindow::handleButton(button);
}

void TaskBar::handleClick(const XButtonEvent &down, const XButtonEvent &up, int count) {
    if (up.button == 1) {
    } else if (up.button == 2) {
    } else if (up.button == 3 && count == 1) {
        rootMenu->popup(0, wmapp, 0, up.x_root, up.y_root, -1, -1,
                        YPopupWindow::pfCanFlipVertical |
                        YPopupWindow::pfCanFlipHorizontal);
    }
    YWindow::handleClick(down, up, count);
}

void TaskBar::handleDrag(const XButtonEvent &/*down*/, const XMotionEvent &motion) {
#ifndef NO_CONFIGURE
    int newPosition = 0;
    
    if (motion.y_root < int(manager->height() / 2))
        newPosition = 1;
    
    if (taskBarAtTop != newPosition) {
        taskBarAtTop = newPosition;
        setPosition(x(), taskBarAtTop ? -1 : int(manager->height() - height() + 1));
        manager->updateWorkArea();
    }
#endif
}

void TaskBar::insert(TaskBarApp *tapp) {
    fCount++;
    tapp->setNext(0);
    tapp->setPrev(fLast);
    if (fLast)
        fLast->setNext(tapp);
    else
        fFirst = tapp;
    fLast = tapp;
}

void TaskBar::remove(TaskBarApp *tapp) {
    fCount--;

    if (tapp->getPrev())
        tapp->getPrev()->setNext(tapp->getNext());
    else
        fFirst = tapp->getNext();

    if (tapp->getNext())
        tapp->getNext()->setPrev(tapp->getPrev());
    else
        fLast = tapp->getPrev();
}

TaskBarApp *TaskBar::addApp(YFrameWindow *frame) {
    if (frame->client() == windowList)
        return 0;

    TaskBarApp *tapp = new TaskBarApp(frame, this);

    if (tapp != 0) {
        insert(tapp);
        tapp->show();
        if (!frame->visibleOn(manager->activeWorkspace()) &&
            !taskBarShowAllWindows)
            tapp->setShown(0);
        relayout();
    }
    return tapp;
}

void TaskBar::removeApp(YFrameWindow *frame) {
    TaskBarApp *f = fFirst, *next;

    while (f) {
        next = f->getNext();
        if (f->frame() == frame) {
            f->hide();
            remove(f);
            delete f;
            relayout();
            return ;
        }
        f = next;
    }
}

void TaskBar::relayoutNow() {
    if (!fNeedRelayout)
        return ;

    fNeedRelayout = false;

    int x, y, w, h;
    int tc = 0;

    TaskBarApp *a = fFirst;
    
    while (a) {
        if (a->getShown())
            tc++;
        a = a->getNext();
    }

    if (tc < 3) tc = 3;

    w = (rightX - leftX - 2) / tc - 2;
    x = leftX;
    h = height() - ADD2 - ((wmLook == lookMetal) ? 0 : 1);
    y = BASE2 + (height() - ADD2 - 1 - h) / 2;
    if (taskBarDoubleHeight) {
        h /= 2; h--;
        y += height() / 2; y--;
    }

    TaskBarApp *f = fFirst;
        
    while (f) {
        if (f->getShown()) {
            f->setGeometry(x, y, w, h);
            f->show();
            x += w;
            x += 2;
        } else
            f->hide();
        f = f->getNext();
    }
}

void TaskBar::popupStartMenu() {
    if (fApplications) {
        /*requestFocus();
        fApplications->requestFocus();
        fApplications->setFocus();*/
        fApplications->popupMenu();
    }
}

void TaskBar::popupWindowListMenu() {
    if (fWinList) {
        fWinList->popupMenu();
    }
}
#endif
