/*
 * IceWM
 *
 * Copyright (C) 1997,1998 Marko Macek
 *
 * Windows/OS2 like Alt{+Shift}+Tab window switching
 */

#include "icewm.h"

YColor *SwitchWindow::switchFg = 0;
YColor *SwitchWindow::switchBg = 0;

YFont *SwitchWindow::switchFont = 0;

SwitchWindow::SwitchWindow(YWindow *parent): YPopupWindow(parent) {
    if (switchBg == 0)
        switchBg = new YColor(clrQuickSwitch);
    if (switchFg == 0)
        switchFg = new YColor(clrQuickSwitchText);
    if (switchFont == 0)
        switchFont = new YFont(switchFontName);
    
    fActiveWindow = 0;

    int sW = 4 + manager->width() / 5 * 3;
    int sH = 4 + 32;
        //statusFont->max_bounds.ascent +
        //statusFont->max_bounds.descent;

    setGeometry(manager->width() / 2 - sW / 2, manager->height() / 2 - sH / 2,
                sW, sH);

    setStyle(wsOverrideRedirect);
}

SwitchWindow::~SwitchWindow() {
}

void SwitchWindow::paint(Graphics &g, int /*x*/, int /*y*/, unsigned int /*width*/, unsigned int /*height*/) {
    g.setColor(switchBg);
    g.drawBorderW(0, 0, width() - 1, height() - 1, true);
    g.fillRect(1, 1, width() - 3, height() - 3);

    if (fActiveWindow) {
        int ofs = 0, pos;
        if (fActiveWindow->clientIcon() && fActiveWindow->clientIcon()->large()) {
            g.drawPixmap(fActiveWindow->clientIcon()->large(), 2, 2);
            ofs = fActiveWindow->clientIcon()->large()->width() + 2;
        }
        g.setColor(switchFg);
        g.setFont(switchFont);
        char *str = (char *)fActiveWindow->client()->windowTitle();
        if (str) {
            pos = ofs + (width() - ofs) / 2 - switchFont->textWidth(str) / 2;
            if (pos < ofs)
                pos = ofs;
            g.drawChars((char *)str, 0, strlen(str),
                        pos,
                        height() / 2 + (switchFont->height()) / 2
                        - switchFont->descent());
        }
    }
}

// this complication just to put minimized windows last
// is it worth it ??? perhaps
YFrameWindow *SwitchWindow::nextWindow(YFrameWindow *from, bool zdown, bool next) {
    if (from == 0) {
        next = false;
        from = zdown ? manager->topLayer() : manager->bottomLayer();
    }
    int flags =
        YFrameWindow::fwfFocusable |
        YFrameWindow::fwfWorkspace |
        YFrameWindow::fwfLayers |
        YFrameWindow::fwfSwitchable |
        (next ? YFrameWindow::fwfNext: 0) |
        (zdown ? 0 : YFrameWindow::fwfBackward);

    YFrameWindow *n;

    n = from->findWindow(flags | YFrameWindow::fwfUnminimized);
    if (n == 0 && quickSwitchToMinimized)
        n = from->findWindow(flags | YFrameWindow::fwfMinimized);

    if (n == 0) {
        flags |= YFrameWindow::fwfCycle;

        n = from->findWindow(flags | YFrameWindow::fwfUnminimized);
        if (n == 0 && quickSwitchToMinimized)
            n = from->findWindow(flags | YFrameWindow::fwfMinimized);

        if (n == 0)
            n = from->findWindow(flags |
                                 YFrameWindow::fwfVisible |
                                 YFrameWindow::fwfSame);
    }
    return n;
}

void SwitchWindow::begin(bool zdown) {
    fActiveWindow = manager->focus();
    fActiveWindow = nextWindow(fActiveWindow, zdown, true);
    if (fActiveWindow) {
        manager->setFocus(fActiveWindow, false);
        popup(0, 0, 0, YPopupWindow::pfNoPointerChange);
    }
}

void SwitchWindow::activatePopup() {
}

void SwitchWindow::deactivatePopup() {
}

void SwitchWindow::destroyedFrame(YFrameWindow *frame) {
    if (frame == fActiveWindow) {
        fActiveWindow = nextWindow(0, true, false);
        if (fActiveWindow) manager->setFocus(fActiveWindow, false);
        repaint();
    }
}

bool SwitchWindow::handleKey(const XKeyEvent &key) {
    KeySym k = XKeycodeToKeysym(app->display(), key.keycode, 0);
    unsigned int m = KEY_MODMASK(key.state);
    
    if (key.type == KeyPress) {
        if (k == XK_Tab && m == app->AltMask) {
            fActiveWindow = nextWindow(fActiveWindow, true, true);
            if (fActiveWindow) manager->setFocus(fActiveWindow, false);
            repaint();
        } else if ((/*k == XK_BackTab ||*/ k == XK_Tab) && (m == app->AltMask + ShiftMask)) {
            fActiveWindow = nextWindow(fActiveWindow, false, true);
            if (fActiveWindow) manager->setFocus(fActiveWindow, false);
            repaint();
        } else if (k == XK_Escape && m == app->AltMask) {
            cancelPopup();
            if (fActiveWindow) {
                fActiveWindow->wmRaise();
                manager->activate(fActiveWindow, true);
            }
        }
    } else if (key.type == KeyRelease) {
        if (fActiveWindow &&
            (k == XK_Alt_L || k == XK_Alt_R ||
             k == XK_Meta_L || k == XK_Meta_R))
        {
            cancelPopup();
            fActiveWindow->wmRaise();
            manager->activate(fActiveWindow, true);
        }
    }
    return YPopupWindow::handleKey(key);
}

void SwitchWindow::handleButton(const XButtonEvent &button) {
    YPopupWindow::handleButton(button);
}
