/*
 * IceWM
 *
 * Copyright (C) 1997,1998 Marko Macek
 */

#include "icewm.h"

YFrameButton::YFrameButton(YWindow *parent,
                           YFrameWindow *frame,
                           WMCommand command,
                           WMCommand command2):
    YFrameControl(parent, frame)
{
    fCommand = command;
    fCommand2 = command2;
    isDown = isActive = wasPopupActive = isHilited = 0;
    fPopup = 0;

    int w = 18, h = 18; 
    if (minimizePixmap[0]) {
        w = minimizePixmap[0]->width();
        h = minimizePixmap[0]->height();
    }
    switch (wmLook) {
#ifdef CONFIG_LOOK_WARP3
    case lookWarp3:
        setSize(w + 2, h + 2);
        break;
#endif
#ifdef CONFIG_LOOK_WARP4
    case lookWarp4:
        setSize(w + 0, h / 2 + 0);
        break;
#endif
#if defined(CONFIG_LOOK_NICE) || defined(CONFIG_LOOK_WIN95)
#ifdef CONFIG_LOOK_NICE
    case lookNice:
#endif
#ifdef CONFIG_LOOK_WIN95
    case lookWin95:
#endif
        setSize(w + 3, h + 3);
        break;
#endif
#ifdef CONFIG_LOOK_MOTIF
    case lookMotif:
        setSize(w + 2, h + 2);
        break;
#endif
#ifdef CONFIG_LOOK_PIXMAP
    case lookPixmap:
    case lookMetal:
    case lookGtk:
        setSize(w, h);
        break;
#endif
    default:
        break;
    }
}

YFrameButton::~YFrameButton() {
    if (fPopup)
        fPopup->popdown();
}

void YFrameButton::activate() {
    if (!isActive && isDown) {
        isActive = 1;
        repaint();
    }
}

void YFrameButton::deactivate() {
    if (isActive) {
        isActive = 0;
        repaint();
    }
}

void YFrameButton::handleButton(const XButtonEvent &button) {
    if (button.type == ButtonPress && button.button == 1) {
        if (fPopup == 0) {
            if (!(button.state & ControlMask) && raiseOnClickButton) {
                frame()->activate();
                if (raiseOnClickButton)
                    frame()->wmRaise();
            }
        }
        isDown = 1;
        if (fCommand == cmdSysMenu) {
            wasPopupActive = 0;
            if (fPopup) {
                wasPopupActive = 1;
            } else {
                activate();
                fPopup = frame()->windowMenu();
                frame()->popupSystemMenu(x() + frame()->titlebar()->x() + frame()->x(),
                                         height() + y() + frame()->titlebar()->y() + frame()->y(),
                                         width(), height(),
                                         YPopupWindow::pfButtonDown |
                                         YPopupWindow::pfCanFlipVertical,
                                         this);
            }
        } else {
            activate();
        }
    } else if (button.type == ButtonRelease /*&& button.button == 1!!!*/) {
        int inWindow = (button.x >= 0 &&
                        button.y >= 0 &&
                        button.x < int (width()) &&
                        button.y < int (height()));
        int down = isDown;

        if (button.button == 1)
            isDown = 0;
        if (fCommand == cmdSysMenu) {
            if (wasPopupActive || !inWindow) {
                if (fPopup) {
                    donePopup(fPopup);
                    deactivate();
                }
            }
        } else {
            deactivate();

            if (inWindow && down && !isDown) {
                if ((button.state & ShiftMask) && fCommand2 != cmdNone)
                    frame()->handleCommand(fCommand2, 0, button.state);
                else
                    frame()->handleCommand(fCommand, 0, button.state);
                return ;
            }
            if (isDown)
                return ;
        }
    }
    YWindow::handleButton(button);
}

void YFrameButton::handleClick(const XButtonEvent &down, const XButtonEvent &up, int count) {
    if (fCommand == cmdSysMenu && down.button == 1 && up.button == 1) {
        if (count == 2) {
            frame()->wmClose();
            if (fPopup) {
                donePopup(fPopup);
                deactivate();
            }
        }
    } else if (down.button == 3 && (KEY_MODMASK(down.state) & (ShiftMask | app->AltMask)) == 0) {
        if (fPopup) {
        } else {
            frame()->popupSystemMenu(up.x_root, up.y_root, -1, -1,
                                     YPopupWindow::pfCanFlipVertical |
                                     YPopupWindow::pfCanFlipHorizontal);
        }
    }
}

void YFrameButton::handleBeginDrag(const XButtonEvent &down, const XMotionEvent &/*motion*/) {
    if (down.button == 3 && frame()->canMove()) {
        frame()->startMoveSize(1, 1,
                               0, 0,
                               down.x + x() + frame()->titlebar()->x(),
                               down.y + y() + frame()->titlebar()->y());
    }
    //handleDrag(down, motion);
}

void YFrameButton::handleMotion(const XMotionEvent &motion) {
#if 0
    if (isActive && fCommand == cmdSysMenu && (motion.state & Button1Mask)) {
    } else if (isDown) {
        if (motion.x >= 0 && motion.y >= 0 &&
            motion.x < int(width()) && motion.y < int(height()))
            activate();
        else
            deactivate();
    }
#endif
    YWindow::handleMotion(motion);
}

void YFrameButton::handleCrossing(const XCrossingEvent &crossing) {
    if (wmLook == lookNice) {
        if (crossing.type == EnterNotify) {
            isHilited = 1;
            if (isDown)
                activate();
            else
                repaint();
        } else if (crossing.type == LeaveNotify) {
            isHilited = 0;
            if (isDown)
                deactivate();
            else
                repaint();
        }
    }
    YWindow::handleCrossing(crossing);
}

void YFrameButton::setCommand(WMCommand command, WMCommand command2) {
    fCommand2 = command2;
    if (command != fCommand) {
        fCommand = command;
        repaint();
    }
}

void YFrameButton::donePopup(YPopupWindow *popup) {
    if (popup != fPopup) {
        MSG(("popup differs for button??"));
        return ;
    }
    popdownMenu();
}

void YFrameButton::popupMenu() {
    assert(fPopup == 0);
    if (fCommand == cmdSysMenu) {
        isDown = 1;
        isHilited = 1;
        wasPopupActive = 0;
        activate();
        fPopup = frame()->windowMenu();
        frame()->popupSystemMenu(x() + frame()->titlebar()->x() + frame()->x(),
                                 height() + y() + frame()->titlebar()->y() + frame()->y(),
                                 width(), height(),
                                 YPopupWindow::pfCanFlipVertical,
                                 this);
        isDown = 0;
    }
}

void YFrameButton::popdownMenu() {
    if (fPopup) {
        MSG(("done popup in frame button"));
        //isHilited = 0;
        fPopup->popdown();
        isDown = 0;
        isHilited = 0;
        isActive = 0;
        repaint();
        fPopup = 0;
    }
}

void YFrameButton::paint(Graphics &g, int , int , unsigned int , unsigned int ) {
    int xPos = 1, yPos = 1;
    YPixmap *pixmap = 0;
    YPixmap *icon = 0;
    int pn = 0;

    if (wmLook == lookPixmap || wmLook == lookMetal || wmLook == lookGtk)
        pn = frame()->focused() ? 1 : 0;

    g.setColor(titleButtonBg);

    switch (fCommand) {
    case cmdMaximize: pixmap = maximizePixmap[pn]; break;
    case cmdMinimize: pixmap = minimizePixmap[pn]; break;
    case cmdRestore: pixmap = restorePixmap[pn]; break;
    case cmdClose: pixmap = closePixmap[pn]; break;
    case cmdSysMenu: 
        if (frame()->clientIcon())
            icon = frame()->clientIcon()->small(); 
        else 
            icon = 0;
        break;
    default:
        pixmap = 0;
    }

    switch (wmLook) {
#ifdef CONFIG_LOOK_WARP4
    case lookWarp4:
        if (fCommand == cmdSysMenu) {
            g.fillRect(0, 0, width(), height());

            if (isActive)
                g.setColor(activeTitleBarBg);

            g.fillRect(1, 1, width() - 2, height() - 2);
            
            if (icon)
                g.drawPixmap(icon,
                             (width() - icon->width()) / 2,
                             (height() - icon->height()) / 2);
        } else {
            int picYpos = isActive ? 20 : 0;

            g.fillRect(0, 0, width(), height());
            
            if (pixmap)
                XCopyArea(app->display(),
                          pixmap->pixmap(), handle(),
                          g.handle(),
                          0, picYpos,
                          pixmap->width(), pixmap->height() / 2,
                          (width() - pixmap->width()) / 2,
                          (height() - pixmap->height() / 2) / 2);
        }
        break;
#endif
#if defined(CONFIG_LOOK_MOTIF) || defined(CONFIG_LOOK_WARP3) || defined(CONFIG_LOOK_NICE)
#ifdef CONFIG_LOOK_MOTIF
    case lookMotif:
#endif
#ifdef CONFIG_LOOK_WARP3
    case lookWarp3:
#endif
#ifdef CONFIG_LOOK_NICE
    case lookNice:
#endif
        if (wmLook == lookNice && !isHilited)
            g.drawRect(0, 0, width() - 1, height() - 1);
        else
            g.draw3DRect(0, 0, width() - 1, height() - 1,
                         isActive ? false : true);
#ifdef CONFIG_LOOK_MOTIF
        if (wmLook != lookMotif)
#endif
        {
            if (isActive) {
                xPos = 3;
                yPos = 3;
                g.drawLine(1, 1, width() - 2, 1);
                g.drawLine(1, 1, 1, height() - 2);
                g.drawLine(2, 2, width() - 3, 2);
                g.drawLine(2, 2, 2, height() - 3);
            } else {
                xPos = 2;
                yPos = 2;
                g.drawRect(1, 1, width() - 3, width() - 3);
            }
        }
        /* else if (wmLook == lookWin95) {
            xPos = 2;
            yPos = 2;
        }*/

        int xW, yW;
        
#ifdef CONFIG_LOOK_MOTIF
        if (wmLook == lookMotif)
        {
            xW = width() - 2;
            yW = height() - 2;
        } else
#endif
        {
            xW = width() - 4;
            yW = height() - 4;
        }
        if (fCommand == cmdSysMenu) {
            g.fillRect(xPos, yPos, xW, yW);
            
            if (icon)
                g.drawPixmap(icon,
                             xPos + (xW - icon->width()) / 2,
                             yPos + (yW - icon->height()) / 2);
        } else {
            if (pixmap)
                g.drawCenteredPixmap(xPos, yPos, xW, yW, pixmap);
        }
        break;
#endif
#ifdef CONFIG_LOOK_WIN95
    case lookWin95:
        if (fCommand == cmdSysMenu) {
            if (!isActive) {
                YColor *bg = frame()->focused()
                    ? activeTitleBarBg
                    : inactiveTitleBarBg;
                g.setColor(bg);
            }

            g.fillRect(0, 0, width(), height());
            if (icon)
                g.drawPixmap(icon,
                             (width() - icon->width()) / 2,
                             (height() - icon->height()) / 2);
        } else {
            g.drawBorderW(0, 0, width() - 1, height() - 1,
                          isActive ? false: true);

            if (isActive)
                xPos = yPos = 2;

            if (pixmap)
                g.drawCenteredPixmap(xPos, yPos, width() - 3, height() - 3,
                                     pixmap);
        }
        break;
#endif
#ifdef CONFIG_LOOK_PIXMAP
    case lookPixmap:
    case lookMetal:
    case lookGtk:
        {
            int n = isActive ? 1 : 0;
            if (fCommand == cmdSysMenu) {
                YPixmap *pixmap = menuButton[pn];
                int h = pixmap->height() / 2;
                g.copyPixmap(pixmap, 0, n * h, pixmap->width(), h, 0, 0);
                xPos = 0;
                yPos = 0;
                xW = width();
                yW = height();
                if (icon)
                    g.drawPixmap(icon,
                                 xPos + (xW - icon->width()) / 2,
                                 yPos + (yW - icon->height()) / 2);
            } else {
                if (pixmap) {
                    int h = pixmap->height() / 2;
                    g.copyPixmap(pixmap, 0, n * h, pixmap->width(), h, 0, 0);
                } else
                    g.fillRect(0, 0, width(), height());
            }
        }
        break;
#endif
    default:
        break;
    }
}

