/*
 * IceWM
 *
 * Copyright (C) 1997,1998 Marko Macek
 *
 * Dialogs
 */

#include "icewm.h"

#define HORZ 10
#define MIDH 10
#define VERT 10

YColor *dialogBg = 0;

CtrlAltDelete::CtrlAltDelete(YWindow *parent): YWindow(parent) {
    unsigned int w = 0, h = 0;
    YButton *b;
    
    setStyle(wsOverrideRedirect);
    setToplevel(true);
 
    b = lockButton = new YButton(this, cmdNone, 0);
    b->setText("Lock Workstation", 5);
    if (b->width() > w) w = b->width();
    if (b->height() > h) h = b->height();
    b->setListener(this);
    b->show();
    //!!! if (lockCommand == 0)
    //    b->setEnabled(false);
    b = logoutButton = new YButton(this, cmdNone, 0);
    b->setText("Logout...", 0);
    if (b->width() > w) w = b->width();
    if (b->height() > h) h = b->height();
    b->setListener(this);
    b->show();
    b = cancelButton = new YButton(this, cmdNone, 0);
    b->setText("Cancel", 0);
    if (b->width() > w) w = b->width();
    if (b->height() > h) h = b->height();
    b->setListener(this);
    b->show();

    setSize(HORZ + w + MIDH + w + MIDH + w + HORZ,
            VERT + h + VERT);
    setPosition((desktop->width() - width()) / 2,
                (desktop->height() - height()) / 2);

    lockButton->setGeometry(HORZ, VERT, w, h);
    logoutButton->setGeometry(HORZ + w + MIDH, VERT, w, h);
    cancelButton->setGeometry(HORZ + w + MIDH + w + MIDH, VERT, w, h);

}

CtrlAltDelete::~CtrlAltDelete() {
    delete lockButton; lockButton = 0;
    delete logoutButton; logoutButton = 0;
    delete cancelButton; cancelButton = 0;
}

void CtrlAltDelete::paint(Graphics &g, int /*x*/, int /*y*/, unsigned int /*width*/, unsigned int /*height*/) {
    g.setColor(dialogBg);
    g.draw3DRect(0, 0, width() - 1, height() - 1, true);
    g.fillRect(1, 1, width() - 2, height() - 2);
}

void CtrlAltDelete::ButtonClick(YButton *button, unsigned int /*modifiers*/) {
    deactivate();
    if (button == lockButton) {
        if (lockCommand != 0)
            runCommand(lockCommand);
    } else if (button == logoutButton) {
        app->exit(0);
    } else if (button == cancelButton) {
    }
}

bool CtrlAltDelete::handleKey(const XKeyEvent &key) {
    KeySym k = XKeycodeToKeysym(app->display(), key.keycode, 0);
    int m = KEY_MODMASK(key.state);
        
    if (key.type == KeyPress) {
        if (k == XK_Escape && m == 0) {
            deactivate();
            return true;
        }
    }
    return YWindow::handleKey(key);
}

void CtrlAltDelete::activate() {
    raise();
    show();
    if (!app->grabEvents(this, None,
                         ButtonPressMask |
                         ButtonReleaseMask |
                         ButtonMotionMask |
                         EnterWindowMask |
                         LeaveWindowMask, 1, 1, 1))
        hide();
    else {
        requestFocus();
        lockButton->requestFocus();
        lockButton->setFocus();
    }
}

void CtrlAltDelete::deactivate() {
   app->releaseEvents();
   hide();
}
