/*
 * IceWM
 *
 * Copyright (C) 1997,1998 Marko Macek
 */

#include "icewm.h"

void YFrameWindow::updateMenu() {
    YMenu *windowMenu = this->windowMenu();
    // enable all commands
    windowMenu->enableCommand(cmdNone);

    if (isMaximized())
        windowMenu->disableCommand(cmdMaximize);
    if (isMinimized())
        windowMenu->disableCommand(cmdMinimize);
    if (!(isMaximized() || isMinimized() || isHidden()))
        windowMenu->disableCommand(cmdRestore);
    if (isMinimized() || isHidden() || isRollup() || isHidWorkspace() || isHidTransient())
        windowMenu->disableCommand(cmdSize);
    if (isMinimized() || isHidden() || isHidWorkspace() || isHidTransient())
        windowMenu->disableCommand(cmdMove);
    if (!canLower())
        windowMenu->disableCommand(cmdLower);
    if (!canRaise())
        windowMenu->disableCommand(cmdRaise);

    unsigned long func = frameFunctions();

    if (!(func & ffMove))
        windowMenu->disableCommand(cmdMove);
    if (!(func & ffResize))
        windowMenu->disableCommand(cmdSize);
    if (!(func & ffMinimize))
        windowMenu->disableCommand(cmdMinimize);
    if (!(func & ffHide))
        windowMenu->disableCommand(cmdHide);
    if (!(func & ffRollup) || !titlebar()->visible())
        windowMenu->disableCommand(cmdRollup);
    if (!(func & ffMaximize))
        windowMenu->disableCommand(cmdMaximize);
    if (!(func & ffClose))
        windowMenu->disableCommand(cmdClose);

    YMenu::YMenuItem *item = windowMenu->findItem(cmdRollup);
    if (item)
        item->setChecked(isRollup() ? true : false);
    item = windowMenu->findItem(cmdOccupyAllOrCurrent);
    if (item)
        item->setChecked(isSticky() ? true : false);
    item = windowMenu->findSubmenu(moveMenu);
    if (item != 0)
        item->setEnabled(isSticky() ? false : true);
    for (int i = 0; i < moveMenu->itemCount(); i++) {
        item = moveMenu->item(i);
        if (item && item->command() == cmdMoveToWorkspace) {
            CARD32 w = CARD32(item->context());
            bool t = (w == getWorkspace()) ? false : true;
            item->setEnabled(t);
        }
    }
    for (int j = 0; j < layerMenu->itemCount(); j++) {
        item = layerMenu->item(j);
        if (item && item->command() == cmdSetLayer) {
            CARD32 layer = CARD32(item->context());
            bool e = (layer == getLayer()) ? true : false;
            item->setEnabled(!e);
            item->setChecked(e);
        }
    }
}

#ifdef SHAPE
void YFrameWindow::setShape() {
    if (shapesSupported && client()->shaped()) {
        XShapeCombineShape (app->display(), handle(),
                            ShapeBounding,
                            borderX(),
                            borderY()
#ifndef TITLEBAR_BOTTOM
                                + titleY()
#endif
                                ,
                            client()->handle(),
                            ShapeBounding, ShapeSet);
        if (titleY() > 0) {
            XRectangle rect;
            
            rect.x = borderX();
#ifdef TITLEBAR_BOTTOM
            rect.y = height() - borderY() - titleY();
#else
            rect.y = borderY();
#endif
            rect.width  = width() - 2 * borderX();
            rect.height = titleY();

            XShapeCombineRectangles(app->display(), handle(),
                                    ShapeBounding,
                                    0, 0, &rect, 1,
                                    ShapeUnion, Unsorted);
        }
        if ((frameDecors() & (fdResize | fdBorder)) == fdResize + fdBorder) {
            XRectangle rect[4];

            rect[0].x = 0;
            rect[0].y = 0;
            rect[0].width = width();
            rect[0].height = borderY();

            rect[1] = rect[0];
            rect[1].y = height() - borderY();

            rect[2].x = 0;
            rect[2].y = borderY();
            rect[2].width = borderX();
            rect[2].height = height() - 2 * borderY();

            rect[3] = rect[2];
            rect[3].x = width() - borderX();
            
            XShapeCombineRectangles(app->display(), handle(),
                                    ShapeBounding,
                                    0, 0, rect, 4,
                                    ShapeUnion, Unsorted);
        }
    }
}
#endif

void YFrameWindow::configure(int x, int y, unsigned int width, unsigned int height) {
    //int oldX = this->x();
    //int oldY= this->y();
#ifdef SHAPE
    unsigned int oldWidth = this->width();
    unsigned int oldHeight = this->height();
#endif
    
    YWindow::configure(x, y, width, height);

    layoutTitleBar();

    layoutButtons();

    layoutResizeIndicators();

    layoutClient();
    
    // ?
    //if (x != oldX ||
    //    y != oldY)
    sendConfigure();
    
#ifdef SHAPE
    if (width != oldWidth || height != oldHeight)
        setShape();
#endif
    
}

void YFrameWindow::layoutTitleBar() {
    if (titleY() == 0) {
        titlebar()->hide();
    } else {
        titlebar()->show();

        int title_width = width() - 2 * borderX();
        titlebar()->setGeometry(borderX(),
                                borderY()
#ifdef TITLEBAR_BOTTOM
                                + height() - titleY() - 2 * borderY()
#endif
                                ,
                                (title_width > 0) ? title_width : 1,
                                titleY());
    }
}

void YFrameWindow::layoutButtons() {
    if (titleY() == 0)
        return ;
    
    int title_width = width() - 2 * borderX();

    unsigned long decors = frameDecors();

    if (decors & fdMinimize)
        fMinimizeButton->show();
    else
        fMinimizeButton->hide();

    if (decors & fdMaximize)
        fMaximizeButton->show();
    else
        fMaximizeButton->hide();

    if ((decors & fdClose) && useXButton)
        fCloseButton->show();
    else
        fCloseButton->hide();

    if (decors & fdSysMenu)
        fMenuButton->show();
    else
        fMenuButton->hide();

    int xPos = title_width;

    if (wmLook == lookPixmap || wmLook == lookMetal || wmLook == lookGtk) {
        fMenuButton->setGeometry(0, 0, wsTitleBar, wsTitleBar);

        if ((decors & fdClose) && useXButton == 1) {
            int w = closePixmap[0]->width();
            xPos -= w;
            fCloseButton->setGeometry(xPos, 0, w, titleY());
        }

        if (decors & fdMaximize) {
            int w = maximizePixmap[0]->width();
            xPos -= w;
            fMaximizeButton->setGeometry(xPos, 0, w, titleY());
        }

        if (decors & fdMinimize) {
            int w = minimizePixmap[0]->width();
            xPos -= w;
            fMinimizeButton->setGeometry(xPos, 0, w, titleY());
        }
        if ((decors & fdClose) && useXButton == 2) {
            int w = closePixmap[0]->width();
            xPos -= w;
            fCloseButton->setGeometry(xPos, 0, w, titleY());
        }
    } else if (wmLook == lookWin95) {
        fMenuButton->setGeometry(0, 0, wsTitleBar, wsTitleBar);

        if ((decors & fdClose) && useXButton == 1) {
            xPos -= titleY() + 1;
            fCloseButton->setGeometry(xPos, 2, titleY(), titleY() - 3);
            xPos -= 2;
        }

        if (decors & fdMaximize) {
            xPos -= titleY();
            fMaximizeButton->setGeometry(xPos, 2, titleY(), titleY() - 3);
        }

        if (decors & fdMinimize) {
            xPos -= titleY();
            fMinimizeButton->setGeometry(xPos, 2, titleY(), titleY() - 3);
        }
        if ((decors & fdClose) && useXButton == 2) {
            xPos -= titleY();
            fCloseButton->setGeometry(xPos, 2, titleY(), titleY() - 3);
        }
    } else if (wmLook == lookMotif || wmLook == lookWarp3 || wmLook == lookWarp4 || wmLook == lookNice) {
        fMenuButton->setGeometry(0, 0, wsTitleBar, wsTitleBar);
        
        if ((decors & fdClose) && useXButton == 1) {
            xPos -= titleY();
            fCloseButton->setGeometry(xPos, 0, titleY(), titleY());
        }
        if (decors & fdMaximize) {
            xPos -= titleY();
            fMaximizeButton->setGeometry(xPos, 0, titleY(), titleY());
        }
        if (decors & fdMinimize) {
            xPos -= titleY();
            fMinimizeButton->setGeometry(xPos, 0, titleY(), titleY());
        }
        if ((decors & fdClose) && useXButton == 2) {
            xPos -= titleY();
            fCloseButton->setGeometry(xPos, 0, titleY(), titleY());
        }
    }
}

void YFrameWindow::layoutResizeIndicators() {
    if (((frameDecors() & (fdResize | fdBorder)) == fdResize + fdBorder) &&
        !isRollup() && !isMinimized()) {
        if (!indicatorsVisible) {
            indicatorsVisible = 1;

            XMapWindow(app->display(), topSide);
            XMapWindow(app->display(), leftSide);
            XMapWindow(app->display(), rightSide);
            XMapWindow(app->display(), bottomSide);

            XMapWindow(app->display(), topLeftCorner);
            XMapWindow(app->display(), topRightCorner);
            XMapWindow(app->display(), bottomLeftCorner);
            XMapWindow(app->display(), bottomRightCorner);
        }
    } else {
        if (indicatorsVisible) {
            indicatorsVisible = 0;
            
            XUnmapWindow(app->display(), topSide);
            XUnmapWindow(app->display(), leftSide);
            XUnmapWindow(app->display(), rightSide);
            XUnmapWindow(app->display(), bottomSide);

            XUnmapWindow(app->display(), topLeftCorner);
            XUnmapWindow(app->display(), topRightCorner);
            XUnmapWindow(app->display(), bottomLeftCorner);
            XUnmapWindow(app->display(), bottomRightCorner);
        }
    }
    if (!indicatorsVisible)
        return;

    XMoveResizeWindow(app->display(), topSide, 0, 0, width(), borderY());
    XMoveResizeWindow(app->display(), leftSide, 0, 0, borderX(), height());
    XMoveResizeWindow(app->display(), rightSide, width() - borderX(), 0, borderY(), height());
    XMoveResizeWindow(app->display(), bottomSide, 0, height() - borderY(), width(), borderY());
    
    XMoveResizeWindow(app->display(), topLeftCorner, 0, 0, wsCornerX, wsCornerY);
    XMoveResizeWindow(app->display(), topRightCorner, width() - wsCornerX, 0, wsCornerX, wsCornerY);
    XMoveResizeWindow(app->display(), bottomLeftCorner, 0, height() - wsCornerY, wsCornerX, wsCornerY);
    XMoveResizeWindow(app->display(), bottomRightCorner, width() - wsCornerX, height() - wsCornerY, wsCornerX, wsCornerY);
}

void YFrameWindow::layoutClient() {
    if (!isRollup() && !isIconic()) {
        //int x = this->x() + borderX();
        //int y = this->y() + borderY();
        int w = this->width() - 2 * borderX();
        int h = this->height() - 2 * borderY() - titleY();

        fClientContainer->setGeometry(borderX(), borderY()
#ifndef TITLEBAR_BOTTOM
                                      + titleY()
#endif
                                  , w, h);
        fClient->setGeometry(0, 0, w, h);
    }
}

bool YFrameWindow::canClose() {
    if (frameFunctions() & ffClose)
        return true;
    else
        return false;
}

bool YFrameWindow::canMaximize() {
    if (frameFunctions() & ffMaximize)
        return true;
    else
        return false;
}

bool YFrameWindow::canMinimize() {
    if (frameFunctions() & ffMinimize)
        return true;
    else
        return false;
}

bool YFrameWindow::canRollup() {
    if (frameFunctions() & ffRollup)
        return true;
    else
        return false;
}

bool YFrameWindow::canHide() {
    if (frameFunctions() & ffHide)
        return true;
    else
        return false;
}

bool YFrameWindow::canLower() {
    // !!! fix
    if (this != manager->bottom(getLayer()))
        return true;
    else
        return false;
}
bool YFrameWindow::canRaise() {
    // !!! fix
    if (this != manager->top(getLayer()))
        return true;
    else
        return false;
}
