/*
 * IceWM
 *
 * Copyright (C) 1998 Marko Macek
 *
 * CPU Status
 * !!! this should be external module
 */

#include "icewm.h"

#define UPDATE_INTERVAL 500

CPUStatus::CPUStatus(YWindow *aParent = 0): YWindow(aParent) {
    fUpdateTimer = new YTimer();
    if (fUpdateTimer) {
        fUpdateTimer->setInterval(UPDATE_INTERVAL);
        fUpdateTimer->setListener(this);
        fUpdateTimer->startTimer();
    }
    color[0] = new YColor("#0F0");
    color[1] = new YColor("#F00");
    color[2] = new YColor("#00F");
    color[3] = new YColor("#000");
    for (int i = 0; i < CPU_SAMPLES; i++) {
        cpu[i][0] = cpu[i][1] = cpu[i][2] = 0;
        cpu[i][3] = 1;
    }
    setSize(CPU_SAMPLES, 20);
    last_cpu[0] = last_cpu[1] = last_cpu[2] = last_cpu[3] = 0;
    getStatus(0);
    updateStatus();
    setToolTip("CPU Status");
}

CPUStatus::~CPUStatus() {
    delete color[0];
    delete color[1];
    delete color[2];
    delete color[3];
}

void CPUStatus::paint(Graphics &g, int /*x*/, int /*y*/, unsigned int /*width*/, unsigned int /*height*/) {
    int n, h = height();

    for (int i = 0; i < CPU_SAMPLES; i++) {
        int user = cpu[i][0];
        int nice = cpu[i][1];
        int sys = cpu[i][2];
        int idle = cpu[i][3];
        int total = user + sys + nice + idle;

        int y = height() - 1;

        if (total > 0) {
            if (sys) {
                n = h*sys/total;
                y -= n;
                g.setColor(color[1]);
                g.drawLine(i, y, i, y + n);
                y--;
            }

            if (nice) {
                n = h*nice/total;
                y -= n;
                g.setColor(color[2]);
                g.drawLine(i, y, i, y + n);
                y--;
            }

            if (user) {
                n = h*user/total;
                y -= n;
                if (idle == 0 && y != 0) {
                    n += y;
                    y = 0;
                }
                g.setColor(color[0]);
                g.drawLine(i, y, i, y + n);
                y--;
            }
        }
        if (idle) {
            g.setColor(color[3]);
            g.drawLine(i, 0, i, y);
        }
    }
}

bool CPUStatus::handleTimer(YTimer *t) {
    assert(t == fUpdateTimer);
    updateStatus();
    return true;
}

void CPUStatus::updateStatus() {
    for (int i = 1; i < CPU_SAMPLES; i++) {
        cpu[i - 1][0] = cpu[i][0];
        cpu[i - 1][1] = cpu[i][1];
        cpu[i - 1][2] = cpu[i][2];
        cpu[i - 1][3] = cpu[i][3];
    }
    getStatus(cpu[CPU_SAMPLES - 1]),
    repaint(); // !!! optimize this (scroll+draw)
}

void CPUStatus::getStatus(int *cpuval) {
    char *p, buf[128];
    long cur[4];
    int len, fd = open("/proc/stat", O_RDONLY);
    
    if (cpuval)
        cpuval[0] = cpuval[1] = cpuval[2] = cpuval[3] = 0;
    if (fd == -1)
        return;
    len = read(fd, buf, sizeof(buf) - 1);
    if (len != sizeof(buf) - 1) {
        close(fd);
        return;
    }
    buf[len] = 0;

    p = buf;
    while (*p && (*p < '0' || *p > '9'))
        p++;

    for (int i = 0; i < 4; i++) {
        cur[i] = strtoul(p, &p, 10);
        if (cpuval)
            cpuval[i] = cur[i] - last_cpu[i];
        last_cpu[i] = cur[i];
    }
    close(fd);
#if 0
    if (cpuval)
        fprintf(stderr, "cpu: %d %d %d %d\n", 
                cpuval[0], cpuval[1], cpuval[2], cpuval[3]);
#endif
}
