/*
 *--------------------------------*-C-*---------------------------------
 * File:        debug.h
 *
 * Copyright (c) 1994 R. Nation <nation@rocket.sanders.lockheed.com>
 * Copyright (c) 1997 Mj Olesen <olesen@me.QueensU.CA>
 * Copyright (c) 1997 Raul Garcia Garcia <rgg@tid.es>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License version
 *  2 as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *----------------------------------------------------------------------
 */

#ifndef _DEBUG_H
#define _DEBUG_H

#include <X11/Xfuncproto.h>

/*{{{ prototypes */
_XFUNCPROTOBEGIN

extern void *
 safe_malloc(size_t /* size */ ,
	     const char * /* id */ );

extern void *
 safe_calloc(size_t /* count */ ,
	     size_t /* size */ ,
	     const char * /* id */ );

extern void *
 safe_realloc(void * /* mem */ ,
	      size_t /* size */ ,
	      const char * /* id */ );

extern void
 safe_free(void * /* mem */ ,
	   const char * /* id1 */ ,
	   const char * /* id2 */ );

extern void
 safe_mem_check(const char * /* id1 */ ,
		const char * /* id2 */ );

extern void *
 my_malloc(size_t /* size */ );

extern void *
 my_calloc(size_t /* count */ ,
	   size_t /* size */ );

extern void *
 my_realloc(void * /* mem */ ,
	    size_t /* size */ );

extern void
 my_free(void * /* mem */ );

_XFUNCPROTOEND
/*}}} */

/*{{{ macros */
#ifdef DEBUG_MALLOC
#define MALLOC(sz,id)		safe_malloc ((sz),id)
#define CALLOC(n,sz,id)	safe_calloc ((n),(sz),id)
#define REALLOC(mem,sz,id)	safe_realloc ((mem),(sz),id)
#define FREE(mem,id,fn)	safe_free ((mem),id,fn)
#define MEM_CHECK(id1,id2)	safe_mem_check (id1,id2)
#else
#define MALLOC(sz,id)		my_malloc (sz)
#define CALLOC(n,sz,id)	my_calloc ((n),(sz))
#define REALLOC(mem,sz,id)	my_realloc ((mem),(sz))
#define FREE(ptr,id,fn)	my_free (ptr)
#define MEM_CHECK(id1,id2)	((void)0)
#endif
/*}}} */

#endif				/* whole file */
/*----------------------- end-of-file (C header) -----------------------*/
