/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class LDAPUrl {
    public static String defaultFilter = "(objectClass=*)";
    private String hostName;
    private int portNumber;
    private String DN;
    private Vector attributes;
    private int scope;
    private String filter;
    private String URL;

    public LDAPUrl(String url) throws MalformedURLException {
        StringTokenizer urlParser = new StringTokenizer(url, ":/?", true);
        String attributeList = null;
        this.attributes = null;
        this.scope = 0;
        this.filter = defaultFilter;
        this.URL = url;
        try {
            String currentToken = urlParser.nextToken();
            if (!currentToken.equalsIgnoreCase("LDAP")) {
                throw new MalformedURLException();
            }
            urlParser.nextToken();
            urlParser.nextToken();
            urlParser.nextToken();
            currentToken = urlParser.nextToken();
            if (currentToken.equals("/")) {
                this.hostName = null;
                this.portNumber = 389;
            } else {
                this.hostName = currentToken;
                if (urlParser.countTokens() == 0) {
                    this.portNumber = 389;
                    return;
                }
                currentToken = urlParser.nextToken();
                if (currentToken.equals(":")) {
                    this.portNumber = Integer.parseInt(urlParser.nextToken());
                    if (urlParser.countTokens() == 0) {
                        return;
                    }
                    urlParser.nextToken();
                } else {
                    this.portNumber = 389;
                }
            }
            this.DN = LDAPUrl.decode(urlParser.nextToken());
            if (this.DN.equals("?")) {
                this.DN = "";
            }
            if (urlParser.hasMoreTokens()) {
                String str = null;
                str = this.readNextConstruct(urlParser);
                if (str != null && this.isAttribute(str)) {
                    if (str.equals("?")) {
                        attributeList = null;
                        str = urlParser.nextToken();
                    } else {
                        attributeList = LDAPUrl.decode(str);
                        str = this.readNextConstruct(urlParser);
                    }
                }
                if (str != null && (this.scope = this.getScope(str)) != -1) {
                    str = this.readNextConstruct(urlParser);
                } else if (str != null && str.equals("?")) {
                    this.scope = 0;
                    str = urlParser.nextToken();
                } else {
                    this.scope = 0;
                }
                if (str != null && this.isFilter(str)) {
                    this.filter = LDAPUrl.decode(str);
                    str = this.readNextConstruct(urlParser);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedURLException();
        }
        if (attributeList != null) {
            StringTokenizer attributeParser = new StringTokenizer(attributeList, ", ");
            this.attributes = new Vector();
            while (attributeParser.hasMoreTokens()) {
                this.attributes.addElement(attributeParser.nextToken());
            }
        }
    }

    public LDAPUrl(String host, int port, String DN2) {
        this.URL = host != null ? (port != 389 ? "LDAP://" + host + ":" + String.valueOf(port) + "/" + LDAPUrl.encode(DN2) : "LDAP://" + host + "/" + LDAPUrl.encode(DN2)) : "LDAP:///" + LDAPUrl.encode(DN2);
        this.hostName = host;
        this.DN = DN2;
        this.portNumber = port;
        this.filter = defaultFilter;
        this.attributes = null;
        this.scope = 0;
    }

    public LDAPUrl(String host, int port, String DN2, String[] attributes, int scope, String filter) {
        if (attributes != null) {
            Vector<String> list = new Vector<String>();
            int k = 0;
            while (k < attributes.length) {
                list.addElement(attributes[k]);
                ++k;
            }
            this.initialize(host, port, DN2, list.elements(), scope, filter);
            return;
        }
        this.initialize(host, port, DN2, null, scope, filter);
    }

    public LDAPUrl(String host, int port, String DN2, Enumeration attributes, int scope, String filter) {
        this.initialize(host, port, DN2, attributes, scope, filter);
    }

    private void initialize(String host, int port, String DN2, Enumeration attributes, int scope, String filter) {
        this.hostName = host;
        this.DN = DN2;
        this.portNumber = port;
        this.filter = filter != null ? filter : defaultFilter;
        this.scope = scope;
        if (attributes != null) {
            this.attributes = new Vector();
            while (attributes.hasMoreElements()) {
                this.attributes.addElement(attributes.nextElement());
            }
        } else {
            this.attributes = null;
        }
        StringBuffer url = new StringBuffer("LDAP://");
        if (host != null) {
            url.append(host);
            if (port != 389) {
                url.append(':');
                url.append(String.valueOf(port));
            }
        }
        url.append('/');
        url.append(LDAPUrl.encode(DN2));
        if (attributes != null) {
            url.append('?');
            Enumeration attrList = this.attributes.elements();
            boolean firstElement = true;
            while (attrList.hasMoreElements()) {
                if (!firstElement) {
                    url.append(',');
                } else {
                    firstElement = false;
                }
                url.append((String)attrList.nextElement());
            }
        }
        if (filter != null) {
            if (attributes == null) {
                url.append('?');
            }
            url.append('?');
            switch (scope) {
                default: {
                    url.append("base");
                    break;
                }
                case 1: {
                    url.append("one");
                    break;
                }
                case 2: {
                    url.append("sub");
                }
            }
            url.append('?');
            url.append(filter);
        }
        this.URL = url.toString();
    }

    public String getHost() {
        return this.hostName;
    }

    public int getPort() {
        return this.portNumber;
    }

    public String getDN() {
        return this.DN;
    }

    public Enumeration getAttributes() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.elements();
    }

    public String[] getAttributeArray() {
        if (this.attributes == null) {
            return null;
        }
        String[] attrNames = new String[this.attributes.size()];
        Enumeration attrs = this.getAttributes();
        int i = 0;
        while (attrs.hasMoreElements()) {
            attrNames[i++] = (String)attrs.nextElement();
        }
        return attrNames;
    }

    public int getScope() {
        return this.scope;
    }

    private int getScope(String str) {
        int s = -1;
        if (str.equalsIgnoreCase("base")) {
            s = 0;
        } else if (str.equalsIgnoreCase("one")) {
            s = 1;
        } else if (str.equalsIgnoreCase("sub")) {
            s = 2;
        }
        return s;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getUrl() {
        return this.URL;
    }

    private boolean isFilter(String str) {
        return str.startsWith("(");
    }

    private boolean isAttribute(String str) {
        return !str.startsWith("(") && !str.equalsIgnoreCase("base") && !str.equalsIgnoreCase("one") && !str.equalsIgnoreCase("sub");
    }

    private String readNextConstruct(StringTokenizer parser) throws MalformedURLException {
        try {
            if (parser.hasMoreTokens()) {
                parser.nextToken();
                return parser.nextToken();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new MalformedURLException();
        }
        return null;
    }

    private static int hexValue(char hexChar) throws MalformedURLException {
        if (hexChar >= '0' && hexChar <= '9') {
            return hexChar - 48;
        }
        if (hexChar >= 'A' && hexChar <= 'F') {
            return hexChar - 65 + 10;
        }
        if (hexChar >= 'a' && hexChar <= 'f') {
            return hexChar - 97 + 10;
        }
        throw new MalformedURLException();
    }

    private static char hexChar(int hexValue) {
        if (hexValue < 0 || hexValue > 15) {
            return 'x';
        }
        if (hexValue < 10) {
            return (char)(hexValue + 48);
        }
        return (char)(hexValue - 10 + 97);
    }

    public static String decode(String URLEncoded) throws MalformedURLException {
        StringBuffer decoded = new StringBuffer(URLEncoded);
        int srcPos = 0;
        int dstPos = 0;
        try {
            while (srcPos < decoded.length()) {
                if (decoded.charAt(srcPos) != '%') {
                    if (srcPos != dstPos) {
                        decoded.setCharAt(dstPos, decoded.charAt(srcPos));
                    }
                    ++srcPos;
                    ++dstPos;
                    continue;
                }
                decoded.setCharAt(dstPos, (char)(LDAPUrl.hexValue(decoded.charAt(srcPos + 1)) << 4 | LDAPUrl.hexValue(decoded.charAt(srcPos + 2))));
                ++dstPos;
                srcPos += 3;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new MalformedURLException();
        }
        decoded.setLength(dstPos);
        return decoded.toString();
    }

    public static String encode(String toEncode) {
        StringBuffer encoded = new StringBuffer(toEncode.length() + 10);
        int currPos = 0;
        while (currPos < toEncode.length()) {
            char currChar = toEncode.charAt(currPos);
            if (currChar >= 'a' && currChar <= 'z' || currChar >= 'A' && currChar <= 'Z' || currChar >= '0' && currChar <= '9' || "$-_.+!*'(),".indexOf(currChar) > 0) {
                encoded.append(currChar);
            } else {
                encoded.append("%");
                encoded.append(LDAPUrl.hexChar((currChar & 0xF0) >> 4));
                encoded.append(LDAPUrl.hexChar(currChar & 0xF));
            }
            ++currPos;
        }
        return encoded.toString();
    }
}

