/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPRebind;

public class LDAPSearchConstraints
implements Cloneable {
    private int timeLimit;
    private int deref;
    private int maxRes;
    private boolean referrals;
    private int batch;
    private LDAPRebind m_rebind_proc;
    private int m_hop_limit;
    private LDAPControl[] m_clientControls;
    private LDAPControl[] m_serverControls;

    public LDAPSearchConstraints() {
        this.timeLimit = 0;
        this.deref = 0;
        this.maxRes = 1000;
        this.referrals = false;
        this.batch = 1;
        this.m_rebind_proc = null;
        this.m_hop_limit = 10;
        this.m_clientControls = null;
        this.m_serverControls = null;
    }

    public LDAPSearchConstraints(int msLimit, int dereference, int maxResults, boolean doReferrals, int batchSize, LDAPRebind rebind_proc, int hop_limit) {
        this.timeLimit = msLimit;
        this.deref = dereference;
        this.maxRes = maxResults;
        this.referrals = doReferrals;
        this.batch = batchSize;
        this.m_rebind_proc = rebind_proc;
        this.m_hop_limit = hop_limit;
        this.m_clientControls = null;
        this.m_serverControls = null;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public int getDereference() {
        return this.deref;
    }

    public int getMaxResults() {
        return this.maxRes;
    }

    public boolean getReferrals() {
        return this.referrals;
    }

    public int getBatchSize() {
        return this.batch;
    }

    public LDAPRebind getRebindProc() {
        return this.m_rebind_proc;
    }

    public int getHopLimit() {
        return this.m_hop_limit;
    }

    public LDAPControl[] getClientControls() {
        return this.m_clientControls;
    }

    public LDAPControl[] getServerControls() {
        return this.m_serverControls;
    }

    public void setTimeLimit(int msLimit) {
        this.timeLimit = msLimit;
    }

    public void setDereference(int dereference) {
        this.deref = dereference;
    }

    public void setMaxResults(int maxResults) {
        this.maxRes = maxResults;
    }

    public void setReferrals(boolean doReferrals) {
        this.referrals = doReferrals;
    }

    public void setBatchSize(int batchSize) {
        this.batch = batchSize;
    }

    public void setRebindProc(LDAPRebind rebind_proc) {
        this.m_rebind_proc = rebind_proc;
    }

    public void setHopLimit(int hop_limit) {
        this.m_hop_limit = hop_limit;
    }

    public void setClientControls(LDAPControl control) {
        this.m_clientControls = new LDAPControl[1];
        this.m_clientControls[0] = control;
    }

    public void setClientControls(LDAPControl[] controls) {
        this.m_clientControls = controls;
    }

    public void setServerControls(LDAPControl control) {
        this.m_serverControls = new LDAPControl[1];
        this.m_serverControls[0] = control;
    }

    public void setServerControls(LDAPControl[] controls) {
        this.m_serverControls = controls;
    }

    public Object clone() {
        int i;
        LDAPSearchConstraints o = new LDAPSearchConstraints();
        o.timeLimit = this.timeLimit;
        o.deref = this.deref;
        o.maxRes = this.maxRes;
        o.referrals = this.referrals;
        o.batch = this.batch;
        o.m_rebind_proc = this.m_rebind_proc;
        o.m_hop_limit = this.m_hop_limit;
        if (this.m_clientControls != null && this.m_clientControls.length > 0) {
            o.m_clientControls = new LDAPControl[this.m_clientControls.length];
            i = 0;
            while (i < this.m_clientControls.length) {
                o.m_clientControls[i] = this.m_clientControls[i];
                ++i;
            }
        }
        if (this.m_serverControls != null && this.m_serverControls.length > 0) {
            o.m_serverControls = new LDAPControl[this.m_serverControls.length];
            i = 0;
            while (i < this.m_serverControls.length) {
                o.m_serverControls[i] = this.m_serverControls[i];
                ++i;
            }
        }
        return o;
    }
}

