/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.io.InputStream;
import java.net.URL;
import netscape.application.Application;
import netscape.util.Vector;

class AppletResources {
    Application _applet;
    URL _baseURL;
    String _subdirectory = "";
    static final String CONTENTS = ".contents";
    static final String LANGUAGES = "Languages";
    static final String INTERFACES_DIRECTORY = "interfaces";
    static final String IMAGE_DIRECTORY = "images";
    static final String FONT_DIRECTORY = "fonts";
    static final String SOUND_DIRECTORY = "sounds";

    public AppletResources(Application applet, URL baseURL) {
        this._applet = applet;
        this._baseURL = baseURL;
    }

    public void setBaseURL(URL baseURL) {
        this._baseURL = baseURL;
    }

    public URL baseURL() {
        return this._baseURL;
    }

    public void setSubdirectory(String subdirectoryName) {
        this._subdirectory = subdirectoryName;
        if (this._subdirectory == null) {
            this._subdirectory = "";
        }
    }

    public String subdirectory() {
        return this._subdirectory;
    }

    public Vector availableLanguages() {
        return null;
    }

    private URL _urlFromBaseAndPath(URL baseURL, String path) {
        URL documentURL;
        try {
            documentURL = new URL(baseURL, path);
        }
        catch (Exception e) {
            System.err.println("appletResources._urlFromBaseAndPath() - " + e);
            documentURL = null;
        }
        return documentURL;
    }

    public Vector URLsForResource(String resourceName) {
        Vector urlVector = new Vector();
        String subDir = this._subdirectory;
        if (subDir.length() > 0 && subDir.charAt(subDir.length() - 1) != '/') {
            subDir = String.valueOf(subDir) + "/";
        }
        Vector languagePreferences = this._applet.languagePreferences();
        Vector availableLanguages = this.availableLanguages();
        if (availableLanguages == null) {
            int count = languagePreferences.count();
            int i = 0;
            while (i < count) {
                urlVector.addElement(this._urlFromBaseAndPath(this._baseURL, String.valueOf((String)languagePreferences.elementAt(i)) + ".pkg/" + subDir + resourceName));
                ++i;
            }
            urlVector.addElement(this._urlFromBaseAndPath(this._baseURL, String.valueOf(subDir) + resourceName));
            return urlVector;
        }
        if (availableLanguages.isEmpty()) {
            urlVector.addElement(this._urlFromBaseAndPath(this._baseURL, String.valueOf(subDir) + resourceName));
            return urlVector;
        }
        if (languagePreferences.isEmpty()) {
            int count = availableLanguages.count();
            int i = 0;
            while (i < count) {
                urlVector.addElement(this._urlFromBaseAndPath(this._baseURL, String.valueOf((String)availableLanguages.elementAt(i)) + ".pkg/" + subDir + resourceName));
                ++i;
            }
            urlVector.addElement(this._urlFromBaseAndPath(this._baseURL, String.valueOf(subDir) + resourceName));
            return urlVector;
        }
        int count = languagePreferences.count();
        int i = 0;
        while (i < count) {
            if (availableLanguages.contains(languagePreferences.elementAt(i))) {
                urlVector.addElement(this._urlFromBaseAndPath(this._baseURL, String.valueOf((String)languagePreferences.elementAt(i)) + ".pkg/" + subDir + resourceName));
            }
            ++i;
        }
        count = availableLanguages.count();
        i = 0;
        while (i < count) {
            if (!languagePreferences.contains(availableLanguages.elementAt(i))) {
                urlVector.addElement(this._urlFromBaseAndPath(this._baseURL, String.valueOf((String)availableLanguages.elementAt(i)) + ".pkg/" + subDir + resourceName));
            }
            ++i;
        }
        urlVector.addElement(this._urlFromBaseAndPath(this._baseURL, String.valueOf(subDir) + resourceName));
        return urlVector;
    }

    public Vector URLsForInterface(String interfaceName) {
        return this.URLsForResource("interfaces/" + interfaceName);
    }

    public Vector URLsForImage(String imageName) {
        return this.URLsForResource("images/" + imageName);
    }

    public Vector URLsForFont(String fontName) {
        return this.URLsForResource("fonts/" + fontName);
    }

    public Vector URLsForSound(String soundName) {
        return this.URLsForResource("sounds/" + soundName);
    }

    public Vector URLsForResourceOfType(String resourceName, String type) {
        return this.URLsForResource(String.valueOf(type) + "/" + resourceName);
    }

    public InputStream streamForURLs(Vector urlVector) {
        if (urlVector == null || urlVector.isEmpty()) {
            return null;
        }
        int count = urlVector.count();
        int i = 0;
        while (i < count) {
            try {
                URL documentURL = (URL)urlVector.elementAt(i);
                InputStream inputStream = documentURL.openStream();
                return inputStream;
            }
            catch (Exception exception) {
                ++i;
            }
        }
        return null;
    }

    public InputStream streamForInterface(String interfaceName) {
        return this.streamForURLs(this.URLsForInterface(interfaceName));
    }

    URL urlForBitmapNamed(String bitmapName) {
        Vector urlVector = this.URLsForImage(bitmapName);
        if (urlVector.count() > 0) {
            return (URL)urlVector.elementAt(0);
        }
        return null;
    }

    URL urlForSoundNamed(String soundName) {
        Vector urlVector = this.URLsForSound(soundName);
        if (urlVector.count() > 0) {
            return (URL)urlVector.elementAt(0);
        }
        return null;
    }

    URL urlForFontNamed(String fontName) {
        Vector urlVector = this.URLsForFont(fontName);
        if (urlVector.count() > 0) {
            return (URL)urlVector.elementAt(0);
        }
        return null;
    }

    public InputStream streamForResourceOfType(String resourceName, String type) {
        return this.streamForURLs(this.URLsForResourceOfType(resourceName, type));
    }
}

