/***************************************************************************
 *
 * $Header: /home/werner/ytree/RCS/group.c,v 1.9 1997/08/13 12:24:58 werner Rel $
 *
 * Handhabung von Gruppen-Nummern / Namen
 *
 ***************************************************************************/


#include "ytree.h"

#ifdef WIN32

#include "grp.h"

#else

typedef struct
{
  int   gid;
  char  name[GROUP_NAME_MAX + 1];
} GroupEntry;


extern struct group *getgrent(void);
#if !defined( __FreeBSD__ ) && !defined( OSF1 )
extern void         setgrent(void);
#endif

static GroupEntry   *group_array;
static unsigned int group_count;


#endif /* WIN32 */



int ReadGroupEntries(void)
{
#ifndef WIN32

  int i;
  struct group *grp_ptr;
  

  for( group_count=0; getgrent(); group_count++ )
    ;

  setgrent();

  if( group_array ) 
  {
    free( group_array );
    group_array = NULL;
  }

  if( group_count == 0 )
  {
    group_array = NULL;
  }
  else
  {
    if( ( group_array = (GroupEntry *) calloc( group_count, 
					       sizeof( GroupEntry )
					     ) ) == NULL )
    {
      ERROR_MSG( "Calloc Failed" );
      group_array = NULL;
      group_count = 0;
      return( 1 );
    }
  }

  for(i=0; i < group_count; i++)
  {
    if( ( grp_ptr = getgrent() ) == NULL )
    {
      ERROR_MSG( "Getgrent Failed" );
      if( group_array) free( group_array );
      group_array = NULL;
      group_count = 0;
      return( 1 );
    }
  
    group_array[i].gid = grp_ptr->gr_gid;
    (void) strcpy( group_array[i].name, grp_ptr->gr_name );
  }

#endif /* WIN32 */

  return( 0 );
}




char *GetGroupName(unsigned int gid)
{
#ifdef WIN32

  struct group *group_ptr;

  group_ptr = getgrgid( gid );

  if( group_ptr ) return( group_ptr->gr_name );
  else            return( NULL );

#else

  int i;

  for( i=0; i < group_count; i++ )
  {
    if( group_array[i].gid == gid )
      return( group_array[i].name );
  }

  return( NULL );

#endif /* WIN32 */

}




int GetGroupId(char *name)
{
#ifdef WIN32

  struct group *group_ptr;

  group_ptr = getgrnam( name );

  if( group_ptr ) return( group_ptr->gr_gid );
  else            return( -1 );

#else

  int i;

  for( i=0; i < group_count; i++ )
  {
    if( !strcmp( name, group_array[i].name ) )
      return( (int) group_array[i].gid );
  }
  return( -1 );

#endif /* WIN32 */

}


