;;; skk-foreword.el --- $BA0=q$-(B
;; Copyright (C) 1997, 1998 Mikio Nakajima <minakaji@osaka.email.ne.jp>

;; Author: Mikio Nakajima <minakaji@osaka.email.ne.jp>
;; Maintainer: Hideki Sakurada <sakurada@kuis.kyoto-u.ac.jp>
;;             Murata Shuuichirou  <mrt@astec.co.jp>
;;             Mikio Nakajima <minakaji@osaka.email.ne.jp>
;; Version: $Id: skk-foreword.el,v 1.18 1998/10/17 13:41:47 minakaji Exp $
;; Keywords: japanese
;; Last Modified: $Date: 1998/10/17 13:41:47 $

;; This file is not part of SKK yet.

;; SKK is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either versions 2, or (at your option)
;; any later version.

;; SKK is distributed in the hope that it will be useful
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SKK, see the file COPYING.  If not, write to the Free
;; Software Foundation Inc., 59 Temple Place - Suite 330, Boston,
;; MA 02111-1307, USA.

;;; Commentary:

;; $B$3$N%U%!%$%k$O!"%f!<%6!<JQ?t$N@k8@<+BN$K;HMQ$9$k%^%/%m!"(Bskk-*.el $B$G(B
;; $B;HMQ$9$k%^%/%m$J$I!"JQ?t$N@k8@0JA0!"(Bskk-*.el $B$N:G=i$KDj5A$7$F$*$+$J(B
;; $B$1$l$P$J$i$J$$$b$N$r$^$H$a$?$b$N$G$9!#%f!<%6!<JQ?t$NDj5A$NA0$K!"$4(B
;; $B$A$c$4$A$c$H%f!<%6!<$K6=L#$,$J$$$b$N$,JB$s$G$$$?$N$G$O!"%f!<%6!<%U(B
;; $B%l%s%I%j!<$G$O$J$$$H9M$($k$+$i$G$9!#(B
;; 
;; Following people contributed modifications to skk-foreword.el (Alphabetical order):
;;       Hideki Sakurada <sakurada@kuis.kyoto-u.ac.jp>
;;       Shuhei KOBAYASHI <shuhei-k@jaist.ac.jp>
;;       $B>.Ln(B $B9'CK(B <takao@hirata.nuee.nagoya-u.ac.jp>

;;; Change log:

;;; Code:
(require 'easymenu)

;; necessary macro and functions to be declared before user variable declarations.

;;;; macros

;; Why I use non-intern temporary variable in the macro --- see comment in
;; save-match-data of subr.el of GNU Emacs. And should we use the same manner
;; in the save-current-buffer, with-temp-buffer and with-temp-file macro
;; definition?
;;;###skk-autoload
(defmacro skk-save-point (&rest body)
  (` (let ((skk-save-point (point-marker)))
       (unwind-protect
	   (progn (,@ body))
	 (goto-char skk-save-point)
         (skk-set-marker skk-save-point nil) ))))

;;;###skk-autoload
(defmacro skk-message (japanese english &rest arg)
  ;; skk-japanese-message-and-error $B$,(B non-nil $B$@$C$?$i(B JAPANESE $B$r(B nil $B$G$"$l(B
  ;; $B$P(B ENGLISH $B$r%(%3!<%(%j%"$KI=<($9$k!#(B
  ;; ARG $B$O(B message $B4X?t$NBh#20z?t0J9_$N0z?t$H$7$FEO$5$l$k!#(B
  (append (list 'message (list 'if 'skk-japanese-message-and-error
			       japanese english ))
	  arg ))

;;;###skk-autoload
(defmacro skk-error (japanese english &rest arg)
  ;; skk-japanese-message-and-error $B$,(B non-nil $B$@$C$?$i(B JAPANESE $B$r(B nil $B$G$"$l(B
  ;; $B$P(B ENGLISH $B$r%(%3!<%(%j%"$KI=<($7!"%(%i!<$rH/@8$5$;$k!#(B
  ;; ARG $B$O(B error $B4X?t$NBh#20z?t0J9_$N0z?t$H$7$FEO$5$l$k!#(B
  (append (list 'error (list 'if 'skk-japanese-message-and-error
			     japanese english ))
	  arg ))

;;;###skk-autoload
(defmacro skk-yes-or-no-p (japanese english)
  ;; skk-japanese-message-and-error $B$,(B non-nil $B$G$"$l$P!"(Bjapanese $B$r(B nil $B$G$"(B
  ;; $B$l$P(B english $B$r%W%m%s%W%H$H$7$F(B yes-or-no-p $B$r<B9T$9$k!#(B
  ;; yes-or-no-p $B$N0z?t$N%W%m%s%W%H$,J#;($KF~$l9~$s$G$$$k>l9g$O$3$N%^%/%m$r;H(B
  ;; $B$&$h$j%*%j%8%J%k$N(B yes-or-no-p $B$r;HMQ$7$?J}$,%3!<%I$,J#;($K$J$i$J$$>l9g$,(B
  ;; $B$"$k!#(B
  (list 'yes-or-no-p (list 'if 'skk-japanese-message-and-error
				   japanese english )))
  
;;;###skk-autoload
(defmacro skk-y-or-n-p (japanese english)
  ;; skk-japanese-message-and-error $B$,(B non-nil $B$G$"$l$P!"(Bjapanese $B$r(B nil $B$G$"(B
  ;; $B$l$P(B english $B$r%W%m%s%W%H$H$7$F(B y-or-n-p $B$r<B9T$9$k!#(B
  (list 'y-or-n-p (list 'if 'skk-japanese-message-and-error
				japanese english )))

;;;###skk-autoload
(defmacro skk-set-marker (marker position &optional buffer)
  ;; $B%P%C%U%!%m!<%+%kCM$G$"$k(B skk-henkan-start-point, skk-henkan-end-point,
  ;; skk-kana-start-point, $B$"$k$$$O(B skk-okurigana-start-point $B$,(B nil $B$@$C$?$i!"(B
  ;; $B?75,%^!<%+!<$r:n$C$FBeF~$9$k!#(B
  ;;
  ;; skk.el $B$N%P%C%U%!%m!<%+%kCM$N07$$$K$OCm0U$9$Y$-E@$,$"$k!#(B
  ;; $BNc$($P!"$"$k%P%C%U%!(B Buffer A $B$G2<5-$N$h$&$J%U%)!<%`$rI>2A$7$?$H$9$k!#(B
  ;; ---------- Buffer A ---------------+--------------- Buffer B ----------
  ;; (setq test (make-marker))          |
  ;;  -> #<marker in no buffer>         |
  ;;                                    |
  ;; (make-variable-buffer-local 'test) |
  ;;                                    |
  ;; test                               | test
  ;;  -> #<marker in no buffer>         |  -> #<marker in no buffer>
  ;;                                    |
  ;; (set-marker test (point))          |
  ;;                                    |
  ;; test                               | test
  ;;  -> #<marker at 122 in A>          |  -> #<marker at 122 in A>
  ;;
  ;; $B%P%C%U%!%m!<%+%kCM$H$7$F$N@k8@$r$9$kA0$K(B non-nil $BCM$rBeF~$7!"$=$N(B non-nil
  ;; $BCM$rD>@\=q$-JQ$($k$h$&$J%U%)!<%`$rI>2A$9$k$H(B Buffer B $B$+$i8+$($k%G%#%U%)%k(B
  ;; $B%HCM$^$G=q$-JQ$C$F$7$^$&!#>e5-$NNc$O%^!<%+!<$@$,!"2<5-$N$h$&$K%j%9%H$KBP$7(B
  ;; $B$FGK2uE*4X?t$GA`:n$7$?$H$-$bF1MM$N7k2L$H$J$k!#(B
  ;; ---------- Buffer A ---------------+--------------- Buffer B ----------
  ;; (setq test '(A B C))               |
  ;;  -> (A B C)                        |
  ;;                                    |
  ;; (make-variable-buffer-local 'test) |
  ;;                                    |
  ;; test                               | test
  ;;  -> (A B C)                        |  -> (A B C)
  ;;                                    |
  ;; (setcar test 'X)                   |
  ;;                                    |
  ;; test                               | test
  ;;  -> (X B C)                        |  -> (X B C)
  ;;
  ;; $B$3$N8=>]$G0lHV:$$k$N$O!"4A;zEPO?$J$I$G%_%K%P%C%U%!$KF~$C$?$H$-(B
  ;; (skk-henkan-show-candidate $B$N$h$&$KC1$K!V%(%3!<%(%j%"!W$r;HMQ$9$k4X?t$G$O(B
  ;; $B4X78$J$$(B) $B$K!"$b$H$N%P%C%U%!$H%_%K%P%C%U%!$H$G$O$=$l$>$lJL$NJQ49$r9T$J$&(B
  ;; $B$N$,IaDL$G$"$k$N$G!">e5-$N$h$&$KB>$N%P%C%U%!$N%P%C%U%!%m!<%+%kCM$^$G=q$-(B
  ;; $BJQ$($F$7$^$&$H!"JQ49$r5Y;_$7$F$$$kB>$N%P%C%U%!$G@5>o$JJQ49$,$G$-$J$/$J$k(B
  ;; $B>l9g$,$"$k$3$H$G$"$k!#(B
  ;;
  ;; $B$7$+$b(B SKK $B$G$O%j%+!<%7%V%_%K%P%C%U%!$,;HMQ$G$-$k$N$G!"(B *Minibuf-0* $B$H(B
  ;;  *Minibuf-1 $B$N4V(B ($B$"$k$$$O$b$C$H?<$$%j%+!<%7%V%_%K%P%C%U%!F1;N$N4V(B) $B$G%P%C(B
  ;; $B%U%!%m!<%+%kCM$NGK2uE*=q$-JQ$($,9T$J$o$l$F$7$^$$!">e0L$N%_%K%P%C%U%!$KLa$C(B
  ;; $B$?$H$-$K@5>o$JJQ49$,$G$-$J$/$J$k>l9g$,$"$k!#(B
  ;;
  ;; $B$H$3$m$,2<5-$N$h$&$K=i4|CM$r(B nil $B$K$7$F!"%P%C%U%!%m!<%+%kCM$H$7$F$N@k8@8e!"(B
  ;; non-nil $BCM$rBeF~$9$l$P!"0J8e$=$N%P%C%U%!%m!<%+%kCM$KGK2uE*A`:n$r$7$F$b$=$N(B
  ;; $B%P%C%U%!$K8GM-$NCM$7$+JQ2=$7$J$$!#(B
  ;; ---------- Buffer A ---------------+--------------- Buffer B ----------
  ;; (setq test nil)                    |
  ;;                                    |
  ;; (make-variable-buffer-local 'test) |
  ;;                                    |
  ;; test                               | test
  ;;  -> nil                            |  -> nil
  ;;                                    |
  ;; (setq test (make-marker))          |
  ;;  -> #<marker in no buffer>         |
  ;;                                    |
  ;; (set-marker test (point))          |
  ;;                                    |
  ;; test                               | test
  ;;  -> #<marker at 122 in A>          |  -> nil
  ;;
  ;; skk.el 9.3 $B$N;~E@$G$O!"(Bskk-henkan-start-point, skk-henkan-end-point,
  ;; skk-kana-start-point $B5Z$S(B skk-okurigana-start-point $B$N=i4|CM(B
  ;; (make-variable-buffer-local $B$,%3!<%k$5$l$kA0$NCM(B) $B$,(B make-marker $B$NJV$jCM(B
  ;; $B$G$"$k(B #<marker in no buffer> $B$G$"$C$?$N$G!"%j%+!<%7%V%_%K%P%C%U%!$KF~$C(B
  ;; $B$FJQ49$7$?$H$-$K(B "$B"'(B" $B$,>C$($J$$!"$J$I$N%H%i%V%k$,$"$C$?$,!"$3$l$i$N=i4|(B
  ;; $BCM$r(B nil $B$K$7$F;HMQ;~$K(B make-marker $B$NJV$jCM$rBeF~$9$k$h$&$K$7!"$3$NLdBj$r(B
  ;; $B2r7h$7$?!#(B
  (list 'progn
        (list 'if (list 'not marker)
              (list 'setq marker (list 'make-marker)) )
        (list 'set-marker marker position buffer) ))

;; From viper-util.el.  Welcome!
(defmacro skk-deflocalvar (var default-value &optional documentation)
  (` (progn
       (defvar (, var) (, default-value)
	       (, (format "%s\n\(buffer local\)" documentation)))
       (make-variable-buffer-local '(, var))
     )))

;; From emu.el of tm package.   Welcome!  Its original is defun-maybe.
(defmacro skk-defunsoft (name &rest everything-else)
  (or (fboundp name)
      (` (or (fboundp (quote (, name)))
             (defun (, name) (,@ everything-else)) ))))

(put 'skk-deflocalvar 'lisp-indent-function 'defun)
(put 'skk-defunsoft 'lisp-indent-function 'defun)

(defmacro skk-make-local-hook (hook)
  (if (fboundp 'make-local-hook)
      (list 'make-local-hook hook) ))

(defmacro skk-add-local-hook (hook function &optional append)
  (if (fboundp 'make-local-hook)
      (list 'add-hook hook function append t)
    (list 'add-hook hook function append) ))

(defmacro skk-remove-local-hook (hook function)
  (if (fboundp 'make-local-hook)
      (list 'remove-hook hook function t)
    (list 'remove-hook hook function)))

;;(defun skk-get (symbol property-name &optional default)
;;  ;; SYMBOL $B$NB0@-%j%9%H$K(B PROPERTY-NAME $B$H$$$&B0@-L>$,$"$l$P$=$NB0@-CM$rJV$9!#(B
;;  ;; $B$J$1$l$P(B DEFAULT $B$rJV$9(B (DEFAULT $B$,;XDj$5$l$F$$$J$1$l$P(B NIL)$B!#B0@-L>$NHf(B
;;  ;; $B3S$O!"(Beq $B$G9T$J$&!#(B
;;  (if default
;;      (let ((pl (memq property-name (symbol-plist symbol))))
;;        (if pl (nth 1 pl) default) )
;;    (get symbol property-name) ))

(defun skk-terminal-face-p ()
  (and (not window-system)
       (fboundp 'frame-face-alist) ;; $BJQ?tL>$_$?$$$J4X?t$@$J(B...$B!#(B
       (fboundp 'selected-frame) ))

;;; skk-defunsofts  Define nothing if it is already there.

;; eval-after-load is not defined in XEmacs but after-load-alist is usable.
;; See subr.el in XEmacs.
(skk-defunsoft eval-after-load (file form)
  (or (assoc file after-load-alist)
      (setq after-load-alist (cons (list file) after-load-alist)))
  (let ((elt (assoc file after-load-alist)))
    (or (member form (cdr elt))
        (nconc elt (list form))))
  form )

(skk-defunsoft set-cursor-color (color-name)
  (set-frame-property (selected-frame) 'cursor-color
                      (if (color-instance-p color-name)
                          color-name
                        (make-color-instance color-name))))

(skk-defunsoft rassoc (key alist)
  (cond ((null alist) nil)
        ((and (consp (car alist))
              (equal key (cdr (car alist))) (car alist)))
        (t (rassoc key (cdr alist))) ))

(skk-defunsoft add-to-list (list-var element)
  (or (member element (symbol-value list-var))
      (set list-var (cons element (symbol-value list-var))) ))

;; mule-3 $B$G$O!"(Bcancel-undo-boundary $B$,$J$$!#(B    
;; from mule-util.el
(skk-defunsoft cancel-undo-boundary ()
  ;; buffer-undo-list $B$N(B car $B$N(B nil $B$r>C$7!"(Bundo $B%3%^%s%I$,D>6a$N%P%C%U%!(B
  ;; $B$NJQ99$G;_$^$i$J$$$h$&$K$9$k!#(Bbuffer-undo-list $B$K$*$1$k(B nil $B$O!"JQ(B
  ;; $B9972$HJQ9972$N6-3&$r<($9%G%j%_%?$NF/$-$r$7$F$$$k!#(B
  (if (and (consp buffer-undo-list)
           ;; car $B$,(B nil $B$@$C$?$i$=$l$r>C$9!#(B
           (null (car buffer-undo-list)) )
      (setq buffer-undo-list (cdr buffer-undo-list)) ))

(skk-defunsoft match-string (n str)
  (substring str (match-beginning n) (match-end n)) )

(defsubst skk-lower-case-p (char)
  ;; char $B$,>.J8;z$N%"%k%U%!%Y%C%H$G$"$l$P!"(Bt $B$rJV$9!#(B
  (and (<= ?a char) (>= ?z char) ))

;;;; inline functions
(defsubst skk-downcase (char)
  (or (cdr (assq char skk-downcase-alist)) (downcase char)) )

(defsubst skk-mode-off ()
  (setq skk-mode nil
        skk-abbrev-mode nil
        skk-ascii-mode nil
        skk-j-mode nil
        skk-zenkaku-mode nil
        ;; j's sub mode.
        skk-katakana nil )
  ;; initialize
  (setq skk-input-mode-string skk-hirakana-mode-string)
  ;; XXX markers should be clear out.
  (setq skk-last-henkan-results nil)
  (skk-set-cursor-color skk-default-cursor-color)
  (force-mode-line-update)
  (skk-remove-local-hook 'pre-command-hook 'skk-pre-command) )

;;;###skk-autoload
(defsubst skk-j-mode-on (&optional katakana)
  (setq skk-mode t
        skk-abbrev-mode nil
        skk-ascii-mode nil
        skk-j-mode t
        skk-zenkaku-mode nil
        ;; j's sub mode.
        skk-katakana katakana )
  ;; mode line
  (if katakana
      (progn
        (setq skk-input-mode-string skk-katakana-mode-string)
        (skk-set-cursor-color skk-katakana-cursor-color) ) 
    (setq skk-input-mode-string skk-hirakana-mode-string)
    (skk-set-cursor-color skk-hirakana-cursor-color) )
  (force-mode-line-update) )
        
;;;###skk-autoload
(defsubst skk-ascii-mode-on ()
  (setq skk-mode t
        skk-abbrev-mode nil
        skk-ascii-mode t
        skk-j-mode nil
        skk-zenkaku-mode nil
        ;; j's sub mode.
        skk-katakana nil
        skk-input-mode-string skk-ascii-mode-string )
  (skk-set-cursor-color skk-ascii-cursor-color)
  (force-mode-line-update) )

;;;###skk-autoload
(defsubst skk-zenkaku-mode-on ()
  (setq skk-mode t
        skk-abbrev-mode nil
        skk-ascii-mode nil
        skk-j-mode nil
        skk-zenkaku-mode t
        ;; j's sub mode.
        skk-katakana nil
        skk-input-mode-string skk-zenkaku-mode-string )
  (skk-set-cursor-color skk-zenkaku-cursor-color)
  (force-mode-line-update) )

;;;###skk-autoload
(defsubst skk-abbrev-mode-on ()
  (setq skk-mode t
        skk-abbrev-mode t
        skk-ascii-mode nil
        skk-j-mode nil
        skk-zenkaku-mode nil
        ;; j's sub mode.
        skk-katakana nil
        skk-input-mode-string skk-abbrev-mode-string )
  (skk-set-cursor-color skk-abbrev-cursor-color)
  (force-mode-line-update) )

;;;###skk-autoload
(defsubst skk-in-minibuffer-p ()
  ;; $B%+%l%s%H%P%C%U%!$,%_%K%P%C%U%!$+$I$&$+$r%A%'%C%/$9$k!#(B
  (window-minibuffer-p (selected-window)) )

;;;###skk-autoload
(defsubst skk-insert-prefix (&optional char)
  ;; skk-echo $B$,(B non-nil $B$G$"$l$P%+%l%s%H%P%C%U%!$K(B skk-prefix $B$rA^F~$9$k!#(B
  (and skk-echo
       ;; skk-prefix $B$NA^F~$r%"%s%I%%$NBP>]$H$7$J$$!#A^F~$7$?%W%l%U%#%C%/%9$O!"(B
       ;; $B$+$JJ8;z$rA^F~$9$kA0$KA4$F>C5n$9$k$N$G!"$=$N4V!"(Bbuffer-undo-list $B$r(B
       ;; t $B$K$7$F%"%s%I%%>pJs$rC_$($J$/$H$bLdBj$,$J$$!#(B
       (let ((buffer-undo-list t))
         (skk-insert-and-inherit (or char skk-prefix)) )))

;;;###skk-autoload
(defsubst skk-erase-prefix (&optional clean)
  ;; skk-echo $B$,(B non-nil $B$G$"$l$P%+%l%s%H%P%C%U%!$KA^F~$5$l$?(B skk-prefix $B$r>C(B
  ;; $B$9!#(B
  (if (and skk-echo skk-kana-start-point)
      (let ((start (marker-position skk-kana-start-point)))
	(if start
	    ;; skk-prefix $B$N>C5n$r%"%s%I%%$NBP>]$H$7$J$$!#(B
	    (let ((buffer-undo-list t))
	      (delete-region start (+ start (length skk-prefix)) )))))
  (if clean
      (progn
	(setq skk-prefix ""
	      skk-current-rule-tree nil ) ;; fail safe
	)))

(defsubst skk-string<= (str1 str2)
  ;; str1 $B$,(B str2 $B$HHf3S$7$F!"(Bstring< $B$+(B string= $B$G$"$l$P!"(Bt $B$rJV$9!#(B
  (or (string< str1 str2) (string= str1 str2)) )

(defsubst skk-do-auto-fill ()
  ;; auto-fill-function $B$KCM$,BeF~$5$l$F$*$l$P!"(Bdo-auto-fill $B$r%3!<%k$9$k!#(B
  (and auto-fill-function (funcall auto-fill-function)) )

;;;; from dabbrev.el.  Welcome!
;; $BH=Dj4V0c$$$rHH$9>l9g$"$j!#MW2~NI!#(B
(defsubst skk-minibuffer-origin ()
  (nth 1 (buffer-list)) )

(defsubst skk-current-insert-mode ()
  (cond (skk-abbrev-mode 'abbrev)
	(skk-ascii-mode 'ascii)
	(skk-zenkaku-mode 'zenkaku)
	(skk-katakana 'katakana)
	(skk-j-mode 'hirakana) ))

;;;###skk-autoload
(defsubst skk-numeric-p ()
  (and skk-use-numeric-conversion (require 'skk-num)
       skk-num-list ))

(defsubst skk-substring-head-character (string)
  (char-to-string (string-to-char string)) )

(defsubst skk-get-simply-current-candidate (&optional noconv)
  (if (> skk-henkan-count -1)
      ;; (nth -1 '(A B C)) $B$O!"(BA $B$rJV$9$N$G!"Ii$G$J$$$+$I$&$+%A%'%C%/$9$k!#(B
      (let ((word (nth skk-henkan-count skk-henkan-list)))
        (and word
             (if (and (skk-numeric-p) (consp word))
                 (if noconv (car word) (cdr word))
               word )))))

;; convert skk-rom-kana-rule-list to skk-rule-tree.
;; The rule tree follows the following syntax:
;; <branch-list>    ::= nil | (<tree> . <branch-list>)
;; <tree>         ::= (<char> <prefix> <nextstate> <kana> <branch-list>)
;; <kana>         ::= (<$B$R$i$,$JJ8;zNs(B> . <$B%+%?%+%JJ8;zNs(B>) | nil
;; <char>         ::= <$B1Q>.J8;z(B>
;; <nextstate>    ::= <$B1Q>.J8;zJ8;zNs(B> | nil

;; $B%D%j!<$K%"%/%;%9$9$k$?$a$N%$%s%?!<%U%'!<%9(B

(defsubst skk-make-rule-tree (char prefix nextstate kana branch-list)
  (list char
	prefix
	(if (string= nextstate "") nil nextstate)
	kana
	branch-list ))

(defsubst skk-get-char (tree)
  (nth 0 tree))

(defsubst skk-set-char (tree char)
  (setcar tree char))

(defsubst skk-set-prefix (tree prefix)
  (setcar (nthcdr 1 tree) prefix))

(defsubst skk-get-prefix (tree)
  (nth 1 tree))

(defsubst skk-get-nextstate (tree)
  (nth 2 tree))

(defsubst skk-set-nextstate (tree nextstate)
  (if (string= nextstate "") (setq nextstate nil))
  (setcar (nthcdr 2 tree) nextstate) )

(defsubst skk-get-kana (tree)
  (nth 3 tree))

(defsubst skk-set-kana (tree kana)
  (setcar (nthcdr 3 tree) kana))

(defsubst skk-get-branch-list (tree)
  (nth 4 tree))

(defsubst skk-set-branch-list (tree branch-list)
  (setcar (nthcdr 4 tree) branch-list))

;; tree procedure for skk-kana-input.
(defsubst skk-add-branch (tree branch)
  (skk-set-branch-list tree (cons branch (skk-get-branch-list tree))))

(defsubst skk-select-branch (tree char)
  (assq char (skk-get-branch-list tree)))

(defsubst skk-kana-cleanup (&optional force)
  (let ((data (or
	       (and skk-current-rule-tree
		    (null (skk-get-nextstate skk-current-rule-tree))
		    (skk-get-kana skk-current-rule-tree) )
	       (and skk-kana-input-search-function
		    (car (funcall skk-kana-input-search-function)) )))
	kana )
	(if (or force data)
	    (progn
	      (skk-erase-prefix 'clean)
	      (setq kana (if (functionp data) (funcall data nil) data))
	      (if (consp kana)
		  (setq kana (if skk-katakana (car kana) (cdr kana))) )
	      (if (stringp kana) (skk-insert-str kana))
	      (setq skk-current-rule-tree nil )
	      (skk-set-marker skk-kana-start-point nil)
	      t ))))

(defsubst skk-pre-command ()
  (and (memq last-command '(skk-insert skk-previous-candidate))
       (null
	(memq this-command
	      '(skk-insert skk-previous-candidate skk-delete-backward-char) ))
       (skk-kana-cleanup t) ))

(defsubst skk-make-raw-arg (arg)
  (cond ((= arg 1) nil)
	((= arg -1) -)
	((numberp arg) (list arg)) ))

;;;; aliases
(defalias 'skk-backward-char 'backward-char)
(defalias 'skk-eventp 'eventp)
(defalias 'skk-forward-char 'forward-char)
(defalias 'skk-insert-and-inherit 'insert-and-inherit)
(defalias 'skk-skip-chars-backward 'skip-chars-backward)
(defalias 'skk-string-to-char-list
  (cond
   ((fboundp 'string-to-char-list) 'string-to-char-list)
   ((fboundp 'string-to-list) 'string-to-list)
   (t
    (error "Cannot find skk-string-to-char-list"))))

;;;; version specific matter.
(eval-and-compile
  (defconst skk-xemacs (and (featurep 'mule)
			    (string-match "XEmacs" emacs-version) )
    "Non-nil $B$G$"$l$P!"(BXEmacs $B$G(B SKK $B$r;HMQ$7$F$$$k$3$H$r<($9!#(B" )
  
  (defconst skk-mule4 (and (featurep 'mule) (boundp 'mule-version)
			   (string< "4.0" mule-version))
    "Non-nil $B$G$"$l$P!"(BMule 4 $B$G(B SKK $B$r;HMQ$7$F$$$k$3$H$r<($9!#(B" )

  (defconst skk-mule3 (and (featurep 'mule) (boundp 'mule-version)
                           (string< "3.0" mule-version))
    "Non-nil $B$G$"$l$P!"(BMule 3 $B$G(B SKK $B$r;HMQ$7$F$$$k$3$H$r<($9!#(B" )
  
  (defconst skk-mule (featurep 'mule)
    "Non-nil $B$G$"$l$P!"(BMule $B$G(B SKK $B$r;HMQ$7$F$$$k$3$H$r<($9!#(B" )

  (defconst skk-e20 (and (not skk-xemacs)
			 (string< "20" emacs-version) )
    "Non-nil $B$G$"$l$P!"(BEmacs $B$N(B ver. 20 $B$G(B SKK $B$r;HMQ$7$F$$$k$3$H$r<($9!#(B" )

  ;; Emacs ver. $B$K$h$kJ,N`(B
  (cond ((or (and (boundp 'epoch::version) epoch::version)
             (string< (substring emacs-version 0 2) "18") )
         (message "THIS SKK requires Emacs 19")
         (sit-for 2) )
	(skk-xemacs
         (defalias 'skk-buffer-substring 'buffer-substring-no-properties)
         (defalias 'skk-character-to-event 'character-to-event)
         (defalias 'skk-event-to-character 'event-to-character)
	 (defalias 'skk-char-to-string 'char-to-string)
	 (defalias 'skk-int-char 'int-char)
	 (defalias 'skk-characterp 'characterp)
	 (defalias 'skk-read-event 'next-command-event)
         (defsubst skk-unread-event (event)
           ;; Unread single EVENT.
           (setq unread-command-events
 		 (nconc unread-command-events (list event))) )
         (defalias 'skk-make-overlay 'make-extent)
         (defalias 'skk-move-overlay 'set-extent-endpoints)
         (defalias 'skk-overlay-put 'set-extent-property)
         (defalias 'skk-overlayp 'extentp)
         (defalias 'skk-delete-overlay 'detach-extent)
	 (defmacro combine-after-change-calls (&rest body)
	   (` (unwind-protect
		  (let ((combine-after-change-calls t))
		    . (, body))
		(combine-after-change-execute))))
	 (defmacro combine-after-change-execute (&rest body)
	   body )
	 )
	(t
	 (if (string< "19.29" emacs-version)
	     (defalias 'skk-buffer-substring 'buffer-substring-no-properties)
	   (defalias 'skk-buffer-substring 'buffer-substring) )
         (defmacro skk-character-to-event (char) char);; $B2?$b$7$J$$(B
         (defun skk-event-to-character (event)
           ;; Return character of keystroke EVENT.
           (cond ((symbolp event)
                  ;; mask is (BASE-TYPE MODIFIER-BITS) or nil.
                  (let ((mask (get event 'event-symbol-element-mask)))
                    (if mask
                        (let ((base (get (car mask) 'ascii-character)))
                          (if base
                              (logior base (car (cdr mask))))))))
                 ((integerp event)
                  event)
                 (t nil) ))
	 (if skk-e20
	     (defun skk-char-to-string (char)
	       (condition-case nil
		   (char-to-string char)
		 (error
		  nil )))
	   (defalias 'skk-char-to-string 'char-to-string) )
         (defmacro skk-int-char (char) char);; $B2?$b$7$J$$(B
	 (defalias 'skk-characterp 'integerp)
         (defalias 'skk-read-event 'read-event)
         (defsubst skk-unread-event (event)
           ;; Unread single EVENT.
           (setq unread-command-events
 		 (nconc unread-command-events (list event))))
         (defalias 'skk-make-overlay 'make-overlay)
         (defalias 'skk-move-overlay 'move-overlay)
         (defalias 'skk-overlay-put 'overlay-put)
         (defalias 'skk-overlayp 'overlayp)
         (defalias 'skk-delete-overlay 'delete-overlay)
         ;; overwrite built-in combine-after-change-execute
	 (defmacro combine-after-change-execute (&rest body)
	   body )
	 (defmacro combine-after-change-calls (&rest body)
	   (` (unwind-protect
		  (let ((combine-after-change-calls t))
		    . (, body))
		(combine-after-change-execute))))
	 (if skk-e20
	     nil
	   (defmacro save-current-buffer (&rest body)
	     (let ((orig-buffer (make-symbol "orig-buffer")))
	       (` (let (((, orig-buffer) (current-buffer)))
		    (unwind-protect
			(progn (,@ body))
		      (set-buffer (, orig-buffer)) )))))
	  
	   (defmacro with-current-buffer (buffer &rest body)
	     "Execute the forms in BODY with BUFFER as the current buffer.
	      The value returned is the value of the last form in BODY.
	      See also `with-temp-buffer'."
	     (` (save-current-buffer
		  (set-buffer (, buffer))
		  (,@ body))))
	  
	   (defmacro with-temp-file (file &rest forms)
	     "Create a new buffer, evaluate FORMS there, and write the buffer to FILE.
	      The value of the last form in FORMS is returned, like `progn'.
	      See also `with-temp-buffer'."
	     (let ((temp-file (make-symbol "temp-file"))
		   (temp-buffer (make-symbol "temp-buffer")))
	       (` (let (((, temp-file) (, file))
			((, temp-buffer)
			 (get-buffer-create (generate-new-buffer-name " *temp file*"))))
		    (unwind-protect
			(prog1
			    (with-current-buffer (, temp-buffer)
			      (,@ forms))
			  (with-current-buffer (, temp-buffer)
			    (widen)
			    (write-region (point-min) (point-max) (, temp-file) nil 0)))
		      (and (buffer-name (, temp-buffer))
			   (kill-buffer (, temp-buffer))))))))
	  
	   (defmacro with-temp-buffer (&rest forms)
	     "Create a temporary buffer, and evaluate FORMS there like `progn'.
	      See also `with-temp-file' and `with-output-to-string'."
	     (let ((temp-buffer (make-symbol "temp-buffer")))
	       (` (let (((, temp-buffer)
			 (get-buffer-create (generate-new-buffer-name " *temp*"))))
		    (unwind-protect
			(with-current-buffer (, temp-buffer)
			  (,@ forms))
		      (and (buffer-name (, temp-buffer))
			   (kill-buffer (, temp-buffer))))))))
	  
	   (defmacro with-output-to-string (&rest body)
	     "Execute BODY, return the text it sent to `standard-output', as a string."
	     (` (let ((standard-output
		       (get-buffer-create (generate-new-buffer-name " *string-output*"))))
		  (let ((standard-output standard-output))
		    (,@ body))
		  (with-current-buffer standard-output
		    (prog1
			(buffer-string)
		      (kill-buffer nil))))))
	   )))
	
  ;; Mule ver. $B$K$h$kJ,N`(B
  (cond (skk-xemacs
	 (defalias 'skk-substring 'substring)
	 (defalias 'skk-str-ref 'aref)
	 (defalias 'skk-str-length 'length)
	 (defalias 'skk-charsetp 'find-charset)
	 (defalias 'skk-char-octet 'char-octet)
	 (defun skk-make-char (charset n1 n2)
	   (make-char charset
		      (logand (lognot 128) n1)
		      (logand (lognot 128) n2) ))
	 (defsubst skk-alpha-char-p (char)
	   ;; char $B$,(B ascii $BJ8;z$@$C$?$i(B t $B$rJV$9!#(B
	   (eq (char-charset char) 'ascii) )
	 (defsubst skk-jisx0208-p (char)
	   (eq (char-charset char) 'japanese-jisx0208) )
	 (defun skk-jisx0208-to-ascii (string)
	   (let ((char
		  (progn
		    (require 'japan-util)
		    (get-char-code-property (string-to-char string) 'ascii) )))
	     (if char (char-to-string char)) ))
	 )
	(skk-mule4
	 (defalias 'skk-substring 'substring)
	 (defalias 'skk-str-ref 'aref)
	 (defalias 'skk-str-length 'length)
	 (defalias 'skk-charsetp 'charsetp)
	 (defun skk-char-octet (char pos)
	   (let* ((c (split-char char))
		  (ret (nth (1+ pos) c)) )
	     (if ret
		 ret
	       0 )))
	 (defalias 'skk-make-char 'make-char)
	 (defsubst skk-alpha-char-p (char)
	   ;; char $B$,(B ascii $BJ8;z$@$C$?$i(B t $B$rJV$9!#(B
	   (eq (char-charset char) 'ascii) )
	 (defsubst skk-jisx0208-p (char)
	   (eq (char-charset char) 'japanese-jisx0208) )
	 (defun skk-jisx0208-to-ascii (string)
	   (let ((char
		  (progn
		    (require 'japan-util)
		    (get-char-code-property (string-to-char string) 'ascii) )))
	     (if char (char-to-string char)) ))
	 )
	(skk-mule3
	 (defun skk-substring (str pos1 pos2)
	   (if (< pos1 0)
	       (setq pos1 (+ (skk-str-length str) pos1)) )
	   (if (< pos2 0)
	       (setq pos2 (+ (skk-str-length str) pos2)) )
	   (if (>= pos1 pos2)
	       ""
	     (let ((sl (nthcdr pos1 (string-to-list str))))
	       (setcdr (nthcdr (- pos2 pos1 1) sl) nil)
	       (concat sl) )))
	 (defun skk-str-ref (str pos)
	   (aref (string-to-vector str) pos ) )
	 (defun skk-str-length (str)
	   (length (string-to-vector str)) )
	 (defalias 'skk-charsetp 'charsetp)
	 (defun skk-char-octet (char pos)
	   (let* ((c (split-char char))
		  (ret (nth (1+ pos) c)) )
	     (if ret
		 ret
	       0 )))
	 (defalias 'skk-make-char 'make-char)
 	 (defsubst skk-alpha-char-p (char)
 	   ;; char $B$,(B ascii $BJ8;z$@$C$?$i(B t $B$rJV$9!#(B
 	   (eq (char-charset char) 'ascii) )
	 (defsubst skk-jisx0208-p (char)
	   (eq (char-charset char) 'japanese-jisx0208) )
	 (defun skk-jisx0208-to-ascii (string)
	   (let ((char
		  (progn
		    (require 'japan-util)
		    (get-char-code-property (string-to-char string) 'ascii) )))
	     (if char (char-to-string char)) ))
	 )
	(skk-mule
	 (defun skk-substring (str pos1 pos2)
	   (if (< pos1 0)
	       (setq pos1 (+ (skk-str-length str) pos1)) )
	   (if (< pos2 0)
	       (setq pos2 (+ (skk-str-length str) pos2)) )
	   (if (>= pos1 pos2)
	       ""
	     (let ((sl (nthcdr pos1 (string-to-list str))))
	       (setcdr (nthcdr (- pos2 pos1 1) sl) nil)
	       (concat sl) )))
	 (defun skk-str-ref (str pos)
	   (nth pos (string-to-char-list str)) )
	 (defun skk-str-length (str)
	   (length (string-to-char-list str)) )
	 (defalias 'skk-charsetp 'character-set)
	 (defun skk-char-octet (ch &optional n)
	   (if n
	       nil
	     (setq n 0) )
	   (if (= (char-leading-char ch) 0)
	       nil
	     (setq n (1+ n)) )
	   (let ((n (char-component ch n)))
	     (if (zerop n)
		 n
	       (- n 128) )))
	 (defalias 'skk-make-char 'make-character)
	 (defsubst skk-alpha-char-p (char)
	   ;; char $B$,(B ascii $BJ8;z$@$C$?$i(B t $B$rJV$9!#(B
	   (= (char-leading-char char) 0) )
	 (defsubst skk-jisx0208-p (char)
	   (= (char-leading-char char) lc-jp) )
	 (defun skk-jisx0208-to-ascii (string)
	   (let ((char
		  (let* ((ch (string-to-char string))
			 (ch1 (char-component ch 1)) )
		    (cond ((eq 161 ch1)	; ?\241
			   (cdr (assq (char-component ch 2) skk-hankaku-alist)) )
			  ((eq 163 ch1)	; ?\243
			   (- (char-component ch 2) 128) ; ?\200
			   )))))
	     (if char (char-to-string char)) ))
	 )
	(t
	 (message "SKK requires MULE")
	 (sit-for 2) ))

  )

(defconst skk-background-mode
  ;; from font-lock-make-faces of font-lock.el  Welcome!
  (cond
   (skk-xemacs
    (if (< (apply '+ (color-rgb-components
                      (face-property 'default 'background)))
           (/ (apply '+ (color-rgb-components
                         (make-color-specifier "white"))) 3))
        'dark
      'light)
    )
   ((and window-system (x-display-color-p))
    (let ((bg-resource (x-get-resource ".backgroundMode"
                                       "BackgroundMode"))
          params )
      (if bg-resource
          (intern (downcase bg-resource))
        (setq params (frame-parameters))
        (cond ((cdr (assq 'background-mode params))) ;; Emacs20.x (Meadow)
	      ;; Mule for Win32 $B$r(B Windows 95 $B$GF0$+$7$F$$$k$H$-$O!"(B
	      ;; system-type $B$O!)(B  -> windows-nt $B$G$7$?!#(B
	      ((and (eq system-type 'windows-nt) ;; Mule for Win32
                    (fboundp 'win32-color-values) )
               (< (apply '+ (win32-color-values
                             (cdr (assq 'background-color params)) ))
                  (/ (apply '+ (win32-color-values "white")) 3) )
               'dark )
              ((and (memq system-type '(ms-dos windows-nt))
                    (fboundp 'x-color-values) )
               (if (string-match "light"
                                 (cdr (assq 'background-color params)) )
                   'light
                 'dark ))
              ((< (apply '+ (x-color-values
                             (cdr (assq 'background-color params)) ))
                  (/ (apply '+ (x-color-values "white")) 3) )
               'dark )
              (t 'light) ))))
   (t 'mono )))

(eval-after-load "hilit19"
  '(mapcar (function
            (lambda (pattern)
              (hilit-add-pattern
               (car pattern) (cdr pattern)
               (cond ((eq skk-background-mode 'mono)
                      'bold )
                     ((eq skk-background-mode 'light)
                      'RoyalBlue )
                     (t 'cyan) )
               'emacs-lisp-mode )))
           '(("^\\s *(skk-deflocalvar\\s +\\S +" . "")
             ("^\\s *(skk-defunsoft\\s +\\S +" . "") )))

(eval-after-load "font-lock"
  '(mapcar (function
            (lambda (pattern)
              (add-to-list
               'lisp-font-lock-keywords-2
               (cons pattern
                     '((1 font-lock-keyword-face)
                       (2 font-lock-variable-name-face) )))))
           '("^(\\(skk-deflocalvar\\)[ \t'\(]*\\(\\sw+\\)?"
             "^(\\(skk-defunsoft\\)[ \t'\(]*\\(\\sw+\\)?" )))

(defun skk-define-menu-bar-map (map)
  ;; SKK $B%a%K%e!<$N%H%C%W$K=P8=$9$k%3%^%s%I$N%a%K%e!<$X$NDj5A$r9T$J$&!#(B
  (easy-menu-define
   skk-menu map
   "Menu used in SKK mode."
   '("SKK"
     ("Convert Region and Echo"
      ("Gyakubiki"
       ["to Hirakana" skk-gyakubiki-message
        (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
       ["to Hirakana, All Candidates"
        ;; $B$"$l$l!"(Blambda $B4X?t$ODj5A$G$-$J$$$N$+!)!)!)(B  $BF0$+$J$$$>(B...$B!#(B
        (function (lambda (start end) (interactive "r")
                    (skk-gyakubiki-message start end 'all-candidates) ))
        (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
       ["to Katakana" skk-gyakubiki-katakana-message
        (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
       ["to Katakana, All Candidates"
        (function (lambda (start end) (interactive "r")
                    (skk-gyakubiki-katakana-message
                     start end 'all-candidates ) ))
        (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
       )
      ("Hurigana"
       ["to Hirakana" skk-hurigana-message
        (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
       ["to Hirakana, All Candidates"
        (function (lambda (start end) (interactive "r")
                    (skk-hurigana-message start end 'all-candidates) ))
        (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
       ["to Katakana" skk-hurigana-katakana-message
        (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
       ["to Katakana, All Candidates"
        (function (lambda (start end) (interactive "r")
                    (skk-hurigana-katakana-message
                     start end 'all-candidates) ))
        (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
       )
      )
     ("Convert Region and Replace"
      ["Ascii" skk-ascii-region
       (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
      ("Gyakubiki"
       ["to Hirakana" skk-gyakubiki-region
        (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
       ["to Hirakana, All Candidates"
        (function (lambda (start end) (interactive "r")
                    (skk-gyakubiki-region start end 'all-candidates) ))
        (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
       ["to Katakana" skk-gyakubiki-katakana-region
        (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
       ["to Katakana, All Candidates"
        (function (lambda (start end) (interactive "r")
                    (skk-gyakubiki-katakana-region
                     start end 'all-candidates ) ))
        (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
       )
      ["Hiragana" skk-hiragana-region
       (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
      ("Hurigana"
       ["to Hirakana" skk-hurigana-region
        (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
       ["to Hirakana, All Candidates"
        (function (lambda (start end) (interactive "r")
                    (skk-hurigana-region start end 'all-candidates) ))
        (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
       ["to Katakana" skk-hurigana-katakana-region
        (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
       ["to Katakana, All Candidates" (function
                                       (lambda (start end) (interactive "r")
                                         (skk-hurigana-katakana-region
                                          start end 'all-candidates) ))
        (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
       )
      ["Katakana" skk-katakana-region
       (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
      ["Romaji" skk-romaji-region
       (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
      ["Zenkaku" skk-zenkaku-region
       (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
      )
     ["Count Jisyo Candidates" skk-count-jisyo-candidates
      (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
     ["Save Jisyo" skk-save-jisyo
      (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
     ["Undo Kakutei" skk-undo-kakutei
      (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
     ("User Options"
      ["skk-allow-spaces-newlines-and-tabs" skk-menu-allow-spaces-newlines-and-tabs
       (or (not (boundp 'skktut-problem-count))
           (eq skktut-problem-count 0) ) ]
      ["skk-auto-start-henkan" skk-menu-auto-henkan
       (or (not (boundp 'skktut-problem-count))
           (eq skktut-problem-count 0) ) ]
      ["skk-auto-insert-paren" skk-menu-auto-insert-paren
       (or (not (boundp 'skktut-problem-count))
           (eq skktut-problem-count 0) ) ]
      ["skk-auto-okuri-process"
       (function (lambda ()
                   (interactive)
                   (skk-menu-auto-okuri-process)
                   (skk-adjust-search-prog-list-for-auto-okuri) ))
       (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0))]
      ["skk-compare-jisyo-size-when-saving" skk-menu-compare-jisyo-size-when-saving
       (or (not (boundp 'skktut-problem-count))
           (eq skktut-problem-count 0) ) ]
      ["skk-convert-okurigana-into-katakana" skk-menu-convert-okurigana-into-katakana
       (or (not (boundp 'skktut-problem-count))
           (eq skktut-problem-count 0) ) ]
      ["skk-count-private-jisyo-candidates-exactly"
       skk-menu-count-private-jisyo-entries-exactly
       (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
      ["skk-dabbrev-like-completion" skk-menu-dabbrev-like-completion
       (or (not (boundp 'skktut-problem-count))
           (eq skktut-problem-count 0) ) ]
      ["skk-date-ad" skk-menu-date-ad
       (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
      ["skk-delete-implies-kakutei" skk-menu-delete-implies-kakutei
       (or (not (boundp 'skktut-problem-count))
           (eq skktut-problem-count 0) ) ]
      ["skk-delete-okuri-when-quit" skk-menu-delete-okuri-when-quit
       (or (not (boundp 'skktut-problem-count))
           (eq skktut-problem-count 0) ) ]
      ["skk-echo" skk-menu-echo
       (or (not (boundp 'skktut-problem-count)) (eq skktut-problem-count 0)) ]
      ["skk-egg-like-newline" skk-menu-egg-like-newline
       (or (not (boundp 'skktut-problem-count))
           (eq skktut-problem-count 0)) ]
      ["skk-henkan-okuri-strictly" skk-menu-henkan-okuri-strictly
       (or (not (boundp 'skktut-problem-count))
           (eq skktut-problem-count 0)) ]
      ["skk-henkan-strict-okuri-precedence" skk-menu-henkan-strict-okuri-precedence
       (or (not (boundp 'skktut-problem-count))
	   (eq skktut-problem-count 0)) ]
      ["skk-japanese-message-and-error" skk-menu-japanese-message-and-error
       (or (not (boundp 'skktut-problem-count))
           (eq skktut-problem-count 0)) ]
      ["skk-kakutei-early" skk-menu-kakutei-early
       (or (not (boundp 'skktut-problem-count))
           (eq skktut-problem-count 0)) ]
      ["skk-numeric-conversion-float-num" skk-menu-numeric-conversion-float-num
       (or (not (boundp 'skktut-problem-count))
           (eq skktut-problem-count 0)) ]
      ["skk-process-okuri-early" skk-menu-process-okuri-early
       (or (not (boundp 'skktut-problem-count))
           (eq skktut-problem-count 0)) ]
      ["skk-report-server-response" skk-menu-report-server-response
       (or (not (boundp 'skktut-problem-count))
           (eq skktut-problem-count 0)) ]
      ["skk-romaji-*-by-hepburn" skk-menu-romaji-*-by-hepburn
       (or (not (boundp 'skktut-problem-count))
           (eq skktut-problem-count 0)) ]
      ["skk-uniq-numerals" skk-menu-uniq-numerals
       (or (not (boundp 'skktut-problem-count))
           (eq skktut-problem-count 0)) ]
      ["skk-use-color-cursor" skk-menu-use-color-cursor
       (or (not (boundp 'skktut-problem-count))
           (eq skktut-problem-count 0)) ]
      ["skk-use-kakasi" skk-menu-use-kakasi
       (or (not (boundp 'skktut-problem-count))
           (eq skktut-problem-count 0)) ]
      ["skk-use-numeric-conversion" skk-menu-use-numeric-conversion
       (or (not (boundp 'skktut-problem-count))
           (eq skktut-problem-count 0)) ]
      ["skk-use-face" skk-menu-use-overlay
       (or (not (boundp 'skktut-problem-count))
           (eq skktut-problem-count 0))] )
     ["Version" skk-version
      (or (not (boundp 'skktut-problem-count))
          (eq skktut-problem-count 0)) ]
     )))

(defun skk-update-autoloads (dir)
  (interactive "DUpdate skk autoloads from directory: ")
  (require 'autoload)
  (let ((generated-autoload-file "skk-vars.el"))
    (update-autoloads-from-directory dir)))

(provide 'skk-foreword)
;;; skk-forwords.el ends here
