/*
 * disalloc.c - aeb - 940501 - Disallocate virtual terminal(s)
 * Renamed deallocvt.
 */
#include <stdlib.h>
#include <fcntl.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <linux/vt.h>

#include <lct/local.h>
#include <lct/utils.h>
#include <lct/console.h>

char *progname;

/* FIXME: use it! */
void usage()
{
  fprintf(stderr, "Usage: %s [N1 N2 ...]\n", progname);
}

int main(int argc, char *argv[]) 
{
  int fd, num, i;
  int exit_status = EX_OK;
  
  if (argc < 1)		/* unlikely */
      exit(1);
  progname = strip_path(argv[0]);
  
  if (-1 == (fd = get_console_fd(NULL))) 
      exit (EX_OSERR);
  
  if (argc == 1) 
    {
      /* deallocate all unused consoles */
      if (ioctl(fd,VT_DISALLOCATE,0)) 
	{
	  perror("VT_DISALLOCATE");
	  fprintf(stderr,
		  "%s: deallocating all unused consoles failed\n",
		  progname);
	  exit(EX_OSERR);
	}
    } 
  else
      for (i = 1; i < argc; i++) {
	num = atoi(argv[i]);
	if (num == 0)
	  {
	    fprintf(stderr, "%s: 0: illegal VT number\n", progname);
	    
	    /* set unconditionnaly: worse problem */
	    exit_status = EX_DATAERR;
	  }
	else if (num == 1)
	  {
	    fprintf(stderr,
		    "%s: VT 1 is the console can cannot be deallocated\n",
		    progname);
	    
	    /* do not override DATAERR */
	    if (exit_status != EX_DATAERR)
		exit_status = EX_UNAVAILABLE;
	  }
	else if (ioctl(fd,VT_DISALLOCATE,num)) 
	  {
	    perror("VT_DISALLOCATE");
	    fprintf(stderr, "%s: could not deallocate console %d\n",
		    progname, num);
	    
	    /* do not return TEMPFAIL if something worse already occured */
	    if (!exit_status)
		exit_status = EX_TEMPFAIL;
	  }
      }

  exit(exit_status);
}
