/*
 * psfstriptable.c
 *
 * Strip Unicode character table from a PSF font
 *
 * Copyright (C) 1994 H. Peter Anvin
 *
 * This program may be freely copied under the terms of the GNU
 * General Public License (GPL), version 2, or at your option
 * any later version.
 *
 * fix, aeb, 970316
 * 1997/08, ydi: moved reusable parts into libconsole
 */

#include <stdio.h>
#include <stdlib.h>
#include <sysexits.h>
#include <string.h>

#include <lct/font.h>
#include <lct/local.h>

char* progname;

void usage()
{
  version();
  
  fprintf(stderr, 
	  "Usage:\n"
	  "       %s psffont [outfile]\n", progname);
}

int main(int argc, char *argv[])
{
  FILE *in, *out;
  char *inname;
  struct psf_header psfhdr;
  size_t fontlen;
  char buffer[65536];		/* Font data, is scratch only */

  progname = strip_path(argv[0]);
  
  if ( argc < 2 || argc > 3 )
    badusage("wrong number of args");

  /* open input file */
  if ( !strcmp(argv[1],"-") )
    {
      in = stdin;
      inname = "stdin";
    }
  else
    {
      in = fopen(inname = argv[1], "r");
      if ( !in )
        {
          perror(inname);
          exit(EX_NOINPUT);
        }
    }

  /* open output file */
  if ( argc < 3 || !strcmp(argv[2],"-") )
    out = stdout;
  else
    {
      out = fopen(argv[2], "w");
      if ( !out )
        {
          perror(argv[2]);
          exit(EX_CANTCREAT);
        }
    }

  if (-1 == psf_header_read (in, &psfhdr))
      perror("psf_header_read"), exit(EX_DATAERR);
  
  fontlen = ( PSF_MODE_HAS512(psfhdr.mode) ) ? 512 : 256;

  if ( ! (PSF_MODE_HASSFM(psfhdr.mode)) )
    {
      fprintf(stderr, "%s: Font already had no character table\n", inname);
    }

  if (PSF_MODE_HAS512(psfhdr.mode))
    psfhdr.mode = PSF_MODE512NOSFM;
  else
    psfhdr.mode = PSF_MODE256NOSFM;
  
  /* Read font data */
  if ( fread(buffer, psfhdr.charheight, fontlen, in) < fontlen )
    {
      perror(inname);
      exit(EX_DATAERR);
    }

  fclose(in);

  /* Write new font file */
  fwrite(&psfhdr, sizeof(struct psf_header), 1, out);
  fwrite(buffer, psfhdr.charheight, fontlen, out);
  fclose(out);

  exit(EX_OK);
}
