/* 
 * xwave - an interactive audio player, recorder, editor 
 * for the XWindow System
 * 
 * Copyright (C) 1996 Kai Kollmorgen
 * (kkollmor@informatik.uni-rostock.de)
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <sys/types.h>
#include <sys/time.h>
#include <dirent.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <X11/Intrinsic.h>	/* Intrinsics Definitions */
#include <X11/StringDefs.h>	/* Standard Name-String definitions */
#include <X11/Shell.h>     	/* Shell Definitions */
#include <X11/cursorfont.h>

#include <X11/Xaw/Command.h>	/* Athena Command Widget */
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Repeater.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Scrollbar.h>

#include "types.h"
#include "xwave.h"
#include "xwave_widget.h"
#include "fileop.h"
#include "edit.h"
#include "misc.h"
#include "record_dialog.h"
#include "audio.h"
#include "menu.h"
#include "graphics.h"
#include "status.h"
#include "button.h"

#include "bitmaps/stop.xbm"
#include "bitmaps/play.xbm"
#include "bitmaps/record.xbm"
#include "bitmaps/up.xbm"
#include "bitmaps/down.xbm"
#include "bitmaps/new.xbm"
#include "bitmaps/load.xbm"
#include "bitmaps/save.xbm"
#include "bitmaps/cut.xbm"
#include "bitmaps/begin.xbm"
#include "bitmaps/end.xbm"
#include "bitmaps/zoom.xbm"

char begin_text[MAX_NUMLENGTH]="0";
char length_text[MAX_NUMLENGTH]="0";
char zoom_text[MAX_NUMLENGTH]="1";
Pixmap upBitmap = None;
Pixmap downBitmap = None;
bool button_2=False;

extern Main_Data *MD;

static void try_record(Widget w, XtPointer client_data, XtPointer call_data);
static void button_2_on();
static void button_2_off();
static Boolean set_playline(XtPointer client_data);

static int pid=-1;
static Widget buttons[16];
static int last_pos;
static XtWorkProcId p_id;
static time_t start_clock;

void button_2_on()
{
    button_2=True;
}

void button_2_off()
{
    button_2=False;
}

void create_button(Widget w)
{
    Display *dpy=XtDisplay(w);
    Window win=DefaultRootWindow(dpy);
    Widget form,label;
    static XtActionsRec button_actions[]={
	  {"button_2_on",(XtActionProc) button_2_on},
	  {"button_2_off",(XtActionProc) button_2_off},
	  {"begin_enter",(XtActionProc) begin_enter},
	  {"length_enter",(XtActionProc) length_enter},
	  {"zoom_enter",(XtActionProc) zoom_enter}
    };
    static XtTranslations trans;
    static Pixmap newBitmap = None;
    static Pixmap loadBitmap = None;
    static Pixmap saveBitmap = None;
    static Pixmap cutBitmap = None;
    static Pixmap beginBitmap = None;
    static Pixmap endBitmap = None;
    static Pixmap zoomBitmap = None;
    static Pixmap stopBitmap = None;
    static Pixmap playBitmap = None;
    static Pixmap recordBitmap = None;
    int i=0;
    
    XtAppAddActions(XtWidgetToApplicationContext(w), 
		    button_actions, XtNumber(button_actions));
    
    newBitmap= XCBFD(dpy,win,(char *)new_bits,new_width,new_height);
    loadBitmap= XCBFD(dpy,win,(char *)load_bits,load_width,load_height);
    saveBitmap= XCBFD(dpy,win,(char *)save_bits,save_width,save_height);
    cutBitmap= XCBFD(dpy,win,(char *)cut_bits,cut_width,cut_height);
    beginBitmap= XCBFD(dpy,win,(char *)begin_bits,begin_width,begin_height);
    endBitmap= XCBFD(dpy,win,(char *)end_bits,end_width,end_height);
    zoomBitmap= XCBFD(dpy,win,(char *)zoom_bits,zoom_width,zoom_height);
    stopBitmap= XCBFD(dpy,win,(char *)stop_bits,stop_width,stop_height);
    playBitmap= XCBFD(dpy,win,(char *)play_bits,play_width,play_height);
    recordBitmap= XCBFD(dpy,win,(char *)record_bits,record_width,record_height);
    upBitmap= XCBFD(dpy,win,(char *)up_bits,up_width,up_height);
    downBitmap= XCBFD(dpy,win,(char *)down_bits,down_width,down_height);
    
    buttons[i]= MW ("bb_new_btn",commandWidgetClass,w,
		    XtNtop,XawChainTop,XtNbottom,XawChainTop,
		    XtNbitmap, newBitmap,
		    XtNleft,XawChainLeft,XtNright,XawChainLeft,
		    NULL);
    
    XtAddCallback (buttons[i], XtNcallback, new_call, (XtPointer) MD);
    
    i++;
    buttons[i]= MW ("bb_load_btn",commandWidgetClass,w,
		    XtNfromHoriz,buttons[i-1],
		    XtNtop,XawChainTop,XtNbottom,XawChainTop,
		    XtNbitmap, loadBitmap,
		    XtNleft,XawChainLeft,XtNright,XawChainLeft,
		    NULL);
    
    XtAddCallback (buttons[i], XtNcallback, load_call, (XtPointer) MD);
    
    i++;
    buttons[i]= MW ("bb_save_btn",commandWidgetClass,w,
		    XtNfromHoriz,buttons[i-1],
		    XtNtop,XawChainTop,XtNbottom,XawChainTop,
		    XtNbitmap, saveBitmap,
		    XtNsensitive, False,
		    XtNleft,XawChainLeft,XtNright,XawChainLeft,
		    NULL);
    
    XtAddCallback (buttons[i], XtNcallback, save_call, (XtPointer) MD);
    
    i++;
    buttons[i]= MW ("bb_cut_btn",commandWidgetClass,w,
		    XtNfromHoriz,buttons[i-1],
		    XtNtop,XawChainTop,XtNbottom,XawChainTop,
		    XtNbitmap, cutBitmap,
		    XtNsensitive, False,
		    XtNleft,XawChainLeft,XtNright,XawChainLeft,
		    NULL);
    
    XtAddCallback (buttons[i], XtNcallback, cut_call, (XtPointer) MD);
    
    i++;
    buttons[i]= MW ("bb_stop_btn",commandWidgetClass,w,
		    XtNfromHoriz,buttons[i-1],
		    XtNtop,XawChainTop,XtNbottom,XawChainTop,
		    XtNbitmap, stopBitmap,
		    XtNsensitive, False,
		    XtNleft,XawChainLeft,XtNright,XawChainLeft,
		    NULL);
    
    XtAddCallback (buttons[i], XtNcallback, stop_it, (XtPointer) MD);
    
    i++;
    buttons[i]= MW ("bb_play_btn",commandWidgetClass,w,
		    XtNfromHoriz,buttons[i-1],
		    XtNtop,XawChainTop,XtNbottom,XawChainTop,
		    XtNbitmap, playBitmap,
		    XtNsensitive, False,
		    XtNleft,XawChainLeft,XtNright,XawChainLeft,
		    NULL);
    
    XtAddCallback (buttons[i], XtNcallback, play_it, (XtPointer) MD);
    
    i++;
    buttons[i]= MW ("bb_record_btn",commandWidgetClass,w,
		    XtNfromHoriz,buttons[i-1],
		    XtNtop,XawChainTop,XtNbottom,XawChainTop,
		    XtNbitmap, recordBitmap,
		    XtNsensitive, MD->mb->canplay,
		    XtNleft,XawChainLeft,XtNright,XawChainLeft,
		    NULL);
    
    XtAddCallback (buttons[i], XtNcallback, try_record, (XtPointer) MD);
    
    label = MW ("bb_begin_label",labelWidgetClass,w,
		XtNfromHoriz,buttons[i],
		XtNborderWidth,0,
		XtNbitmap,beginBitmap,
		XtNbottom, XtChainTop,XtNtop, XtChainTop,
		XtNleft,XawChainLeft,XtNright,XawChainLeft,		
		NULL);
    
    i++;
    buttons[i] = MW ("bb_begin_text",asciiTextWidgetClass,w,
		     XtNfromHoriz,label,
		     XtNsensitive, False,
		     XtNeditType, XawtextEdit,
		     XtNwrap, XawtextWrapNever,
		     XtNresize, XawtextResizeWidth,
		     XtNuseStringInPlace, True,
		     XtNlength,MAX_NUMLENGTH,XtNstring,&begin_text,
		     XtNbottom, XtChainTop,XtNtop, XtChainTop,
		     XtNleft,XawChainLeft,XtNright,XawChainLeft,
		     NULL);
    
    trans=XtParseTranslationTable("#override\n\
<Btn2Down>: set() button_2_on() start()\n\
<Btn2Up>: stop() button_2_off() unset()\n");
    
    form= MW ("bb_begin_form",formWidgetClass,w,
	      XtNfromHoriz,buttons[i],
	      XtNhorizDistance,0,
	      XtNborderWidth, 0,
	      XtNtop,XawChainTop,XtNbottom,XawChainTop,
	      XtNleft,XawChainLeft,XtNright,XawChainLeft,
	      NULL);
    
    i++;
    buttons[i]= MW ("bb_begin_up_rep",repeaterWidgetClass,form,
		    XtNvertDistance,0,
		    XtNtranslations, trans,
		    XtNtop,XawChainTop,XtNbottom,XawChainTop,
		    XtNleft,XawChainLeft,XtNright,XawChainLeft,
		    XtNbitmap, upBitmap,
		    XtNsensitive, False,
		    NULL);
    
    XtAddCallback (buttons[i], XtNcallback, begin_up,(XtPointer) MD);
    
    i++;
    buttons[i]= MW ("bb_begin_down_rep",repeaterWidgetClass,form,
		    XtNfromVert,buttons[i-1],
		    XtNvertDistance,0,
		    XtNtranslations, trans,
		    XtNtop,XawChainBottom,XtNbottom,XawChainBottom,
		    XtNleft,XawChainLeft,XtNright,XawChainLeft,
		    XtNbitmap, downBitmap,
		    XtNsensitive, False,
		    NULL);
    
    XtAddCallback (buttons[i], XtNcallback, begin_down,(XtPointer) MD);
    
    label = MW ("bb_length_label",labelWidgetClass,w,
		XtNfromHoriz,form,
		XtNborderWidth,0,
		XtNbitmap,endBitmap,
		XtNbottom, XtChainTop,XtNtop, XtChainTop,
		XtNleft,XawChainLeft,XtNright,XawChainLeft,		
		NULL);
    
    i++;
    buttons[i] = MW ("bb_length_text",asciiTextWidgetClass,w,
		     XtNfromHoriz,label,
		     XtNsensitive, False,
		     XtNeditType, XawtextEdit,
		     XtNwrap, XawtextWrapNever,
		     XtNresize, XawtextResizeWidth,
		     XtNuseStringInPlace, True,
		     XtNlength,MAX_NUMLENGTH,XtNstring,&length_text,
		     XtNbottom, XtChainTop,XtNtop, XtChainTop,
		     XtNleft,XawChainLeft,XtNright,XawChainLeft,
		     NULL);
    
    form= MW ("bb_length_form",formWidgetClass,w,
	      XtNfromHoriz,buttons[i],
	      XtNhorizDistance,0,
	      XtNborderWidth, 0,
	      XtNtop,XawChainTop,XtNbottom,XawChainTop,
	      XtNleft,XawChainLeft,XtNright,XawChainLeft,
	      NULL);
    
    i++;
    buttons[i]= MW ("bb_length_up_rep",repeaterWidgetClass,form,
		    XtNvertDistance,0,
		    XtNtranslations, trans,
		    XtNtop,XawChainTop,XtNbottom,XawChainTop,
		    XtNleft,XawChainLeft,XtNright,XawChainLeft,
		    XtNbitmap, upBitmap,
		    XtNsensitive, False,
		    NULL);
    
    XtAddCallback (buttons[i], XtNcallback, length_up,(XtPointer) MD);
    
    i++;
    buttons[i]= MW ("bb_length_down_rep",repeaterWidgetClass,form,
		    XtNfromVert,buttons[i-1],
		    XtNtranslations, trans,
		    XtNvertDistance,0,
		    XtNtop,XawChainBottom,XtNbottom,XawChainBottom,
		    XtNleft,XawChainLeft,XtNright,XawChainLeft,
		    XtNbitmap, downBitmap,
		    XtNsensitive, False,
		    NULL);
    
    XtAddCallback (buttons[i], XtNcallback, length_down,(XtPointer) MD);
    
    label = MW ("bb_zoom_label",labelWidgetClass,w,
		XtNfromHoriz,form,
		XtNborderWidth,0,
		XtNbitmap,zoomBitmap,
		XtNbottom, XtChainTop,XtNtop, XtChainTop,
		XtNleft,XawChainLeft,XtNright,XawChainLeft,		
		NULL);
    
    i++;
    buttons[i] = MW ("bb_zoom_text",asciiTextWidgetClass,w,
		     XtNfromHoriz,label,
		     XtNsensitive, False,
		     XtNeditType, XawtextEdit,
		     XtNwrap, XawtextWrapNever,
		     XtNresize, XawtextResizeWidth,
		     XtNuseStringInPlace, True,
		     XtNlength,MAX_NUMLENGTH,XtNstring,&zoom_text,
		     XtNbottom, XtChainTop,XtNtop, XtChainTop,
		     XtNleft,XawChainLeft,XtNright,XawChainLeft,
		     NULL);
    
    form= MW ("bb_zoom_form",formWidgetClass,w,
	      XtNfromHoriz,buttons[i],
	      XtNhorizDistance,0,
	      XtNborderWidth, 0,
	      XtNtop,XawChainTop,XtNbottom,XawChainTop,
	      XtNleft,XawChainLeft,XtNright,XawChainLeft,
	      NULL);
    
    i++;
    buttons[i]= MW ("bb_zoom_up_rep",repeaterWidgetClass,form,
		    XtNvertDistance,0,
		    XtNtop,XawChainTop,XtNbottom,XawChainTop,
		    XtNleft,XawChainLeft,XtNright,XawChainLeft,
		    XtNbitmap, upBitmap,
		    XtNsensitive, False,
		    NULL);
    
    XtAddCallback (buttons[i], XtNcallback, zoom_up,(XtPointer) MD);
    
    i++;
    buttons[i]= MW ("bb_zoom_down_rep",repeaterWidgetClass,form,
		    XtNfromVert,buttons[i-1],
		    XtNvertDistance,0,
		    XtNtop,XawChainBottom,XtNbottom,XawChainBottom,
		    XtNleft,XawChainLeft,XtNright,XawChainLeft,
		    XtNbitmap, downBitmap,
		    XtNsensitive, False,
		    NULL);
    XtAddCallback (buttons[i], XtNcallback, zoom_down,(XtPointer) MD);
    
}    

void set_beginmark_label(int value)
{
    sprintf(begin_text,"%i",value);
    XtVaSetValues(buttons[B_BEG],XtNstring,begin_text,NULL);
}

void set_lengthmark_label(int value)
{
    sprintf(length_text,"%i",value);
    XtVaSetValues(buttons[B_LENGTH],XtNstring,length_text,NULL);
}

void set_zoom_label(int value)
{
    sprintf(zoom_text,"%i",value);
    XtVaSetValues(buttons[B_ZOOM],XtNstring,zoom_text,NULL);
}

void set_button_state(int beg,int end,bool state)
{
    for (;beg<=end;beg++) {
	XtVaSetValues(buttons[beg],XtNsensitive,state,NULL);
    }
}

void button_state(bool state)
{
    int i;
    static bool backup[B_LAST];
    for (i=0;i<B_LAST;i++) {
	if (state==False) { 
	    XtVaGetValues(buttons[i],XtNsensitive,&backup[i],NULL);
	    XtVaSetValues(buttons[i],XtNsensitive,state,NULL);
	} else {
	    XtVaSetValues(buttons[i],XtNsensitive,backup[i],NULL);
	}
    }
}


void try_record(Widget w, XtPointer client_data, XtPointer call_data)
{
    Main_Data *md=(Main_Data*) client_data;
    
    record_dialog(md);
}

void play_it(Widget w, XtPointer client_data, XtPointer call_data)
{
    void abort_playing();
    Main_Data *md=(Main_Data*) client_data;
    int pid_status;
    
    signal(SIGUSR1,abort_playing);
    menu_state(False);
    if (md->mb->playing) {
	button_state(True);
	kill((pid_t)pid,SIGKILL);
	waitpid((pid_t)pid, &pid_status, 0);
	pid=-1;
	XtRemoveWorkProc(p_id);
	if (last_pos>=0 && last_pos<md->mg->width) clear_line(last_pos);
    } 
    
    md->mb->playing=True;
    button_state(False);
    
    pid= fork();
    if (!pid) {
     	XtDestroyApplicationContext(XtWidgetToApplicationContext(w));
     	play_buffer(md);   
    	exit(0);
    } else if (pid<=0) {
   	md->mb->playing=FALSE;
        button_state(True);
        menu_state(True);
     	return;
    }
    
    last_pos=-1;
    
    if (md->wd->isplay) last_pos=md->wd->markbeg/md->mg->step;
    
    start_clock=clock();
    p_id=XtAppAddWorkProc(XtWidgetToApplicationContext(w),
			  set_playline,(XtPointer) md);
    set_button_state(B_STOP,B_PLAY,True);
    set_cmenu_state(CM_PLAY,CM_ALL,False);
    set_cmenu_state(CM_PLAY,CM_STOP,True);
    watch_cursor(True);
    return;
}

void stop_it(Widget w, XtPointer client_data, XtPointer call_data)
{
    Main_Data *md=(Main_Data*) client_data;
    int pid_status;
    
    if (md->mb->playing) {
	kill((pid_t)pid,SIGKILL);
	waitpid((pid_t)pid, &pid_status, 0);
	pid=-1;
	md->mb->playing=FALSE;
	button_state(True);
	menu_state(True);
	if (last_pos>=0 && last_pos<md->mg->width) clear_line(last_pos);
	watch_cursor(False);
	update_status(md);
    }
    return;
}

void abort_playing()
{
    int pid_status;

    set_button_state(B_STOP,B_PLAY,False);
    signal(SIGUSR1,SIG_IGN);
    waitpid((pid_t)pid, &pid_status,0);
    pid=-1;
    MD->mb->playing=FALSE;
    button_state(True);
    menu_state(True);
    if (MD->wd->ismark||MD->wd->isplay)
      set_beginmark_label(MD->wd->markbeg);
    else
      set_beginmark_label(0);
    if (last_pos>=0 && last_pos<MD->mg->width) clear_line(last_pos);
    watch_cursor(False);
    update_status(MD);
}

Boolean set_playline(XtPointer client_data)
{
    Main_Data *md=(Main_Data*) client_data;
    float sample_time,gone_time;
    int now_pos;
    time_t now_clock;
    Dimension end=md->mg->width;
    
    now_clock=clock();
    sample_time=(float)md->wd->tlength/(float)md->wd->freq;

#if defined(linux) || defined (FreeBSD) || defined(sun)
    gone_time=(float)(now_clock-start_clock)/(float)CLOCKS_PER_SEC;
#elif defined(sgi)
    gone_time=(float)(now_clock-start_clock)/(float)750000;
#endif

    now_pos=((float)md->mg->width*gone_time)/sample_time;

    if (md->wd->ismark) 
      end=(md->wd->markbeg+md->wd->marklength)/md->mg->step;
    if (md->wd->isplay || md->wd->ismark)
      now_pos+=md->wd->markbeg/md->mg->step;

    if (now_pos<=last_pos) return(False);
    
    if (last_pos>=0 && last_pos<md->mg->width) clear_line(last_pos);
    last_pos=now_pos;
    
    if ((!md->mb->playing)||now_pos>=end) {
	if (md->wd->isplay) set_line(md->wd->markbeg/md->mg->step);
	return(True);
    }
    
    set_line(now_pos);
    set_beginmark_label(now_pos*md->mg->step);
    return(False);
}

