// valuerequester.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#include "request.h"
#include "requester.h"

class ChoiceRequester : public TitledRequester {
public:
	ChoiceRequester(const char* title, const char* label,
					const char* names, ChoiceValue& value)
		: TitledRequester(title),
		  requestLabel(label), requestNames(names), theValue(value) {}
protected:
	redefined void configureRequest(Request* request) {
		request->appendChoice(requestLabel, requestNames,
				      &theValue, true);
	}
private:
	const char* requestLabel;
	const char* requestNames;
	ChoiceValue& theValue;
};

//********

template <class T>
class ValueRequester : public TitledRequester {
public:
	ValueRequester(const char* title, const char* label, T& value)
		: TitledRequester(title), requestLabel(label), theValue(value) {}
protected:
	inline redefined void configureRequest(Request* request) {
		request->appendValue(requestLabel, &theValue);
	}
protected:
	const char* requestLabel;
	T& theValue;
};

template <class T>
class RangedValueRequester : public ValueRequester<T> {
public:
	RangedValueRequester(const char* title, const char* label,
			     T& value, const Range& range)
		: ValueRequester<T>(title, label, value), theRange(range) {}
protected:
	inline redefined void configureRequest(Request* request) {
		request->appendValue(requestLabel, &theValue, theRange);
	}
private:
	const Range& theRange;
};

