// mxv_types.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifndef MXV_TYPES_H
#define MXV_TYPES_H

typedef char *addr;
#undef Status /* defined in Xlib.h */
typedef unsigned Status;
enum _Status { Fail=0, Succeed=1 };

#ifdef __cplusplus

#include <InterViews/defs.h>

// these two are used with the query mechanism

typedef boolean (*CharCheckFun)(const char);
typedef unsigned short ChoiceValue;
typedef unsigned char Uchar;
typedef signed char Schar;

// these enums are all 2^n to facilitate the choice dialog process

enum DataType {
	NoData=0, SignedCharData=1, UnsignedCharData=2, MuLawData=4,
	ShortData=8, IntData=16, FloatData=32, DoubleData=64
};

enum FileType {
	Generic_Data=1, Sound_Data=2, LPC_Data=4, PCH_Data=8,
	FFT_Data=16, EVP_Data=32, Pvoc_Data=64
};

enum RangeUnit {
	ChannelUnit=1, ChannelSpecialUnit=2, FrameUnit=4,
	FrameTimeUnit=8, FrameSmpteUnit=16, FrameCDUnit=32
};

enum Response {
	Cancel = -1, NullResponse = 0, Yes = 1, No = 2
};

enum EnvelopeType {
	AbsoluteMagnitude=1, RMSAmplitude=2, Decibels=4, PeakToPeakAmplitude=8
};

enum RunStatus { Error = -1, Stop = 0, Run = 1 };

#define redefined

/* I use libg++'s String class rather than the one in InterViews */

#ifdef String
#undef String
#endif

#endif /* __cplusplus */

#endif /* MXV_TYPES_H */
