// main.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#include <InterViews/world.h>
#include "application.h"
#include "localdefs.h"

static PropertyData properties[] = {
	{ "*HScale*allowShrink", "true" },
    { "*VScale*allowShrink", "true" },
    { "*HorizontalScaleLabel*foreground", "White" },
    { "*HorizontalScaleLabel*background", "Black" },
    { "*VerticalScaleLabel*foreground", "White" },
    { "*VerticalScaleLabel*background", "Black" },
    { "*LPCWindowDisplayChannels", "4" },
    { "*FFTWindowDisplayChannels", "4" },
	{ "*PvocWindowDisplayChannels", "4" },
	{ "*SoundWindow*PlotStyle", "Line" },
    { "*SoundWindowHorizontalScale", "Time" },
    { nil }
};

static OptionDesc options[] = {
	{ "-autoplace", "*AutoPlaceWindows", OptionValueImplicit, "true" },
	{ "-plotwidth", "*PlotWidth", OptionValueNext },
	{ nil }
};

#ifdef __sgi
long gcd(long x, long y) { return gcd((int) x, (int) y); }
#ifdef __ATTR_H__
__attr_t fake__libc_attr = { 0 };
extern __attr_t __libc_attr;
#pragma weak __libc_attr = fake__libc_attr
#endif
#endif

int Debugger::depth = 0;
void usage();
extern void setMemoryHandler();

int main (int argc, char * argv[]) {
	if(argc == 2 && strcmp(argv[1], "-help") == 0)
		usage();
	setMemoryHandler();
	Application app(argc, argv, options, properties);
	return app.Run();
}

void usage() {
	fprintf(stderr, "Usage:  %s%s%s%s%s%s%s%s%s%s",
		"mxv [file1 [-skip <time>] [-duration <time>] file2 ...] [IVArgs] [MXVArgs]\n",
		"Possible file suffixes are:\n",
		".lpc      (linear predictive coding data file)\n",
		".pch      (pitch tracking data file)\n",
		".i or .pv (phase vocoder data file)\n",
		".evp      (envelope data file)\n",
		".fft      (fast fourier transform data file)\n",
		"(any other suffix (including none) will be opened as a sound file.)\n",
		"IVArgs include: -bg -display -fg -fn -geometry -iconic -name -reverse -title\n",
		"MXVArgs are: -autoplace -plotwidth <width in pixels>\n"
		);
	exit(0);
}
