// curvegen.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// CurveGenerator and its associated subclasses are used to create continuous
// interpolated value curves for use in Envelopes.

#ifndef CURVEGEN_H
#ifdef __GNUG__
#pragma interface
#endif
#define CURVEGEN_H

#include "outputfunction.h"

class CurveGenerator : public OutputFunction {
	typedef OutputFunction Super;
	friend class CurveGenerateRequester;
public:
	CurveGenerator(Data* data, double base, double ending);
	CurveGenerator(Data* data);
	redefined double operator () (RunStatus *status);
	redefined void restoreState() { counter = 0; }
protected:
	redefined void initialize();
	virtual double curvePoint(double fraction) = 0;
private:
	int counter;
	int totalLength;
	double baseValue;
	double endValue;
	double height;
};

class DataEditor;

class LinearCurveGenerator : public CurveGenerator {
	typedef CurveGenerator Super;
public:
	LinearCurveGenerator(Data* data, double base, double ending);
	LinearCurveGenerator(Data* data) : CurveGenerator(data) {}
	static Modifier* create(DataEditor *);
protected:
	redefined Requester* createRequester();
	redefined double curvePoint(double fraction) { return fraction; }
};

class ExponentialCurveGenerator : public CurveGenerator {
	typedef CurveGenerator Super;
	friend class ExponentialCurveGenerateRequester;
public:
	ExponentialCurveGenerator(Data*, double base, double endg, double expn);
	ExponentialCurveGenerator(Data* data);
	static Modifier* create(DataEditor *);
protected:
	redefined Requester* createRequester();
	redefined double curvePoint(double fraction);
private:
	double exponent;
};

#endif

