/*==============================================================================

  $Id: marchive.c,v 1.9 1998/09/20 21:45:27 miod Exp $

  Archive support

  These routines are used to detect different archive/compression formats
  and decompress/de-archive the mods from them if necessary.

==============================================================================*/

/*
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
 
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
 
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <unistd.h>
#ifdef NEED_FNMATCH
#include "../extra/fnmatch.h"
#else
#include <fnmatch.h>
#endif
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>

#include <mikmod.h>
#include "player.h"

/* use similar signature idea to "file" to see what format we have... */

ARCHIVE MA_archiver[]={
/* location, marker, extract command, view command, filenames column */
{0,	"PK",	"unzip -p",	"unzip -l",		27},	/* PKZIP archive */
{2,	"-l",	"lha pq",	"lha v",		65},	/* LHA/LZH archive */
{1,	"",	"unarj c",	"unarj l",		 0},	/* ARJ */
{0,	"",	"gzip -dc",	"gzip -l",		27},	/* GZIP */
{0,	"ZOO",	"zoo xpq",	"zoo -list",	50},	/* ZOO */
{0, NULL,   NULL,       NULL,            0}     /* needed to end the array... */
};
/* rightmost column position */
#define MAXCOLUMN 65

int* MA_identify(CHAR* filename,int header_location,CHAR* header_string)
{
	FILE *fp;
	CHAR id[16]; /* hopefully should be big enough for "signature" */

	if(!(fp=fopen(filename,"r")))
		return NULL;

	modfp=fp;
	_mm_rewind(modfp);
	if(header_location)
		_mm_fseek(modfp,header_location,SEEK_SET);

	if(!fread(id,strlen(header_string),1,modfp)) {
		fclose(fp);
		return 0;
	}
	if(!memcmp(id,(CHAR*)header_string,strlen(header_string))) {
		fclose(fp);
		return (int*)1;
	}
	fclose(fp);

	return 0;
}

CHAR* MA_dearchive(CHAR* arc,CHAR* file)
{
	int t;
	int archive=0;
	CHAR *tmp_file;
	CHAR command_buff[PATH_MAX<<1];

	if((!arc)||(!arc[0]))
		return strdup(file);
	if(!(tmp_file=tempnam(getenv("HOME"),".mod")))
		return NULL;

	for(t=0;MA_archiver[t].command;t++) 
		if(MA_identify(arc,MA_archiver[t].location,MA_archiver[t].marker)) {
			sprintf(command_buff,"%s %s \"%s\" >%s 2>/dev/null",
			        MA_archiver[t].command,arc,file,tmp_file);
			archive=1;
			break;
		}

	if(archive) {
		/* display "extracting" message, as this may take some time... */
		display_extractbanner();
		system(command_buff);
	}
	return tmp_file;
}

void MA_FindFiles(PLAYLIST* pl,CHAR* filename)
{
	int t;
	int archive=0;
	CHAR string[PATH_MAX+MAXCOLUMN+1];
	FILE *file;
    struct stat statbuf;

#ifdef MIKMOD_DEBUG
    for(t=0;MA_archiver[t].command;t++)
        if(MA_archiver[t].nameoffset>MAXCOLUMN) {
            fputs("Error: wrong constant MAXCOLUMN in MikMod source\n",stderr);
            return;
        }
#endif

    if (stat(filename,&statbuf))
        return; /* File does not exist or not enough access rights */
    if ((S_ISDIR(statbuf.st_mode))||(S_ISCHR(statbuf.st_mode))||
        (S_ISBLK(statbuf.st_mode)))
        return; /* Directories and devices can't be modules... */

	for(t=0;MA_archiver[t].command;t++) 
		if(MA_identify(filename,MA_archiver[t].location,MA_archiver[t].marker)) {
			archive=t+1;
			break;
		}

	if(archive--) {
		sprintf(string,"%s %s",MA_archiver[archive].listcmd,filename);
		file=popen(string,"r");
		fgets(string,PATH_MAX+MAXCOLUMN+1,file);
		while(!feof(file)) {
			string[strlen(string)-1]=0;
			if(!MA_archiver[archive].nameoffset) {
				/* this won't work with .arj and files embedding whitespaces,
				   but arj shouldn't exist anyway... */
				for(t=0;string[t]!=' ';t++);
				string[t]=0;
			}
			if(!fnmatch("*.[Mm][Oo][Dd]",(string+MA_archiver[archive].nameoffset),0) ||
			   !fnmatch("[Mm][Oo][Dd].*",(string+MA_archiver[archive].nameoffset),0) ||
			   !fnmatch("*.[Ss]3[Mm]",(string+MA_archiver[archive].nameoffset),0) ||
			   !fnmatch("*.[Ss][Tt][Mm]",(string+MA_archiver[archive].nameoffset),0) ||
			   !fnmatch("*.[Mm][Tt][Mm]",(string+MA_archiver[archive].nameoffset),0) ||
			   !fnmatch("*.[Uu][Ll][Tt]",(string+MA_archiver[archive].nameoffset),0) ||
			   !fnmatch("*.[Ii][Tt]",(string+MA_archiver[archive].nameoffset),0) ||
			   !fnmatch("*.[Xx][Mm]",(string+MA_archiver[archive].nameoffset),0)) 
				PL_Add(&playlist,(string+MA_archiver[archive].nameoffset),filename);
			fgets(string,PATH_MAX,file);
		}
		pclose(file);
	} else
		PL_Add(pl,filename,NULL);
}
