/*==============================================================================

  $Id: drv_nos.c,v 1.11 1998/09/20 21:45:16 miod Exp $

  Mikmod driver for no output (actually outputs on /dev/zero)

==============================================================================*/

/*
	This library is free software; you can redistribute it and/or modify
	it under the terms of the GNU Library General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.
 
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Library General Public License for more details.
 
	You should have received a copy of the GNU Library General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <unistd.h>

#include <mikmod.h>

/* mapping parameters */
#define ZEROLEN 32768
static	void* zerobuf=NULL;

BOOL NS_IsThere(void)
{
    return 1;
}

BOOL NS_Init(void)
{
	if(!(zerobuf=_mm_malloc(ZEROLEN)))
		return 1;
	return VC_Init();
}

void NS_Exit(void)
{
	VC_Exit();
	if(zerobuf) {
		free(zerobuf);
		zerobuf=NULL;
	}
}

BOOL NS_Reset(void)
{
	NS_Exit();
	return NS_Init();
}

void NS_Update(void)
{
	if (zerobuf)
		VC_WriteBytes(zerobuf,ZEROLEN);
}

MDRIVER drv_nos={
	NULL,
	"No Sound",
	"Nosound Driver v3.0",
	255,255,

	NS_IsThere,
	VC_SampleLoad,
	VC_SampleUnload,
	VC_SampleSpace,
	VC_SampleLength,
	NS_Init,
	NS_Exit,
	NS_Reset,
	VC_SetNumVoices,
	VC_PlayStart,
	VC_PlayStop,
	NS_Update,
	VC_VoiceSetVolume,
	VC_VoiceSetFrequency,
	VC_VoiceSetPanning,
	VC_VoicePlay,
	VC_VoiceStop,
	VC_VoiceStopped,
	VC_VoiceReleaseSustain,
	VC_VoiceGetPosition,
	VC_VoiceRealVolume
};

