/*==============================================================================

  $Id: mmerror.c,v 1.7 1998/09/20 21:45:15 miod Exp $

  Error handling functions for use with the MMIO and MikMod libraries.
  Register an error handler with _mm_RegisterErrorHandler() and you're all set.

==============================================================================*/

/*
	This library is free software; you can redistribute it and/or modify
	it under the terms of the GNU Library General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.
 
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Library General Public License for more details.
 
	You should have received a copy of the GNU Library General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*

  The global variables _mm_errno, and _mm_critical are set before the error
  handler in called.  See below for the values of these variables.

*/

#include <mmio.h>

CHAR *_mm_errmsg[MMERR_MAX] =
{
/* No error */

    NULL,

/* Generic MikMod Errors [referenced by _mm_error] */

    "Cannot open requested file",
    "Out of memory",

/* Specific Miscellaneous Errors: */

    "Sample load failed - Out of memory",
    "Sample load failed - Out of sample handles",
    "Unknown wave file or sample type",

/* Specific Module Loader [MLOADER.C] errors: */

    "Failure loading module pattern",
    "Failure loading module track",
    "Failure loading module header",
    "Failure loading sampleinfo",
    "Unknown module format",
	"Unknown sample format",
	"Invalid IT sample compressed data",

/* Specific Driver [MDRIVER.C / drivers] errors: */

    "None of the supported sound-devices were detected",
    "Device number out of range",
    "Software mixer failure",
	"Could not open sound device",
	"This driver supports 16 bit linear output only",
    "Unable to set non-blocking mode for audio device",

/* AudioFile driver errors  */

	"Cannot find suitable AudioFile audio port",

/* AIX driver errors */

    "Configuration (init) of audio device failed",
    "Configuration (control) of audio device failed",
    "Configuration (start) of audio device failed",

/* EsounD driver errors */

/* HP-UX driver errors  */

    "Unable to select 16bit-linear sample format",
    "Could not select requested sample-rate",
    "Could not select requested number of channels",
    "Unable to select audio output",
    "Unable to get audio description",
    "Unable to get gain values",
    "Unable to set gain values",
    "Could not set transmission buffer size",

/* Open Sound Spstem driver errors */

	"Could not set fragment size",
	"Could not set sample size",
	"Could not set mono/stereo setting",
	"Could not set sample rate",

/* Silicon Graphics driver errors */

	"Unsupported sample rate",
	"Hardware does not support 16 bit sound",
	"Hardware does not support 8 bit sound",
	"Hardware does not support stereo sound",
	"Hardware does not support mono sound",

/* Sun/Solaris driver errors */

	"Sound device initialization failed",
	"16 bit sound is not supported with uLaw encoding",

};

/* User installed error callback */
_mm_handler *_mm_errorhandler = NULL;
int  _mm_errno = 0;
BOOL _mm_critical = 0;

_mm_handler *_mm_RegisterErrorHandler(_mm_handler *proc)
{
	_mm_handler *oldproc=_mm_errorhandler;

	_mm_errorhandler = proc;
	return oldproc;
}

