.TH XPlaycd 1 "24 Aug 1995"
.UC 4
.SH NAME
xplaycd \- X based audio cd player for cdrom drives
.SH SYNOPSIS
.B xplaycd
[
.B -start
] [
.B -mixer
] [
.B -nomixer
] [
.B -v
] [
.B -display \<display\>
] [
.B -fn \<font\>
]
.SH DESCRIPTION
.I XPlaycd
is a program to play audio cd's on a cdrom-drive.
It runs on plain X. You don't need OpenWindows, Motif or whatever.
.I XPlaycd
features a database which holds cd and track titles of cds. Titles are
displayed automagically as the cd plays. The program has its own editor
which eases adding of new discs. The database is
.I XMcd
compatible, but
.I XMcd
needs Motif.

.SH "THE EDITOR"
To invoke the editor, press the right button anywhere inside the window and
select
.B edit
from the menu. A new editor window will pop up. Fill in the fields then
press 
.B close
or
.B apply
to save your changes.

The editor saves the database in files which have an eight digit hexadecimal
number as filename, in a directory specified by the
.B *cddb
resource. The decimal number is the (hopefully) unique id of the cd and is
used to find the file next time the cd is used again.

.SH "THE PLAYLIST"
You can program the order in which the tracks are played. The program
shows a small button for each track and a button for begin and end of
play respectively.

Pressing the
.B left
mouse button on a track icon will immediately start playing this track.

To change the playing order, press and hold the
.B left
mouse button on a track icon and drag the number to your preferred place.

To double a track, i.e. to play it more than once, press and hold the
.B middle
mouse button on a track icon and drag, you will get a new icon to place at
will while the old one stays in place.

To delete a doubled icon, click on it with the middle button without dragging
it.

To change the beginning and end of play respectively, drag around the
start/end icons. Using these icons, you can skip titles by moving them
after the end mark.

The top right button on the window can be used to endlessly repeat everything
between the start and end marks.

The button showing three question marks will shuffle the tracks inbetween
the start and end marks. A second press of the shuffle button will sort
the tracks back into order.

You can save the playlist by pressing the
.B right
mouse button anywhere in the window and selecting
.B save
from the menu. This will save the playlist in the database together
with the list of track titles.

.SH "MORE ABOUT INSERTING AND EJECTING CDS"
Usually XPlaycd can't detect when you've inserted a new cd and closed the
tray manually.

So if you put a new cd in the drive, you have to press the eject button to
make XPlaycd detect it.

There is an option however, which tells XPlaycd to detect a new disc
automagically as soon as the drive is closed. Since this led to problems
on most systems, the option is disabled by default since Version 2.0.
Use the
.B -emptypoll
option on the command line or set the
.B xplaycd*empyPoll: on
resource.
Please see the
.B RESOURCES
section for more information about resources.
  Problems reported have been flooding of the syslog with
.B \'Please make sure there is a disc in the drive\'
messages and cdrom drives making strange noises.
.TP 0.6i
Note:
The open/close button implementation is a bit broken currently and
might get confused easily. It will be fixed some day...

.SH OPTIONS
Options offered by
.I XPlaycd
are the following:
.TP 0.6i
.B -display \<display\>
Show the control window on the given display.
.TP 0.6i
.B -fn \<font\>
Use this font rather than the default. The given font should be about the
same size like the default font. If not, the window may look ugly.
.TP 0.6i
.B -start
Start playing immediately if possible.
.TP 0.6i
.B -mixer
Use /dev/mixer to adjust the playback volume rather than controlling the
drive directly. Usually xplaycd will autodetect whether it should use this
option.
.TP 0.6i
.B -nomixer
Adjust playback volume by controlling the drive directly. Usually xplaycd
will autodetect whether it should use this option.
.TP 0.6i
.B -emptypoll
Continue polling the drive even if its empty. In that mode,
.I XPlaycd
will automagically detect when someone inserts a cd in the empty drive.
However, polling an empty drive will flood the syslog with nasty warning
messages on most systems, some drives will even make strange noises. For that
reason this is disabled by default since Version 2.0 and you have to press
eject after inserting a new disc.
.TP 0.6i
.B -v
Print current version and exit.

.SH "RESOURCES"
.I XPlaycd
understands a large number of
.I X11
resources which are listed below. These system wide resources usually sit in
a file called
.B /usr/local/lib/app-defaults/XPlaycd
or
.B /usr/lib/X11/app-defaults/XPlaycd
depending on your installation.
Personal resources reside either in 
.B ~/.Xdefaults
or
.B ~/.Xresources
depending on your installation. To put an
.I XPlaycd
resource into your personal resource file, prefix it with the word
.B xplaycd.
After editing your personal file, be sure to run
.B xrdb ~/.Xresources
or
.B xrdb ~/.Xdefaults
to make them work. There is no need for a prefix or an invocation of
.I xrdb
if you change the system wide file.

.SH "STANDARD RESOURCES"
Standard
.I X11
resources with their defaults are shown here. For an explanation of the
standard resources please see the
.I X11
dcumentation.

Standard resources are:

.TP 0.6i
.B *title: XPlaycd
.TP 0.6i
.B *geometry: no default!
.TP 0.6i
.B *iconic: off
.TP 0.6i
.B *background: gray80
.TP 0.6i
.B *foreground: black
.TP 0.6i
.B *font: -b&h-lucida-medium-r-normal-sans-*-120-*-*-p-*-*-*
.TP 0.6i
.B *reverseVideo: off
.TP 0.6i
.B *synchronize: off


.SH "SPECIAL RESOURCES"
Special
.I XPlaycd
resources are:

.TP 0.6i
.B *brightBorder: gray94
.TP 0.6i
.B *darkBorder: gray40
.TP 0.6i
.B *hilightColor: gray72
These settings are responsible for the 3D-look-and-feel of the program.
Just play with the values to see what they do.
.TP 0.6i
.B *autostart: off
Start playing immediately on startup.

.TP 0.6i
.B *emptyPoll: off
Please see -emptypoll commandline option above.

.TP 0.6i
.B *useMixer: auto
This setting actually can be:
.TP 1.6i
<id>
use the mixerDevice to control the volume and use the input with the given id.
This works only if the audio output of your drive is connected to a soundcard.
It doesn't matter where the flat ribbon data cable of the drive is connected
to.
Since soundcard manufacturers don't agree on which input must be used for the
cdrom audio, you might have to try several values here until it works. In a
perfect environment, the id
.I cd
would be the way to go. However, you might have
to try 
.I line, line1, line2
or
.I line3
to get it working.

.TP 1.6i
auto
Works like
.I cd
if mixerDevice is available, works like
.I off
if not. (This is the default)
.TP 1.6i
off
Control the volume directly at the drive. Some drives do
not support this (e.g. Mediavision CDR-H93MV).

.TP 0.6i
.B *mixerDevice: /dev/mixer
The mixer device, this is needed if you define *useMixer to use it.

.TP 0.6i
.B *cdromDevice: /dev/cdrom
This is the devicename of your cdrom.
Please use exactly the same devicename you use for mounting the drive. If you
chose another name for mounting than for playback, 
.I XPlaycd
will not be able to detect when a CD is mounted and may crash your system!
At least, this was the case in 1.3.x series of Linux, dunno what happens
today.
(So, for example, don't use a symbolic link for mounting and the real device
name for playback or the wrath of the kernel shalt come upon you :)

.TP 0.6i
.B *cddb: (none)
The path where
.I XPlaycd
expects the database.
.I XPlaycd
searches this directory and all subdirectories of it.
You are encouraged to change this to some place where you have write access.

.TP 0.6i
.B *systemCddb: (none)
This is an additional read-only database, which may be maintained by someone
else.
.I XPlaycd
searches this directory and all subdirectories of it.

If neither cddb resource is set,
.I XPlaycd
will refuse to use a database and will annoy you with a nasty message each
time a new cd is detected.


.SH TROUBLESHOOTING

.TP 0.4i
.B Q:
It quits with 'xplaycd: Can't open /dev/cdrom: No such file or directory'
.TP 0.4i
.B A:
As root, create a symbolic link from /dev/cdrom to your cdrom device.
For a scsi cdrom, usually this works:
 cd /dev
 ln -s cdrom sr0

.TP 0.4i
.B Q:
It starts up and says 'No disk' even if there is a disk in the drive.
.TP 0.4i
.B A:
Hm, this may have many reasons, check if you have made the right link in /dev.

.TP 0.4i
.B Q:
The volume control doesn't work, it is just an empty bar.
.TP 0.4i
.B A:
You told XPlaycd to use the mixerdevice for volume control and you
don't have such a device or you used the wrong name for it.
To use the mixerdevice, you must have a soundcard.

.TP 0.4i
.B Q:
I don't have the default font, so the program always tells me an annoying
message that it uses a fixed font, how can i get rid of this?
.TP 0.4i
.B A:
Call it as 'xplaycd -fn fixed' or change the font name in the default file.
The default file is usually /usr/lib/X11/app-defaults/XPlaycd

.TP 0.4i
.B Q:
When I try to search forward or backward, it doesn't really work. Sometimes
the program hangs for several seconds doing nothing.
.TP 0.4i
.B A:
Sometimes the drive responds extremely slow to play commands which makes
searching unusable. This happened to me with a scsi cdrom CDR-H93MV on an
Asus SC-200 using the BSD-NCR53C8XX driver from linux 2.0.7. I even had a lock
up once.
The generic NCR53c7,8xx driver however works well. With other hardware your
mileage may vary.

Update: Got a wowie-zowie 10x Pioneer Drive now, this one reacts much smoother
to search commands.

.TP 0.4i
.B Q:
The Volume slider doesn't do anything. I can shift it back and forth but
the volume does not change. What's wrong?
.TP 0.4i
.B A:
If you have your drive connected to a soundcard, then you might have one of
those where the cdrom audio connector is wired to one of the line inputs.
Try setting the useMixer resource to one of the following values and see if
it works: line, line1, line2, line3. You can try this quickly by calling
.B XPlaycd
like this: xplaycd -usemixer <value>

.SH "SEE ALSO"
xmdb(1), xmixer(1)

.SH AUTHOR
Olav Woelfelschneider
   (wosch@rbg.informatik.th-darmstadt.de)

.SH COPYING
Copyright (C) 1994 
 Olav Woelfelschneider
 (wosch@rbg.informatik.th-darmstadt.de)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

