
/* Extended Module Player 
 * Copyright (C) 1996-1998 Claudio Matsuoka and Hipolito Carraro Jr
 * $Id: load.h,v 1.2 1998/10/26 20:45:11 claudio Exp $
 * 
 * This file is part of the Extended Module Player and is distributed
 * under the terms of the GNU General Public License. See doc/COPYING
 * for more information.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "xmpi.h"
#include "xxm.h"
#include "effects.h"
#include "driver.h"

extern char module_name[MODULE_NAME_MAXSIZE];
extern struct xmp_chctl xctl[32];

static char module_type[80];
static char tracker_name[80];

#define LOAD_INIT() { \
    memset (xxh, 0, sizeof (*xxh)); \
    memset (module_name, 0, MODULE_NAME_MAXSIZE); \
    fseek (f, 0, SEEK_SET); \
    *module_type = *tracker_name = 0; \
}

#define MODULE_INFO() { \
    if (opt.verbose) { \
        if (*module_name) report ("Module title   : %s\n", module_name); \
        report ("Module type    : %s\n", module_type); \
        if (*tracker_name) report ("Tracker name  : %s\n", tracker_name); \
        if (xxh->len) report ("Module length  : %d patterns\n", xxh->len); \
    } \
}

#define INSTRUMENT_INIT() { \
    xxih = Ecalloc (sizeof (struct xxm_instrument_header), xxh->ins); \
    xxim = Ecalloc (sizeof (struct xxm_instrument_map), xxh->ins); \
    xxi = Ecalloc (sizeof (struct xxm_instrument*), xxh->ins); \
    xxs = Ecalloc (sizeof (struct xxm_sample), xxh->smp); \
    xxae = Ecalloc (sizeof (uint16*), xxh->ins); \
    xxpe = Ecalloc (sizeof (uint16*), xxh->ins); \
    xxfe = Ecalloc (sizeof (uint16*), xxh->ins); \
}

#define PATTERN_INIT() { \
    xxt = Ecalloc (sizeof (struct xxm_track*), xxh->trk); \
    xxp = Ecalloc (sizeof (struct xxm_pattern*), xxh->pat+1); \
}

#define PATTERN_ALLOC(x) { \
    xxp[x] = Ecalloc (1, sizeof (struct xxm_pattern)+\
    sizeof (struct xxm_trackinfo) * (xxh->chn-1)); \
}

#define TRACK_ALLOC(i) { \
    int j; \
    for (j=0; j < xxh->chn; j++) { \
        xxp[i]->info[j].index = i * xxh->chn + j; \
        xxt[i * xxh->chn + j] = Ecalloc (sizeof (struct xxm_track) + \
            sizeof (struct xxm_event) * xxp[i]->rows, 1); \
        xxt[i * xxh->chn + j]->rows = xxp[i]->rows; \
    } \
}
