/* Extended Module Player 
 * Copyright (C) 1996-1998 Claudio Matsuoka and Hipolito Carraro Jr
 * $Id: formats.c,v 1.4 1998/11/04 15:42:54 claudio Exp $
 * 
 * This file is part of the Extended Module Player and is distributed
 * under the terms of the GNU General Public License. See doc/COPYING
 * for more information.
 */

#include "config.h"

#include <stdlib.h>
#include <StringList.h>
#include "xmpi.h"
#include "formats.h"

struct xmp_fmt_info *__fmt_head;


static void register_fmt(char *suffix, char *tracker, int (*loader) ())
{
   struct xmp_fmt_info *f;

   f = Emalloc(sizeof(struct xmp_fmt_info));

   f->tracker = tracker;
   f->suffix = suffix;
   f->loader = loader;

   if (!__fmt_head)
      __fmt_head = f;
   else {
      struct xmp_fmt_info *i;

      for (i = __fmt_head; i->next; i = i->next);
      i->next = f;
   }

   f->next = NULL;
}


void fmt_register()
{
   register_fmt("XM", "Fast Tracker II", xm_load);
   register_fmt("MOD", "Noise/Fast/Protracker", mod_load);
   register_fmt("S3M", "Scream Tracker 3", s3m_load);
   register_fmt("STM", "Scream Tracker 2", stm_load);
   register_fmt("MTM", "Multitracker", mtm_load);
   register_fmt("MDL", "Digitrakker", mdl_load);
   register_fmt("ULT", "Ultra Tracker", ult_load);
   register_fmt("PTM", "Poly Tracker", ptm_load);
   register_fmt("OKT", "Oktalyzer", okt_load);
   register_fmt("FAR", "Farandole Composer", far_load);
   register_fmt("WOW", "Mod's Grave", NULL);
   /* register_fmt("STIM", "Slamtilt", stim_load); */
   register_fmt("FC-M", "FC-M Packer", fcm_load);
   register_fmt("KRIS", "Kris Tracker", kris_load);
   register_fmt("UNIC", "Unic Tracker", unic_load);
   register_fmt("LAX", "Laxity Tracker", lax_load);
   register_fmt("PRU1", "ProRunner 1.0", pru1_load);
   register_fmt("PRU2", "ProRunner 2.0", pru2_load);
   register_fmt("PM10", "Promizer 1.0c", pm10_load);
   register_fmt("PM18", "Promizer 1.8a", pm18_load);
   register_fmt("AC1D", "AC1D Packer", ac1d_load);
   register_fmt("PP10", "Pha Packer", pha_load);
   register_fmt("XANN", "XANN Packer", xann_load);
   register_fmt("NP1/2/3", "NoisePacker", np_load);
   register_fmt("669", "Composer 669", ssn_load);
#ifdef DRIVER_OSS_SEQ
   register_fmt("AMD", "Amusic Adlib Tracker", amd_load);
   register_fmt("RAD", "Reality Adlib Tracker", rad_load);
   /* register_fmt ("HSC", "HSC Adlib Tracker", hsc_load); */
#endif
   /* register_fmt ("FNK", "Funktracker", fnk_load); */
   register_fmt("ALM", "Aley's modules", alm_load);
   register_fmt("MOD", "Soundtracker 2.2", m15_load);
}
