
#include "widget.h"
#include "../mainwin.h"

void MinimizeWidgets(void)
{
   EDBUG(5, "MinimizeWidgets");
   XIconifyWindow(disp, CurMW->MainWin->win, screen);
   EDBUG_RETURN_;
}

void ScaleWidget(Widget * widget, double scale_w, double scale_h)
{
   int new_w = widget->w * scale_w;
   int new_h = widget->h * scale_h;
   struct _widget *cur;

   EDBUG(5, "ScaleWidget");
   if (!widget || !widget->first)
      EDBUG_RETURN_;
   cur = widget->first;
   widget->w = new_w;
   widget->h = new_h;
   while (cur) {
      switch (cur->type) {
      case BACKGROUND:
	 ResizeBack(cur->widget, new_w, new_h);
	 break;
      case BUTTON:
	 ScaleButton(cur->widget, scale_w, scale_h);
	 break;
      case MULTIBUTTON:
	 ScaleMultiButton(cur->widget, scale_w, scale_h);
	 break;
      case CONTAINER:
	 ScaleContainer(cur->widget, scale_w, scale_h);
	 break;
      case TEXTBOX:
	 ScaleTextBox(cur->widget, scale_w, scale_h);
	 break;
      case SLIDER:
	 ScaleSlider(cur->widget, scale_w, scale_h);
	 break;
      case STATUS:
	 ScaleStatusWin(cur->widget, scale_w, scale_h);
	 break;
      case STRIP:
	 ScaleStrip(cur->widget, scale_w, scale_h);
	 break;
      default:
	 break;
      }
      cur = cur->next;
   }
   EDBUG_RETURN_;
}

void ResizeWidget(Widget * widget, int new_w, int new_h)
{
   ImlibBorder bord;
   int temp_x, temp_y;
   struct _widget *cur;
   ListBox *temp = NULL;

   EDBUG(5, "ResizeWidget");
   if (!widget || !widget->first)
      EDBUG_RETURN_;
   if ((new_w == widget->w) && (new_h == widget->h))
      EDBUG_RETURN_;
   cur = widget->first;
   while (cur) {
      switch (cur->type) {
      case LISTBOX:
	 temp = ((ListBox *) cur->widget);
	 break;
      default:
	 break;
      }
      cur = cur->next;
   }
   if (!temp) {
      ScaleWidget(widget, new_w / widget->w, new_h / widget->h);
      EDBUG_RETURN_;
   }
   cur = widget->first;
   while (cur) {
      switch (cur->type) {
      case BACKGROUND:
	 bord.left = temp->x;
	 bord.right = widget->w - temp->vertical->x - temp->vertical->w;
	 bord.top = temp->y;
	 bord.bottom = widget->h - temp->horizontal->y - temp->horizontal->h;
	 Imlib_set_image_border(imlib, ((Background *) cur->widget)->back->im, &bord);
	 ResizeBack(cur->widget, new_w, new_h);
	 break;
      case LISTBOX:
	 ResizeListBox(cur->widget, new_w - bord.right - bord.left, new_h - bord.bottom - bord.top);
	 break;
      case BUTTON:
	 if (((Button *) cur->widget)->x > (widget->w / 2))
	    temp_x = new_w - (widget->w - ((Button *) cur->widget)->x);
	 else
	    temp_x = ((Button *) cur->widget)->x;
	 if (((Button *) cur->widget)->y > (widget->h / 2))
	    temp_y = new_h - (widget->h - ((Button *) cur->widget)->y);
	 else
	    temp_y = ((Button *) cur->widget)->y;
	 MoveButton(cur->widget, temp_x, temp_y);
	 break;
/*    FIXME: Fill in rest of widgets.. */
      default:
	 break;
      }
      cur = cur->next;
   }
   widget->w = new_w;
   widget->h = new_h;
   EDBUG_RETURN_;
}

void RaiseLowerWidget(Widget * widget)
{
   EDBUG(5, "RaiseLowerWidget");
   if (widget->raised) {
      XLowerWindow(disp, widget->win);
      widget->raised = FALSE;
   }
   else {
      XRaiseWindow(disp, widget->win);
      widget->raised = TRUE;
   }
   EDBUG_RETURN_;
}

void MoveWidget(Widget * widget, Widget * offset, int x, int y)
{
   EDBUG(5, "MoveWidget");
   if (!widget->shaped)
      EDBUG_RETURN_;
   if (offset) {
      x += widget->offset_x;
      y += widget->offset_y;
   }
   XMoveWindow(disp, widget->win, x, y);
   widget->x = x;
   widget->y = y;
   EDBUG_RETURN_;
}

void HideWidget(Widget * widget)
{
   EDBUG(5, "HideWidget");
   if (widget->visible) {
      XUnmapWindow(disp, widget->win);
      widget->visible = FALSE;
   }
   EDBUG_RETURN_;
}

void UnhideWidget(Widget * widget)
{
   EDBUG(5, "UnhideWidget");
   if (!widget->visible) {
      XMapWindow(disp, widget->win);
      widget->visible = TRUE;
   }
   EDBUG_RETURN_;
}

void CreateWidget(Widget * widget)
{
   struct _widget *cur;

   EDBUG(5, "CreateWidget");
   if (!widget || !widget->first)
      EDBUG_RETURN_;
   deferred = TRUE;
   cur = widget->first;
   while (cur) {
      switch (cur->type) {
      case BACKGROUND:
	 CreateBack(cur->widget);
	 widget->win = ((Background *) cur->widget)->win;
	 MoveWidget(widget, CurMW->MainWin, CurMW->MainWin->x, CurMW->MainWin->y);
	 break;
      case BUTTON:
	 CreateButton(cur->widget, widget->win);
	 break;
      case MULTIBUTTON:
	 CreateMultiButton(cur->widget, widget->win);
	 break;
      case SLIDER:
	 CreateSlider(cur->widget, widget->win);
	 break;
      case TEXTBOX:
	 CreateTextBox(cur->widget, widget->win);
	 break;
      case LISTBOX:
	 CreateListBox(cur->widget, widget->win);
	 break;
      case CONTAINER:
	 CreateContainer(cur->widget, widget->win);
	 break;
      case STATUS:
	 CreateStatusWin(cur->widget, widget->win);
	 break;
      case STRIP:
	 CreateStrip(cur->widget, widget->win);
	 break;
      default:
	 break;
      }
      cur = cur->next;
   }
   widget->deferred = FALSE;
   deferred = FALSE;
   widget->visible = TRUE;
   EDBUG_RETURN_;
}

void FreeWidget(Widget * widget)
{
   struct _widget *cur, *temp;

   EDBUG(5, "FreeWidget");
   if (!widget || !widget->first)
      EDBUG_RETURN_;
   if (!widget->deferred)
      HideWidget(widget);
   cur = widget->first;
   while (cur) {
      switch (cur->type) {
      case BACKGROUND:
	 FreeBack(cur->widget);
	 break;
      case BUTTON:
	 FreeButton(cur->widget);
	 break;
      case MULTIBUTTON:
	 FreeMultiButton(cur->widget);
	 break;
      case SLIDER:
	 FreeSlider(cur->widget);
	 break;
      case TEXTBOX:
	 FreeTextBox(cur->widget);
	 break;
      case LISTBOX:
	 FreeListBox(cur->widget);
	 break;
      case CONTAINER:
	 FreeContainer(cur->widget);
      case STATUS:
	 FreeStatusWin(cur->widget);
	 break;
      case STRIP:
	 FreeStrip(cur->widget);
	 break;
      default:
	 break;
      }
      temp = cur;
      cur = cur->next;
      Efree(temp);
      temp = NULL;
   }
   Efree(widget);
   widget = NULL;
   EDBUG_RETURN_;
}

int FindEventWidget(Widget * widget, XEvent ev)
{
   struct _widget *cur;
   int found = FALSE;

   EDBUG(5, "FindEventWidget");
   if (!widget || !widget->first)
      EDBUG_RETURN(FALSE);
   cur = widget->first;
   while (cur && !found) {
      switch (cur->type) {
      case BUTTON:
	 if (isEventButton(cur->widget, ev)) {
	    EventButton(cur->widget, ev);
	    found = TRUE;
	 }
	 break;
      case MULTIBUTTON:
	 if (isEventMultiButton(cur->widget, ev)) {
	    EventMultiButton(cur->widget, ev);
	    found = TRUE;
	 }
	 break;
      case SLIDER:
	 if (isEventSlider(cur->widget, ev)) {
	    EventSlider(cur->widget, ev);
	    found = TRUE;
	 }
	 break;
      case TEXTBOX:
	 if (isEventTextBox(cur->widget, ev)) {
	    found = TRUE;
	    EventTextBox(cur->widget, ev);
	 }
	 break;
      case LISTBOX:
	 if (isEventListBox(cur->widget, ev)) {
	    EventListBox(cur->widget, ev);
	    found = TRUE;
	 }
	 break;
      case CONTAINER:
	 if (isEventContainer(cur->widget, ev)) {
	    EventContainer(cur->widget, ev);
	    found = TRUE;
	 }
	 break;
      case STATUS:
	 if (isEventStatusWin(cur->widget, ev)) {
	    EventStatusWin(cur->widget, ev);
	    found = TRUE;
	 }
	 break;
      case STRIP:
	 if (isEventStrip(cur->widget, ev)) {
	    EventStrip(cur->widget, ev);
	    found = TRUE;
	 }
      default:
	 break;
      }
      cur = cur->next;
   }
   EDBUG_RETURN(found);
}
