
#include "../playlist.h"

typedef struct {
   Window win, parent;
   int x, y, w, h;
   ImageDat *back;
   int state;
   int exposed;
   int visible;
   int fontheight;
   XFontStruct *font_info;
   XFontSet fontset;
   XTextItem *items;
   FnlibFont *fn;
   FnlibStyle fnstyle;
   int use_fn;
   char *fontname;
   Slider *vertical, *horizontal;
   int current_selection;
   int last_selection;
   int click_time;
   PlayList *list;
   int start;
   int forceredraw;
   int action;
} ListBox;

void HideListBox(ListBox * list);
void UnhideListBox(ListBox * list);
void CreateListBox(ListBox * list, Window parent);
ListBox *ConfigListBox(Window parent, FILE * file);
void ResizeListBox(ListBox * list, int new_w, int new_h);
void EventListBox(ListBox * list, XEvent ev);
int isEventListBox(ListBox * list, XEvent ev);
void DisplayListBox(ListBox * list);
void SetPlaylistListBox(ListBox * list, PlayList * plist);
void RedrawListBoxText(ListBox * list);
void FreeListBox(ListBox * list);
