
#include "../emusic.h"

#include "winamp.h"
#include "soritong.h"

#define NONE     0
#define WINAMP   1
#define SORITONG 2

char *origskin;

int skin_type;

int isZip(char *path)
{
   char *temp;

   EDBUG(4, "isZip");
   if (!path)
      EDBUG_RETURN(FALSE);
   if ((temp = strrchr(path, '.')) && (temp + 3)) {
      if (!strcasecmp((temp + 1), "zip"))
	 EDBUG_RETURN(TRUE);
   }
   EDBUG_RETURN(FALSE);
}

char *FindSkin(char *path)
{
   char *returnpath = NULL;
   DIR *dir;
   struct dirent *entry;
   char temp[FILEPATH_LEN_MAX];

   EDBUG(4, "FindSkin");
   if (CheckForWinampSkinAt(path)) {
      returnpath = duplicate(path);
      skin_type = WINAMP;
      EDBUG_RETURN(returnpath);
   }
   if (CheckForSoritongAt(path)) {
      returnpath = duplicate(path);
      skin_type = SORITONG;
      EDBUG_RETURN(returnpath);
   }
   if ((dir = opendir(path)) == NULL)
      EDBUG_RETURN(NULL);
   while ((entry = readdir(dir))) {
      sprintf(temp, "%s/%s", path, entry->d_name);
      if (isdir(temp)) {
	 if (strcmp(".", entry->d_name) && strcmp("..", entry->d_name)) {
	    returnpath = FindSkin(temp);
	    if (returnpath) {
	       closedir(dir);
	       EDBUG_RETURN(returnpath);
	    }
	 }
      }
   }
   closedir(dir);
   EDBUG_RETURN(NULL);
}

char *OpenTempDir(void)
{
   int i;
   static int number = 0;
   char temppath[FILEPATH_LEN_MAX];
   char *tempskindir;

   EDBUG(4, "OpenTempDir");
   i = getpid();
   sprintf(temppath, "/tmp/emusic_convert_%i_%i", i, number);
   number++;
   md(temppath);
   tempskindir = duplicate(temppath);
   EDBUG_RETURN(tempskindir);
}

void MakeThemeBall(char *tempskindir, char *savepath)
{
   char *s;

   EDBUG(3, "MakeThemeBall");
   s = Emalloc(strlen(tempskindir) + strlen(savepath) + 80);
   sprintf(s, "(cd %s ; tar -c * | gzip -- > %s)", tempskindir, savepath);
   system(s);
   Efree(s);
   EDBUG_RETURN_;
}

void Convert(char *ts)
{
   EDBUG(5, "Convert");
   if (skin_type == WINAMP)
      ConvertWinamp(ts);
   else if (skin_type == SORITONG)
      ConvertSoritong(ts);
   EDBUG_RETURN_;
}

int Convert_Skin(char *path)
{
   char *tempskindir;

   EDBUG(5, "Convert_Skin");
   skin_type = NONE;
   origskin = FindSkin(path);
   if (!origskin) {
      fprintf(stderr, "Can't find a skin anywhere below %s\n", path);
      EDBUG_RETURN(1);
   }
   tempskindir = path;
   Convert(tempskindir);
   EDBUG_RETURN(0);
}

int ConvertSkinToThemeball(char *path, char *savepath)
{
   char *tempskindir = NULL;
   char *temptempdir = NULL;
   char *s1;

   EDBUG(3, "ConvertSkinToThemeball");
   skin_type = NONE;
   fprintf(stderr, "Now converting skin %s to theme %s\n", path, savepath);
   if (isZip(path)) {
      temptempdir = OpenTempDir();
      s1 = Emalloc(strlen(path) + strlen(temptempdir) + 48);
      sprintf(s1, "unzip %s -d %s > /dev/null", path, temptempdir);
      system(s1);
      Efree(s1);
   }
   else
      temptempdir = duplicate(path);
   origskin = FindSkin(temptempdir);
   if (!origskin) {
      fprintf(stderr, "Couldn't find skin at %s, exiting\n", path);
      EDBUG_RETURN(1);
   }
   tempskindir = OpenTempDir();
   Convert(tempskindir);
   MakeThemeBall(tempskindir, savepath);
   rmrf(tempskindir);
   if (strcmp(temptempdir, path))
      rmrf(temptempdir);
   fprintf(stderr, "Finished making themeball of %s\n", path);
   EDBUG_RETURN(0);
}
