#include "emusic.h"
#include <esd.h>

Window analyze_win = 0;

int turnOnAnalysis = FALSE;
int turnOffAnalysis = FALSE;
int toggleAnalysisType = FALSE;
int shutdownAnalysis = FALSE;
int changeAnalysisReading = FALSE;
int do_the_analysis = FALSE;

int esd_mon;
int esd_mon_type;
char *an_buffer = NULL;

extern pthread_mutex_t buffer_mutex;
extern int AUSIZ;

void OpenAnalysisStream(int mon_type);

void init_analyze(Window win)
{
   int w, h;
   XWindowAttributes attr;

   EDBUG(5, "init_analysis");
   if (!win || (analysis->current == analysis->first)) {
      do_the_analysis = FALSE;
      EDBUG_RETURN_;
   }
   XGetWindowAttributes(disp, win, &attr);
   w = attr.width;
   h = attr.height;
   analysis->current->size = analysis->current->init_analysis(win, w, h);
   an_buffer = (char *) Emalloc(AUSIZ * sizeof(char));
   memset(an_buffer, 0, AUSIZ * sizeof(char));

   analyze_win = win;
   do_the_analysis = TRUE;
   EDBUG_RETURN_;
}

void analyze(char *buffer, int size)
{
   EDBUG(6, "analyze");
   if (playing && buffer && (size > 0))
      analysis->current->do_analysis(buffer, size);
   EDBUG_RETURN_;
}

void close_analyze(void)
{
   EDBUG(5, "close_analyze");
   if (!do_the_analysis)
      EDBUG_RETURN_;
   analysis->current->close_analysis();
   XClearWindow(disp, analyze_win);
   if (an_buffer)
      Efree(an_buffer);
   an_buffer = NULL;
   do_the_analysis = FALSE;
   analyze_win = 0;
   EDBUG_RETURN_;
}

void toggle_analyze(void)
{
   Window win;

   EDBUG(5, "toggle_analyze");
   win = analyze_win;
   if (do_the_analysis)
      close_analyze();
   if (analysis->current == analysis->first)
      OpenAnalysisStream(esd_mon_type);
   analysis->current = analysis->current->next;
   if (!analysis->current)
      analysis->current = analysis->first;
   analyze_win = win;
   init_analyze(analyze_win);
   EDBUG_RETURN_;
}

void OpenAnalysisStream(int mon_type)
{
   esd_format_t flags = ESD_STREAM | ESD_STEREO | ESD_BITS16;
   int rate = 44100;

   EDBUG(5, "OpenAnalysisStream");
   if (esd_mon > 0)
      esd_close(esd_mon);
   esd_mon = 0;
   if (mon_type) {
      flags |= ESD_RECORD;
      esd_mon = esd_record_stream(flags, rate, NULL, "eMusic recording");
   }
   else {
      flags |= ESD_MONITOR | ESD_PLAY;
      esd_mon = esd_monitor_stream(flags, rate, NULL, "eMusic monitoring");
   }
   if (esd_mon <= 0)
      fprintf(stderr, "Couldn't connect to EsounD to monitor..  no analysis modes\n");
   EDBUG_RETURN_;
}

void *analysis_loop(void *foo)
{
   int read_esd = 0;

   EDBUG(5, "analysis_loop");
   pthread_setcancelstate(PTHREAD_CANCEL_DISABLE, NULL);
   OpenAnalysisStream(0);
   while (1) {
      if (turnOnAnalysis) {
	 if (!do_the_analysis) {
	    OpenAnalysisStream(esd_mon_type);
	    init_analyze(analyze_win);
	 }
	 turnOnAnalysis = FALSE;
      }
      if (turnOffAnalysis) {
	 if (do_the_analysis)
	    close_analyze();
	 turnOffAnalysis = FALSE;
      }
      if (toggleAnalysisType) {
	 toggle_analyze();
	 toggleAnalysisType = FALSE;
      }
      if (shutdownAnalysis) {
	 if (do_the_analysis)
	    close_analyze();
	 esd_close(esd_mon);
	 shutdownAnalysis = FALSE;
      }
      if (changeAnalysisReading) {
	 if (do_the_analysis)
	    OpenAnalysisStream(esd_mon_type);
	 changeAnalysisReading = FALSE;
      }
      usleep(100);
      if (an_buffer && (esd_mon > 0) && do_the_analysis) {
	 read_esd = read(esd_mon, an_buffer, AUSIZ);
	 analyze(an_buffer, read_esd);
      }
   }
   EDBUG_RETURN(NULL);
}

void SpawnAnalysis(void)
{
   pthread_t analysis_thread;
   char *dir = Emalloc(strlen(eMusicDir) + 12);

   EDBUG(2, "SpawnAnalysis");
   sprintf(dir, "%s/%s", eMusicDir, "analyzers");
   InitAnalysis(dir);
   loadconfig("/.emusic/MAIN.analysis");
   Efree(dir);
   esd_mon = 0;
   esd_mon_type = 0;
   pthread_create(&analysis_thread, NULL, analysis_loop, NULL);
   pthread_detach(analysis_thread);
   EDBUG_RETURN_;
}

void SetAnalysisWin(Window win)
{
   EDBUG(3, "SetAnalysisWin");
   if (!analyze_win) {
      analyze_win = win;
      turnOnAnalysis = TRUE;
      fprintf(stderr, "The analysis window is is %ld\n", win);
      EDBUG_RETURN_;
   }
   turnOffAnalysis = TRUE;
   while (turnOffAnalysis)
      usleep(50);
   analyze_win = win;
   fprintf(stderr, "The analysis window id is %ld\n", win);
   turnOnAnalysis = TRUE;
   EDBUG_RETURN_;
}

void KillAnalysisWin(void)
{
   EDBUG(4, "KillAnalysisWin");
   turnOffAnalysis = TRUE;
   EDBUG_RETURN_;
}

void ToggleAnalysisType(void)
{
   EDBUG(4, "ToggleAnalysisType");
   toggleAnalysisType = TRUE;
   EDBUG_RETURN_;
}

void ShutdownAnalysis(void)
{
   EDBUG(4, "ShutdownAnalysis");
   shutdownAnalysis = TRUE;
   while (shutdownAnalysis)
      usleep(50);
   EDBUG_RETURN_;
}

void CheckAnalysisStreamType(int cd_mode)
{
   static int cdmode = FALSE;

   EDBUG(4, "CheckAnalysisStreamType");
   if ((cdmode && cd_mode) || (!cdmode && !cd_mode)) {
      EDBUG_RETURN_;
   }
   else if (cdmode && !cd_mode)
      esd_mon_type = 0;
   else
      esd_mon_type = 1;
   changeAnalysisReading = TRUE;
   cdmode = cd_mode;
   EDBUG_RETURN_;
}
