
#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif

#include <config.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <Imlib.h>
#include "wayve.h"
#include <StringList.h>

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

typedef struct {
   short *buf;
   int bufsize;
   int bufnum;
   int fps;
   int lag;
   XPoint *p;
   Window win;
   int place;
   int w, h;
   int num;
   int data;
} WayveData;

WayveData *w_data;
extern Display *disp;
extern ImlibData *imlib;
extern int screen;
extern Window root;
GC wayve_fg;

void wayve(void)
{
   int x, i;
   static int bnum;
   int origin;
   int num = w_data->bufsize / w_data->w;
   int middle = w_data->h / 2;
   int middle2 = w_data->w / 2;

   bnum = (((int) (w_data->num - w_data->lag) % w_data->bufnum) + w_data->bufnum) % w_data->bufnum;
   origin = bnum * w_data->bufsize * 2;
   XClearWindow(disp, w_data->win);
   XFlush(disp);
   for (x = 0; x < middle2; x++) {
      int val = 0;

      for (i = 0; i < num; i++)
	 val += (int) w_data->buf[origin + (x * num * 2) + (i << 1)];
      val /= 13655;
      w_data->p[(x << 1) + 1].x = w_data->p[(x << 1)].x = x;
      w_data->p[(x << 1)].y = middle;
      w_data->p[(x << 1) + 1].y = middle + val;
   }
   XDrawLines(disp, w_data->win, wayve_fg, w_data->p, w_data->w, CoordModeOrigin);
   for (x = 0; x < middle2; x++) {
      int val = 0;

      for (i = 0; i < num; i++)
	 val += (int) w_data->buf[origin + (x * num * 2) + (i << 1) + 1];
      val /= 13655;
      w_data->p[(x << 1) + 1].x = w_data->p[(x << 1)].x += middle2;
      w_data->p[(x << 1) + 1].y = middle + val;
   }
   XDrawLines(disp, w_data->win, wayve_fg, w_data->p, w_data->w, CoordModeOrigin);
   XFlush(disp);
   w_data->num++;
   if (w_data->num >= w_data->bufnum)
      w_data->num = 0;
}

void do_analysis(char *buffer, int size)
{
   int temp, place;

   temp = w_data->bufsize * 4 - w_data->place;
   place = w_data->num * w_data->bufsize * 2;
   if (size != w_data->bufsize * 4) {
      if (temp == size) {
	 memcpy((char *) &w_data->buf[place] + w_data->place, buffer, size);
	 w_data->place = 0;
	 wayve();
	 return;
      }
      if (size < temp) {
	 memcpy((char *) &w_data->buf[place] + w_data->place, buffer, size);
	 w_data->place += size;
	 return;
      }
      memcpy((char *) &w_data->buf[place] + w_data->place, buffer, temp);
      w_data->place = 0;
      wayve();
      do_analysis(buffer + temp, size - temp);
      return;
   }
   memcpy(&w_data->buf[place] + w_data->place, buffer, size);
   w_data->place = 0;
   wayve();
}

int init_analysis(Window win, int w, int h)
{
   int size;
   int num;

   w_data = Emalloc(sizeof(WayveData));
   w_data->w = w;
   w_data->h = h;
   w_data->win = win;
   w_data->fps = 37;
   w_data->lag = 0;
   w_data->place = 0;
   w_data->bufsize = size = ((44100 / h) / w_data->fps) * w;
   w_data->lag = (w_data->lag * 1200) / size;
   num = w_data->lag + 2;
   w_data->bufnum = num;
   w_data->buf = (short *) Emalloc((size * 4 * num + 40) * sizeof(short));
   memset(w_data->buf, 0, (size * 4 * num + 40) * sizeof(short));

   w_data->num = 0;
   w_data->p = (XPoint *) Emalloc(w * 2 * sizeof(XPoint));
   return w_data->bufsize * 4;
}

void close_analysis(void)
{
   if (!w_data)
      return;
   if (w_data->buf)
      Efree(w_data->buf);
   w_data->buf = NULL;
   if (w_data->p)
      Efree(w_data->p);
   w_data->p = NULL;
   Efree(w_data);
   w_data = NULL;
}

void version_info(char *id, char *version, char *copyright)
{
   strcpy(id, "wayve");
   strcpy(version, "0.2");
   strcpy(copyright, "1996-1998 Carsten Haitzler");
}

void config_analysis(char *left, char *right)
{
   XGCValues gcv;
   int n, r, g, b;

   if (!strncmp("BEGIN", left, 5)) {
      wayve_fg = XCreateGC(disp, root, 0, &gcv);
      XSetForeground(disp, wayve_fg, WhitePixel(disp, screen));
   }
   else if (!strncasecmp("COLOR", left, 5)) {
      n = sscanf(right, "%i %i %i", &r, &g, &b);
      if (n != 3) {
	 fprintf(stderr, "Malformed color in wayve's config..\n");
	 r = g = b = 0;
      }
      XSetForeground(disp, wayve_fg, Imlib_best_color_match(imlib, &r, &g, &b));
   }
}
