#!/usr/bin/python
"""
  palmuser - add/delete/rename stuff relating to Palm users
  $Id: palmuser.py,v 1.1 1998/09/01 11:02:50 rob Exp $

  Copyright 1998 Rob Tillotson <rob@io.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License, version 2,
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.


"""

__version__ = '$Id: palmuser.py,v 1.1 1998/09/01 11:02:50 rob Exp $'

# This is a pretty simple command-line interface to the user manipulation
# stuff in Config.PalmRegistry; later, I might expand it to have more
# error checking, a GUI, and facilities for doing stuff with the user name
# on the PalmPilot as well.

from PDA.Palm import Config

import sys, os, string, getopt, shutil

def usage():
    print """%s -- manipulate PalmPython user directories
    -a <name>            add a user
    -d <name>            delete a user
    -r <name> <newname>  rename a user
    -l                   list users
""" % sys.argv[0]

def main(argv):
    cmd = None
    install = 0
    
    opts, argv = getopt.getopt(argv, 'adrlh')
    for k, v in opts:
	if k == '-a': cmd = 'add'
	elif k == '-d': cmd = 'del'
	elif k == '-r': cmd = 'rename'
	elif k == '-l': cmd = 'list'
	elif k == '-h':
	    usage()
	    sys.exit(0)

    r = Config.PalmRegistry()
    r.load()

    if cmd is None:
	import Tkinter
	import PDA.Palm.Tk.UserDialog
	w = Tkinter.Tk()
	Tkinter.Label(w,text='User Manager').grid(row=0,column=0,sticky='ew')
	Tkinter.Label(w,text='by Rob Tillotson <robt@debian.org>').grid(row=1,
									column=0,
									sticky='ew')
	PDA.Palm.Tk.UserDialog.askuser(w,r)
	
    elif cmd == 'add':
	if len(argv) < 1: raise RuntimeError, 'must specify a user name'
	r.add_user(argv[0])
    elif cmd == 'del':
	if len(argv) < 1: raise RuntimeError, 'must specify a user name'
	r.delete_user(argv[0])
    elif cmd == 'rename':
	if len(argv) < 2: raise RuntimeError, 'must specify two user names'
	r.rename_user(argv[0],argv[1])
    elif cmd == 'list':
	for x in r.list_users():
	    print x


if __name__ == '__main__':
    try: main(sys.argv[1:])
    except SystemExit:
	pass
    except:
	t, v, tb = sys.exc_info()
	sys.stderr.write('%s: %s: %s\n' % (sys.argv[0], t, v))
