"""
  PDA.Palm.Options - Option processing
  $Id: Options.py,v 1.4 1998/09/13 05:12:04 rob Exp $

  Copyright 1998 Rob Tillotson <rob@io.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License, version 2,
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.

"""

STRING = 'string'
INTEGER = 'int'
FLOAT = 'float'
BOOLEAN = 'boolean'
CHOICE = 'choice'
FILENAME = 'filename'

defaults = {
    STRING: '',
    INTEGER: 0,
    FLOAT: 0.0,
    BOOLEAN: None,
    CHOICE: None,
    FILENAME: ''
    }

ValidationError = 'Options.ValidationError'

class Option:
    """An option definition, and possibly its value."""
    def __init__(self, name, type=STRING, default=None, title=None, \
		 description=None, **kw):
	self.name = name
	self.type = type
	self.title = title
	self.description = description
	if not default:
	    self.default = defaults[type]
	else:
	    self.default = default
	self.value = self.default

	for k, v in kw.items():
	    setattr(self, k, v)

    def from_str(self, s):
	pass
    
    def validate(self, value=None):
	return None

class String(Option):
    def __init__(self, name, default=None, title=None, description=None, \
		 match=None, **kw):
	apply(Option.__init__, (self, name, STRING, default, title, description), kw)
	self.match = match

    def from_str(self, s):
	self.validate(s)
	self.value = s
	
    def validate(self, value=None):
	v = value is not None and value or self.value
	if type(v) != type(''):
	    raise ValidationError, 'Type mismatch.'
	if self.match:
	    if not re.match(self.match):
		raise ValidationError, "Failed to match pattern '%s'." % self.match
	    
	
class Integer(Option):
    def __init__(self, name, default=None, title=None, description=None, \
		 min=None, max=None, **kw):
	apply(Option.__init__, (self, name, INTEGER, default, title, description), kw)
	self.min = min
	self.max = max

    def from_str(self, s):
	v = string.atoi(string.strip(s))
	self.validate(v)
	self.value = v
	
    def validate(self, value=None):
	v = value is not None and value or self.value
	if type(v) != type(1):
	    raise ValidationError, 'Type mismatch.'
	if self.min is not None and v < self.min:
	    raise ValidationError, "Value must be at least %s." % self.min
	if self.max is not None and v >= self.max:
	    raise ValidationError, "Value must be less than %s." % self.max
	
class Float(Option):
    def __init__(self, name, default=None, title=None, description=None, \
		 min=None, max=None, **kw):
	apply(Option.__init__, (self, name, FLOAT, default, title, description), kw)
	self.min = min
	self.max = max

    def from_str(self, s):
	v = string.atof(string.strip(s))
	self.validate(v)
	self.value = v
	
    def validate(self, value=None):
	v = value is not None and value or self.value
	if type(v) != type(1.1):
	    raise ValidationError, 'Type mismatch.'
	if self.min is not None and v < self.min:
	    raise ValidationError, "Value must be at least %s." % self.min
	if self.max is not None and v >= self.max:
	    raise ValidationError, "Value must be less than %s." % self.max
	
class Boolean(Option):
    def __init__(self, name, default=None, title=None, description=None, **kw):
	apply(Option.__init__, (self, name, BOOLEAN, default, title, description), kw)

    def from_str(self, s):
	v = string.lower(string.strip(s))
	if v in ['yes', 'true', '1', 'y', 't']:
	    self.value = 1
	else:
	    self.value = 0
	    
class Choice(Option):
    def __init__(self, name, default=None, title=None, description=None, \
		 items=None, values=None, **kw):
	apply(Option.__init__, (self, name, CHOICE, default, title, description), kw)
	self.items = items is not None and items or []
	self.values = values is not None and values or []

    def from_str(self, s):
	s = string.strip(s)
	if s in self.items: self.value = self.values[self.items.index(s)]
	else: self.value = s

class Filename(String):
    def __init__(self, name, default=None, title=None, description=None, \
		 initialdir=None, filetypes=None, **kw):
	apply(String.__init__, (self, name, FILENAME, default, title, description), kw)
	self.initialdir = initialdir
	self.filetypes = filetypes

	
