"""
  PDA.Palm.App.MoneyManager - MoneyManager (StingerSoft ver.)
  $Id: MoneyManager.py,v 1.3 1998/08/29 01:09:01 rob Exp $

  Copyright 1998 Rob Tillotson <rob@io.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License, version 2,
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.


  This module handles databases in the format used by MoneyManager, aka
  PilotMoney.  I have only been able to test this module with data from
  the last shareware version; the file format used by the commercial
  version might be different.
"""

__version__ = '$Id: MoneyManager.py,v 1.3 1998/08/29 01:09:01 rob Exp $'

import PDA.Palm

import struct, string, time

import PDA.Palm._pdapalm

class Record(PDA.Palm.Record):
    def __init__(self, raw='', index=0, id=0, attr=0, category=0):
	self.flags = 0
	self.checknum = 0
	self.amount = 0
	self.total = 0
	self.amountc = 0
	self.totalc = 0
	self.date = 0
	self.repeat = 0
	self.flags2 = 0
	self.type = 0
	self.reserved = ''
	self.description = ''
	self.note = ''
	PDA.Palm.Record.__init__(self, raw, index, id, attr, category)

    def unpack(self, raw):
	self.raw = raw

	self.flags, self.checknum, self.amount, self.total, self.amountc, \
		    self.totalc, sec, min, hr, day, month, year, wkday, \
		    self.repeat, self.flags2, self.type, self.reserved, \
		    self.description = \
		    struct.unpack('>bxHllhhhhhhhhhbbb3s19s', raw[0:55])
	self.note = raw[55:]
	if '\0' in self.note:
	    self.note = self.note[:string.index(self.note,'\0')]
	if '\0' in self.description:
	    self.description = self.description[:string.index(self.description,'\0')]
	self.date = int(time.mktime( (year, month, day, hr, min, sec, 0, 0, -1) ))

    def pack(self):
	tup = time.localtime(self.date)
	if tup[6] >= 6: wkday = 0
	else: wkday = tup[6] + 1
	r = struct.pack('>bxHllhhhhhhhhhbbb3s19s', self.flags, self.checknum,
			self.amount, self.total, self.amountc, self.totalc,
			tup[5], tup[4], tup[3], tup[2], tup[1], tup[0],
			wkday, self.repeat, self.flags2, self.type,
			self.reserved, self.description[:18])
	self.raw = r + self.note + '\0'
	return self.raw
    

class AppBlock(PDA.Palm.AppBlock):
    def __init__(self, *a):
	apply(PDA.Palm.AppBlock.__init__, (self,)+a)

    def unpack(self, raw):
	self.raw = raw
	n = PDA.Palm._pdapalm.unpackCategory(raw, self.__dict__)
	raw = raw[n:]

	self.typelabels = []
	for x in range(0, 20):
	    z = raw[:10]
	    raw = raw[10:]
	    if '\0' in z: z = z[:string.index(z, '\0')]
	    self.typelabels.append(z)

	self.tranlabels = []
	for x in range(0, 20):
	    z = raw[:20]
	    raw = raw[20:]
	    if '\0' in z: z = z[:string.index(z, '\0')]
	    self.tranlabels.append(z)

    def pack(self):
	self.raw = PDA.Palm._pdapalm.packCategory(self.__dict__)

	for l in (self.typelabels + 20*[''])[:20]:
	    self.raw = self.raw + struct.pack('>9s', l) + '\0'

	for l in (self.tranlabels + 20*[''])[:20]:
	    self.raw = self.raw + struct.pack('>19s', l) + '\0'
	return self.raw
    
	

class Database(PDA.Palm.Database):
    def __init__(self, db, info):
	PDA.Palm.Database.__init__(self, db, info)
	self.record_class = Record
	self.appblock_class = AppBlock
	
PDA.Palm.Types.register(Database, {'type': 'MoDT', 'creator': 'Mony'})
