/*  cdrdao - write audio CD-Rs in disc-at-once mode
 *
 *  Copyright (C) 1998  Andreas Mueller <mueller@daneb.ping.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * $Log: GenericMMC.h,v $
 * Revision 1.6  1998/10/24 14:48:55  mueller
 * Added retrieval of next writable address. The Panasonic CW-7502 needs it.
 *
 * Revision 1.5  1998/10/03 15:08:44  mueller
 * Moved 'writeZeros()' to base class 'CdrDriver'.
 * Takes 'writeData()' from base class now.
 *
 * Revision 1.4  1998/09/27 19:18:48  mueller
 * Added retrieval of control nibbles for track with 'analyzeTrack()'.
 * Added multi session mode.
 *
 * Revision 1.3  1998/09/07 15:20:20  mueller
 * Reorganized read-toc related code.
 *
 * Revision 1.2  1998/08/30 19:17:56  mueller
 * Fixed cue sheet generation and first writable address after testing
 * with a Yamaha CDR400t.
 *
 * Revision 1.1  1998/08/15 20:45:26  mueller
 * Initial revision
 *
 */

#ifndef __GENERIC_MMC_H__
#define __GENERIC_MMC_H__

#include "CdrDriver.h"

class Toc;
class Track;

class GenericMMC : public CdrDriver {
public:

  GenericMMC(ScsiIf *scsiIf, Toc *);
  static CdrDriver *instance(ScsiIf *scsiIf, Toc *);

  // MMC compatible drives take little endian samples
  int bigEndianSamples() const { return 0; }

  int speed(int);
  int speed();

  DiskInfo *diskInfo();

  int loadUnload(int) const;
  
  int initDao();
  int startDao();
  int finishDao();

  int driveInfo(DriveInfo *, int showErrorMsg);

protected:
  int scsiTimeout_;
  unsigned char audioModePage_[16]; // saved audio mode page
  Msf leadInStart_; // start of lead-in
  long leadInLen_;  // length of lead-in
  long leadOutLen_; // length if lead-out

  virtual int getSessionInfo();
  virtual long getNWA();

  int getTrackIndex(long, int *, int *);
  int readCatalog(Toc *);
  int readIsrc(int, char *);
  int setPlayParameters();
  int restorePlayParameters();

  virtual int selectSpeed(int readSpeed);
  virtual int setWriteParameters();

  unsigned char *createCueSheet(long *cueSheetLen);
  int sendCueSheet();

  int analyzeTrack(int trackNr, long startLba, long endLba, Msf *index,
		   int *indexCnt, long *pregap, char *isrcCode,
		   unsigned char *ctl);

};

#endif
