/*  VER 246   TAB P   $Id: main.c,v 1.18 1998/09/21 10:04:29 src Exp $
 *
 *  an NNTP news exchange client
 *
 *  copyright 1996, 1997, 1998 Egil Kvaleberg, egil@kvaleberg.no
 *  Husebybakken 14A, N-0379 Oslo, Norway         
 *
 *  this program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  this program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  see the
 *  GNU General Public License for more details.
 *
 *  you should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Log: main.c,v $
 *  Revision 1.18  1998/09/21 10:04:29  src
 *  Added new command line options for --inews
 *
 *  Revision 1.17  1998/09/18 07:30:59  src
 *  Implemented --inews
 *
 *  Revision 1.16  1998/09/13 13:52:05  src
 *  Moved getopt to lib
 *
 *  Revision 1.15  1998/09/11 16:37:44  src
 *  Lockfile for logfile of posted articles and for posted article folder.
 *
 *  Revision 1.14  1998/09/11 09:17:42  src
 *  Check path consistency (--no-path) and length (--max-path)
 *  GNU style option --help, --version, --dry-run, changed --noxx to --no-xx
 *  Check for putenv and setenv, added xstrcpy
 *
 *  Revision 1.13  1998/09/09 07:32:12  src
 *  Version 1.1
 *
 *  Revision 1.12  1998/09/03 02:49:30  src
 *  Fixed stuff detected by -Wall
 *
 *  Revision 1.11  1998/09/02 06:50:31  src
 *  newsx version 1.0
 *
 *  Revision 1.10  1998/09/02 06:34:41  src
 *  Support @-syntax in newsfeeds, and support AUTHINFO GENERIC
 *
 *  Revision 1.9  1998/08/24 06:17:15  src
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "patchlevel.h"

#if HAVE_GETOPT_LONG
#include <getopt.h>
#else
#include "../lib/getopt.h"
#endif

#if HAVE_SYS_STAT_H
#  include <sys/stat.h>
#endif

static void 
pickargs(int argc,char *argv[],char *envp[]);
static void 
numarg(char *arg,int *where, char option);
static void 
usage(void);
static void 
stringarg(char *arg,char **where, char option);
static void 
timearg(char *arg,long *where, char dflt, char option);

char *newline = "\r\n";

/*
 *  main 
 */
int 
main(int argc, char *argv[], char *envp[])
{
    char *p,*q;
    int ok;

    /* initialize and set the name of the program */
    for (q=argv[0]; (p=strchr(q,'/')); ) q = p+1;
    stringarg(q,&pname,0);
    begintitle(argc,argv,envp);

    /* plus some command line defaults */
    nopull_opt = 0;
    inn_opt = INN_MODE;
    minspool = MINSPOOL;
    ai_isgeneric = 0;
    readbeforeauth_opt = 0;
    stat_attempts = -1;
    max_path = 1;

    /* use the default umask for news */
    umask(NEWSUMASK);

    /* parse the args */
    pickargs(argc,argv,envp);

    /* defaults */
    if (!spoolname) spoolname = getenv("NNTPSERVER");
    if (!spooldir) stringarg(SPOOL,&spooldir,0);
    if (stat_attempts < 0) stat_attempts = (window==0) ? 0:2;

    /* do what we were told */
    ok = doit();

    /* remove locks */
    history_done();
    unlock_all();

    return ok;
}

/*
 *  pick arguments from command line
 *  NOTE: the actual command line will be cleared after this
 *        so all strings will be lost and must be thus be copied as reqd.
 */
static void 
pickargs(int argc,char *argv[],char *envp[])
{
    int c;
    char *p;
    char name[PATH_MAX+PATH_MAX];

    for (;;) {
	int option_index = 0;
	static struct option long_options[] = {
	   /* char *name, int has_arg, int *flag, int val */
	    {"auth",            1, 0, 'a'},
	    {"size",            1, 0, 'b'},
	    {"cnews",           0, 0, 'c'},
	    {"verbose",         0, 0, 'd'},
	    {"end",             1, 0, 'e'},
	    {"posted",          1, 0, 'f'},
	    {"nofetch",         0, 0, 'g'},
	    {"no-fetch",        0, 0, 'g'},
	    {"history",         1, 0, 'h'},
	    {"inn",             0, 0, 'i'},
	    {"keep-path",       0, 0, 'k'},
	    {"keeppath",        0, 0, 'k'},
	    {"log",             1, 0, 'l'},
	    {"nomsgid",         0, 0, 'm'},
	    {"no-msgid",        0, 0, 'm'},
	    {"noaction",        0, 0, 'n'},
	    {"dry-run",         0, 0, 'n'},
	    {"keepold",         0, 0, 'o'},
	    {"nopost",          0, 0, 'p'},
	    {"no-post",         0, 0, 'p'},
	    {"enquire",         1, 0, 'q'},
	    {"reader",          0, 0, 'r'},
	    {"spool",           1, 0, 's'},
	    {"timeout",         1, 0, 't'},
	    {"noforce",         0, 0, 'u'},
	    {"no-force",        0, 0, 'u'},
	    {"version",         0, 0, 'v'},
	    {"chat",            1, 0, 'w'},
	    {"exec",            1, 0, 'x'},
	    {"connect",         1, 0, 'y'},
	    {"sync",            0, 0, 'z'},
	    {"active",          1, 0, 'A'},
	    {"batch",           1, 0, 'B'},
	    {"ctlinnd",         1, 0, 'C'},
	    {"debug",           1, 0, 'D'},
	    {"continue",        0, 0, 'E'},
	    {"fail",            1, 0, 'F'},
	    {"newlist",         1, 0, 'G'},
	    {"home",            1, 0, 'H'},
	    {"incoming",        1, 0, 'I'},
	    {"ihave",           0, 0, 'J'},
	    {"inhosts",         1, 0, 'K'},
	    {"list",            1, 0, 'L'},
	    {"missing",         1, 0, 'M'},
	    {"newsfeeds",       1, 0, 'N'},
	    {"bounce",          1, 0, 'O'},
	    {"locks",           1, 0, 'P'},
	    {"stat",            1, 0, 'Q'},
	    {"reset",           0, 0, 'R'},
	    {"sys",             1, 0, 'S'},
	    {"togo",            1, 0, 'T'},
	    {"rnews",           0, 0, 'U'},
	    {"window",          1, 0, 'W'},
	    {"maxnew",          1, 0, 'X'},
	    {"noreader",        0, 0, 'Y'},
	    {"no-reader",       0, 0, 'Y'},
	    {"syncnew",         0, 0, 'Z'},
	    {"help",            0, 0, '?'},
	    {"attach",          1, 0,  1},
	    {"desc",            1, 0,  2},
	    {"alldesc",         1, 0,  3},
	    {"nohostlock",      0, 0,  4},
	    {"no-hostlock",     0, 0,  4},
	    {"nonext",          0, 0,  5},
	    {"no-next",         0, 0,  5},
	    {"mfilter",         1, 0,  6},
	    {"maxart",          1, 0,  7},
	    {"newline",         0, 0,  8},
	    {"nops",            0, 0,  9},
	    {"no-ps",           0, 0,  9},
	    {"authgeneric",     0, 0, 10},
	    {"readbeforeauth",  0, 0, 11},
	    {"no-path",         0, 0, 12},
	    {"max-path",        1, 0, 13},
	    {"inews",           0, 0, 14},
	    {"inews-options",   1, 0, 15},
	    {"add-header",      1, 0, 16},
	    {"pipe-to",         1, 0, 17},
	    {"rnews-to",        1, 0, 18},
	    {0, 0, 0, 0}
	};

	c = getopt_long(argc,argv,
		"a:b:cde:f:gh:ikl:mnopq:rs:t:uvw:x:y:zA:B:H:I:LM:N:RT:W:X:Z?",
		long_options, &option_index);
	if (c == EOF) break;

	switch (c) {
	case 'a':                       /* do an authinfo */
	    if (ai_username) goto usage;
	    get_authinfo(optarg);
	    break;
	case 'b':                       /* min spool size in bytes */
	    numarg(optarg,&minspool,c);
	    break;
	case 'c':                       /* C News mode */
	    inn_opt=0;
	    break;
	case 'd':                       /* debugging on */
	    debug_opt++;
	    break;
	case 'e':                       /* end at tag */
	    for (p=optarg; isspace(*p); ++p) ; /* remove any leading blanks */
	    stringarg(p,&end_tag,c);
	    break;
	case 'f':                       /* folder */
	    stringarg(optarg,&folder,c);
	    break;
	case 'h':                       /* history file */
	    stringarg(optarg,&history,c);
	    if (!history || !history[0]) {
		/* disable history */
		extern int hist_open;
		hist_open = -1;
	    }
	    break;
	case 'g':                       /* don't get news */
	    ++nopull_opt;
	    break;
	case 'i':                       /* INN mode */
	    inn_opt=1;
	    break;
	case 'k':                       /* keep "Path" */
	    keep_path_opt = 1;
	    break;
	case 'l':                       /* logfile */
	    stringarg(optarg,&logfile,c);
	    break;
	case 'n':                       /* do nothing */
	    noaction_opt++;
	    break;
	case 'm':                       /* skip message ID */
	    if (ihave_opt) goto usage;  /* impossible */
	    nomsgid_opt++;
	    break;
	case 'o':                       /* keep .old */
	    keep_old_opt++;
	    break;
	case 'p':                       /* no posting */
	    nopost_opt++;
	    break;
	case 'r':                       /* do a 'MODE READER' */
	    mode_reader_opt = 1;
	    break;
	case 'Y':                       /* don't do a 'MODE READER' */
	    mode_reader_opt = -1;
	    break;
	case 'q':                       /* enquire */
	    stringarg(optarg,&enquire_opt,c);
	    break;
	case 's':                       /* spool */
	    stringarg(optarg,&spooldir,c);
	    break;
	case 't':                       /* timeout in seconds */
	    timearg(optarg,&timeout,'s',c);
	    break;
	case 'u':                       /* no unlock by force */
	    noforce_opt++;
	    break;
	case 'w':                       /* -w chat */
	    stringarg(optarg,&chat_file,c);
	    break;
	case 'v':                       /* version */
	    printf("%s version %s%s\n", pname, VERSION, PATCHLEVEL);
	    /* keep the lawyers busy */
	    printf("%s\n", COPYRIGHT);
	    printf("This is free software; the GNU General Public License applies.\n");
	    printf("There is NO warranty; not even for MERCHANTABILITY or FITNESS FOR A\n");
	    printf("PARTICULAR PURPOSE.\n");
	    unlock_exit(0); /* leave it at that */
	    break;
	case 'x':                       /* -x connect script */
	    stringarg(optarg,&connect_exec,c);
	    break;
	case 'y':                       /* -y connect via */
	    stringarg(optarg,&via_exec,c);
	    break;
	case 'z':                       /* zero incoming */
	    if (reset_opt || zapnew_opt) goto usage;
	    zap_opt++;
	    break;
	case 'A':                       /* active file */
	    stringarg(optarg,&active,c);
	    break;
	case 'B':                       /* batch directory */
	    stringarg(optarg,&batch,c);
	    break;
	case 'C':                       /* ctlinnd program */
	    stringarg(optarg,&ctlpgm,c);
	    break;
	case 'D':                       /* debug */
	    numarg(optarg,&debug_opt,c);
	    break;
	case 'E':                       /* continue, ignoring some errors */
	    ++conterr;
	    break;
	case 'F':                       /* fail after specified time */
	    if (strcmp(optarg,"never")==0) {
		failtime=0;
	    } else {
		timearg(optarg,&failtime,'h',c);
		if (failtime==0) failtime=1;
	    }
	    break;
	case 'G':                       /* get list of new groups */
	    stringarg(optarg,&group_newlist,c);
	    break;
	case 'H':                       /* news home directory */
	    stringarg(optarg,&newshome,c);
	    break;
	case 'I':                       /* incoming directory */
	    stringarg(optarg,&incoming,c);
	    break;
	case 'J':                       /* ihave */
	    if (nomsgid_opt) goto usage;
	    ihave_opt++;
	    break;
	case 'L':                       /* get list of groups */
	    stringarg(optarg,&group_list,c);
	    break;
	case 'K':                       /* in.hosts directory */
	    stringarg(optarg,&inhosts,c);
	    break;
	case 'M':                       /* missing num */
	    numarg(optarg,&stat_attempts,c);
	    break;
	case 'N':                       /* newsfeeds file */
	case 'S':                       /* sys file */
	    stringarg(optarg,&newsfeeds,c);
	    break;
	case 'O':                       /* bounce */
	    stringarg(optarg,&bounce,c);
	    break;
	case 'P':                       /* locks */
	    stringarg(optarg,&locks,c);
	    break;
	case 'Q':                       /* stat */
	    stringarg(optarg,&statfile,c);
	    break;
	case 'R':                       /* reset incoming */
	    if (zap_opt || zapnew_opt) goto usage;
	    reset_opt++;
	    break;
	case 'T':                       /* togo file */
	    stringarg(optarg,&togo,c);
	    break;
	case 'U':                       /* rnews */
	    if (rnews_path) {
	      rnews_and_inews:
		fprintf(stderr,
		"%s: can't combine --inews, --rnews, --rnews-to and --pipe-to\n",
								    pname);
		goto usage;
	    }
	    rnews_opt++;
	    rnews_path = RNEWS_PATH;
	    rnews_name = "rnews";
	    break;
	case 'W':                       /* window size */
	    numarg(optarg,&window,c);
	    break;
	case 'X':                       /* maxnew */
	    numarg(optarg,&max_new,c);
	    break;
	case 'Z':                       /* zero new groups */
	    if (reset_opt || zap_opt) goto usage;
	    zapnew_opt++;
	    break;
	case '?':                       /* help */
	    usage();
	    printf("Report bugs to %s\n", BUGCATCHER);
	    unlock_exit(0); /* that's ok */
	    break;
	case 1:                         /* attach */
	    if (strcmp(optarg,"mime")==0 || strcmp(optarg,"m")==0) {
		attach = 0; /* default */
	    } else if (strcmp(optarg,"yes")==0 || strcmp(optarg,"y")==0) {
		attach = 'y';
	    } else if (strcmp(optarg,"no")==0 || strcmp(optarg,"n")==0) {
		attach = 'n';
	    } else {
		fprintf(stderr,"%s: unknown --attach mode: %s\n",
				pname,                     optarg);
	    }
	    break;
	case 2:                         /* get description of groups */
	    stringarg(optarg,&group_desc,c);
	    break;
	case 3:                         /* get description of all groups */
	    stringarg(optarg,&group_alldesc,c);
	    break;
	case 4:                         /* no host lock */
	    ++no_host_lock;
	    break;
	case 5:                         /* no NEXT command */
	    ++no_next;
	    break;
	case 6:                         /* mfilter */
	    stringarg(optarg,&mfilter,c);
	    break;
	case 7:                         /* maxart */
	    numarg(optarg,&max_articles,c);
	    break;
	case 8:                         /* newline */
	    newline = "\n";
	    break;
	case 9:                         /* nops */
	    ++no_ps;
	    break;
	case 10:
	    /* --authgeneric : authenticate using AUTHINFO GENERIC */
	    /* if we've already parsed an argument specifying authentication */
	    if (ai_username) goto usage;
	    /* might as well grab the NNTPAUTH info now */
	    ai_username = getenv("NNTPAUTH");
	    if (!ai_username) {
		fprintf(stderr,"--authgeneric specified, but NNTPAUTH envariable not set\n");
		unlock_exit(10); /* exit: authinfo error */
	    }
	    /*
	     * the GNU libc docs say that the string returned by getenv()
	     * could be clobbered by another getenv() on some non-GNU systems.
	     * To be safe, we copy it into fresh memory.
	     */
	    ai_username = xstrcpy(ai_username);
	    /*
	     * Note that we are generic. We could do this just by noticing
	     * that for generic the password string will be NULL, but that's
	     * a bit icky :->
	     */
	    ai_isgeneric = 1;
	    break;
	case 11:                        /* do AUTHINFO after MODE READER */
	    readbeforeauth_opt++;
	    break;
	case 12:                        /* don't look at paths */
	    nopath_opt++;
	    break;
	case 13:                        /* maxpath */
	    numarg(optarg,&max_path,c);
	    break;
	case 14:                       /* inews */
	    if (rnews_path) goto rnews_and_inews;
	    inews_opt++;
	    rnews_path = INEWS_PATH;
	    rnews_name = "inews";
	    if (!inews_options) inews_options = "-hOS";
			    /*
			     * -h = complete with headers
			     * -O = don't add organization
			     * -S = don't add signature
			     * -R = reject control messages
			     */
	    break;
	case 15:                        /* inews-options */
	    if (inews_options) inews_options = NULL;
	    stringarg(optarg,&inews_options,c);
	    break;
	case 16:                        /* add-header */
	    stringarg(optarg,&add_header,c);
	    break;
	case 17:                       /* pipe-to */
	    if (rnews_path) goto rnews_and_inews;
	    inews_opt++; /* one message per process mode... */
	    stringarg(optarg,&rnews_path,c);
	    rnews_name = rnews_path;
	    break;
	case 18:                       /* rnews-to */
	    if (rnews_path) goto rnews_and_inews;
	    rnews_opt++; /* continouos mode... */
	    stringarg(optarg,&rnews_path,c);
	    rnews_name = rnews_path;
	    break;
		
	default:
	  usage:
	    /* BUG: have a more complete list! */
	    usage();
	    unlock_exit(2);
	}
    }
	
    /* get spool name */
    if (optind < argc) {
	if (argv[optind][0]) {
	    stringarg(argv[optind],&spoolname,0);
	}
	++optind;
    } 
    if (!enquire_opt && (!spoolname || !spoolname[0])) {
	fprintf(stderr, "spool name missing\n");
	goto usage;
    }

    /* get server name */
    if (optind < argc) {
	if (argv[optind][0]) {
	    stringarg(argv[optind],&hostname,0);
	}
	++optind;
    }
    if (!hostname || !hostname[0]) hostname = spoolname;
	
    /* get port name */
    if (optind < argc) {
	if (argv[optind][0]) {
	    stringarg(argv[optind],&hostport,0);
	}
	++optind;
    } 
    if (!hostport || !hostport[0]) hostport = NNTP_PORT;

    if (optind < argc) {
	fprintf(stderr, "excess arguments\n");
	goto usage;
    }

    /* set the program title for "ps" */
    if (spoolname) {
	sprintf(name,"%s(%s)",pname,spoolname);
	settitle(name);
    }
}

/*
 *  say how to use it
 */
static void 
usage(void)
{
    printf("Usage:\n");
    printf("\tnewsx [options] spoolname [[hostname] port]\n");
    printf("Some commonly used options:\n");
    printf("\t--dry-run      Don't touch anything\n");
    printf("\t--log file     Keep log of posted articles in file\n");
    printf("\t--maxnew N     Fetch at most N articles from a group\n");
    printf("\t--no-post      Don't post\n");
    printf("\t--no-fetch     Don't fetch\n");
    printf("\t--posted file  Copy of all articles posted to file\n");
    printf("\t--verbose      Give more information\n");
    printf("\t--version\n");
    printf("\t--window N     Use a pipeline of size N to speed things up\n");
    printf("For further information, try:\n");
    printf("\tman 8 newsx\n");
}

/*
 *  handle numeric argument
 */
static void 
numarg(char *arg,int *where, char option)
{
    int a;
    char *p;

    a = strtol(arg,&p,10);
    if (p == arg || *p) {
	fprintf(stderr,"%s: bad numeric spec for option -%c: %s\n",
			pname,                       option,  arg);
	return;
    }

    if (*where && *where != a) {
	if (option) {
	    fprintf(stderr,"%s: option -%c was \"%d\", respecified as \"%d\"\n",
			    pname,      option, *where,              a);
	} else {
	    fprintf(stderr,"%s: argument was \"%d\", respecified as \"%d\"\n",
			    pname,            *where,              a);
	}
    }
    *where = a;
}

/*
 *  handle string argument
 *  move to heap
 */
static void 
stringarg(char *arg,char **where, char option)
{
    if (*where) {
	if (option) {
	    fprintf(stderr,"%s: option -%c was \"%s\", respecified as \"%s\"\n",
			    pname,      option, *where,              arg);
	} else {
	    fprintf(stderr,"%s: argument was \"%s\", respecified as \"%s\"\n",
			    pname,            *where,              arg);
	}
    }
    *where = xstrcpy(arg);
}

/*
 *  time multiplier
 */
static int  
timemul(char c, long *where)
{
    switch (c) {
    case 'w': /* weeks */
	*where *= 7;
    case 'd': /* days */
	*where *= 24;
    case 'h': /* hours */
	*where *= 60;
    case 'm': /* minutes */
	*where *= 60;
    case 's': /* seconds */
	return 1;
    default:
	return 0;
    }
}
/*
 *  handle expire time argument
 */
static void 
timearg(char *arg,long *where, char dflt, char option)
{
    int a = 0;
    long n;
    char *p;

    if (*where) {
	fprintf(stderr,"%s: option -%c was respecified as \"%s\"\n",
			pname,      option,                arg);
    }
    *where = 0;
    do {
	++a;
	n = strtol(arg,&p,10);
	if (p == arg) {
	    fprintf(stderr,"%s: bad time spec for option -%c: %s\n",
			    pname,                   option,  arg);
	    break;
	}
	if (timemul(*p,&n)) ++p;
	else if (!*p) timemul(dflt,&n);
	*where += n;
    } while (*(arg = p));
}


