/*  $Id: nonblocking.c,v 1.6 1998/09/21 10:33:32 src Exp $
 *
 *  extracted from INN version 2.0
 *
 *  $Log: nonblocking.c,v $
 *  Revision 1.6  1998/09/21 10:33:32  src
 *  Getting rid of some warnings.
 *
 *  Revision 1.5  1998/09/14 06:30:08  src
 *  More -Wall dbz fixes
 *
 *  Revision 1.4  1998/09/06 06:38:59  src
 *  Moved HAVE_LIBINN to Makefile.am, where it belongs
 *
 *  Revision 1.3  1998/07/12 09:39:20  src
 *  NewsX version 1.0
 */
#include <stdio.h>
#include <sys/types.h>
#include "configdata.h"

#if DBZ_VERSION==6  /*EK*/

#include "clibrary.h"

#include <unistd.h>
#if HAVE_FCNTL_H
#  include <fcntl.h> /*EK*/
#endif
#if HAVE_SYS_IOCTL_H
#  include <sys/ioctl.h> /*EK*/
#endif
#if HAVE_LIBC_H
#  include <libc.h> /*EK* ioctl on NeXT */
#endif

#ifdef FIONBIO /*EK*/

/*
**  Enable or disable non-blocking I/O mode.
*/
int SetNonBlocking(int fd, BOOL flag)
{
    int         state;

    state = flag ? 1 : 0;
    return ioctl(fd, FIONBIO, (char *)&state);
}

#else /* FIONBIO */

#if HAVE_SYS_FILE_H
#  include <sys/file.h>
#endif

#if     !defined(FNDELAY)
#define FNDELAY         O_NDELAY
#endif  /* !defined(FNDELAY) */


/*
**  Enable or disable non-blocking I/O mode.
*/
int SetNonBlocking(int fd, BOOL flag)
{
    int         mode;

    if ((mode = fcntl(fd, F_GETFL, 0)) < 0)
	return -1;
    if (flag)
	mode |= FNDELAY;
    else
	mode &= ~FNDELAY;
    return fcntl(fd, F_SETFL, mode);
}


#endif  /* FIONBIO */

#endif /* DBZ_VERSION *EK*/
